/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import polyglot.frontend.Resource;
import polyglot.frontend.ResourceLoader;
import polyglot.main.Report;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathResourceLoader {
    protected List<File> classpath;
    protected ResourceLoader loader;
    protected static Collection verbose = new HashSet();

    public ClassPathResourceLoader(List<File> classpath) {
        this.classpath = new ArrayList<File>(classpath);
        this.loader = new ResourceLoader();
    }

    public ClassPathResourceLoader(String classpath) {
        this.classpath = new ArrayList<File>();
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            this.classpath.add(new File(s));
        }
        this.loader = new ResourceLoader();
    }

    public String classpath() {
        return this.classpath.toString();
    }

    public boolean dirExists(String name) {
        for (File dir : this.classpath) {
            if (!this.loader.dirExists(dir, name)) continue;
            return true;
        }
        return false;
    }

    public Resource loadResource(String name) {
        if (Report.should_report(verbose, 2)) {
            Report.report(2, "attempting to load class " + name);
            Report.report(2, "classpath = " + this.classpath);
        }
        for (File dir : this.classpath) {
            Resource cf = this.loader.loadResource(dir, name);
            if (cf == null) continue;
            return cf;
        }
        return null;
    }

    static {
        verbose.add("loader");
    }
}

