/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import polyglot.frontend.Resource;
import polyglot.frontend.Source;

public class FileSource
extends Source {
    protected final Resource resource;
    protected Reader reader;

    public FileSource(Resource r) throws IOException {
        this(r, false);
    }

    public Resource resource() {
        return this.resource;
    }

    public FileSource(Resource r, boolean userSpecified) throws IOException {
        super(r.name(), userSpecified);
        this.resource = r;
        if (!r.file().exists()) {
            throw new FileNotFoundException(r.name());
        }
        this.path = r.file().getCanonicalPath();
        this.lastModified = new Date(r.file().lastModified());
    }

    public boolean equals(Object o) {
        if (o instanceof FileSource) {
            FileSource s = (FileSource)o;
            return this.resource.equals(s.resource);
        }
        return false;
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public Reader open() throws IOException {
        if (this.reader == null) {
            this.reader = this.createReader(this.resource.getInputStream());
        }
        return this.reader;
    }

    protected Reader createReader(InputStream str) {
        try {
            return new InputStreamReader(str, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    public String toString() {
        return this.resource.toString();
    }
}

