/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import polyglot.ast.Node;
import polyglot.frontend.CyclicDependencyException;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.FileSource;
import polyglot.frontend.Globals;
import polyglot.frontend.Goal;
import polyglot.frontend.Job;
import polyglot.frontend.Source;
import polyglot.frontend.SourceGoal;
import polyglot.frontend.SourceGoal_c;
import polyglot.frontend.VisitorGoal;
import polyglot.main.Report;
import polyglot.types.ClassDef;
import polyglot.types.Flags;
import polyglot.types.LazyRef;
import polyglot.types.QName;
import polyglot.types.SystemResolver;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Option;
import polyglot.visit.PostCompiled;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Scheduler {
    protected ExtensionInfo extInfo;
    protected Map<Goal, Goal> internCache = new HashMap<Goal, Goal>();
    protected Map<Source, Option<Job>> jobs;
    protected Collection<Job> commandLineJobs;
    protected boolean failed;
    protected static final Option<Job> COMPLETED_JOB = Option.None();
    protected Goal currentGoal;
    Goal EndAll;
    Collection<Job> shouldCompile = new LinkedHashSet<Job>();

    public Goal intern(Goal goal) {
        Globals.Stats().accumulate("intern", 1L);
        Globals.Stats().accumulate("intern:" + (goal instanceof VisitorGoal ? ((VisitorGoal)goal).v.getClass().getName() : goal.getClass().getName()), 1L);
        Goal g = this.internCache.get(goal);
        if (g == null) {
            g = goal;
            this.internCache.put(g, g);
        } else assert (goal.getClass() == g.getClass());
        return g;
    }

    public Scheduler(ExtensionInfo extInfo) {
        this.extInfo = extInfo;
        this.jobs = new LinkedHashMap<Source, Option<Job>>();
        this.currentGoal = null;
    }

    public Collection<Job> commandLineJobs() {
        return this.commandLineJobs;
    }

    public void setCommandLineJobs(Collection<Job> c) {
        this.commandLineJobs = Collections.unmodifiableCollection(c);
    }

    public boolean reached(Goal goal) {
        return goal.hasBeenReached();
    }

    protected void completeJob(Job job) {
        if (job != null) {
            this.jobs.put(job.source(), COMPLETED_JOB);
            if (Report.should_report("frontend", 1)) {
                Report.report(1, "Completed job " + job);
            }
        }
    }

    public List<Goal> prerequisites(Goal goal) {
        return goal.prereqs();
    }

    public Goal End(Job job) {
        return new SourceGoal_c("End", job){

            public boolean runTask() {
                Scheduler.this.completeJob(this.job);
                return true;
            }
        }.intern(this);
    }

    public boolean shouldCompile(Job job) {
        if (this.commandLineJobs().contains(job)) {
            return true;
        }
        if (Globals.Options().compile_command_line_only) {
            return false;
        }
        return this.shouldCompile.contains(job);
    }

    protected Goal PostCompiled() {
        return new PostCompiled(this.extInfo).intern(this);
    }

    protected Goal EndAll() {
        if (this.EndAll == null) {
            this.EndAll = this.PostCompiled();
        }
        return this.EndAll;
    }

    protected Goal EndCommandLine() {
        return this.EndAll();
    }

    public boolean runToCompletion() {
        boolean okay = this.runToCompletion(this.EndAll());
        return okay;
    }

    public boolean runToCompletion(Goal endGoal) {
        boolean okay = false;
        try {
            okay = this.attempt(endGoal);
        }
        catch (CyclicDependencyException cyclicDependencyException) {
            // empty catch block
        }
        if (Report.should_report("frontend", 1)) {
            Report.report(1, "Finished all passes for " + this.getClass().getName() + " -- " + (okay ? "okay" : "failed"));
        }
        return okay;
    }

    public Job loadSource(FileSource source, boolean compile) {
        Job job = this.addJob(source);
        if (job == null) {
            return null;
        }
        this.addDependenciesForJob(job, compile);
        return job;
    }

    public boolean sourceHasJob(Source s) {
        return this.jobs.get(s) != null;
    }

    public Goal currentGoal() {
        return this.currentGoal;
    }

    public Job currentJob() {
        if (this.currentGoal instanceof SourceGoal_c) {
            return ((SourceGoal_c)this.currentGoal).job();
        }
        return null;
    }

    public boolean attempt(Goal goal) throws CyclicDependencyException {
        assert (this.currentGoal() == null || this.currentGoal().getCached() == Goal.Status.RUNNING || this.currentGoal().getCached() == Goal.Status.RUNNING_RECURSIVE || this.currentGoal().getCached() == Goal.Status.RUNNING_WILL_FAIL) : "goal " + this.currentGoal() + " state " + (Object)((Object)this.currentGoal().state());
        Goal.Status state = (Goal.Status)((Object)goal.get());
        return state == Goal.Status.SUCCESS;
    }

    public State pushGlobalState(Goal goal) {
        TypeSystem ts = Globals.TS();
        SystemResolver resolver = ts.systemResolver();
        return new State(resolver);
    }

    public void popGlobalState(Goal goal, State s) {
        TypeSystem ts = Globals.TS();
        if (this.reached(goal)) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean runPass(Goal goal) throws CyclicDependencyException {
        Job job;
        Job job2 = job = goal instanceof SourceGoal ? ((SourceGoal)goal).job() : null;
        if (this.extInfo.getOptions().disable_passes.contains(goal.name())) {
            if (Report.should_report("frontend", 1)) {
                Report.report(1, "Skipping pass " + goal);
            }
            goal.update(Goal.Status.SUCCESS);
            return true;
        }
        if (Report.should_report("frontend", 1)) {
            Report.report(1, "Running pass for " + goal);
        }
        if (this.reached(goal)) {
            throw new InternalCompilerError("Cannot run a pass for completed goal " + goal);
        }
        boolean result = false;
        Report.start_reporting(goal.name());
        if (job != null) {
            job.initialErrorCount = job.compiler().errorQueue().errorCount();
        }
        Goal oldGoal = this.currentGoal;
        this.currentGoal = goal;
        long t = System.currentTimeMillis();
        String key = goal.toString();
        this.extInfo.getStats().accumulate(key + " attempts", 1L);
        this.extInfo.getStats().accumulate("total goal attempts", 1L);
        try {
            result = goal.runTask();
            if (result && goal.getCached() == Goal.Status.RUNNING) {
                this.extInfo.getStats().accumulate(key + " reached", 1L);
                this.extInfo.getStats().accumulate("total goal reached", 1L);
                goal.update(Goal.Status.SUCCESS);
                if (Report.should_report("frontend", 1)) {
                    Report.report(1, "Completed pass for " + goal);
                }
            } else {
                this.extInfo.getStats().accumulate(key + " unreached", 1L);
                this.extInfo.getStats().accumulate("total goal unreached", 1L);
                if (Report.should_report("frontend", 1)) {
                    Report.report(1, "Completed (unreached) pass for " + goal);
                }
            }
        }
        finally {
            int errorCount;
            t = System.currentTimeMillis() - t;
            this.extInfo.getStats().accumulate(key, t);
            this.currentGoal = oldGoal;
            if (job != null && (errorCount = job.compiler().errorQueue().errorCount()) > job.initialErrorCount) {
                job.reportedErrors = true;
            }
            Report.stop_reporting(goal.name());
        }
        if (job != null && this.extInfo.getOptions().print_ast.contains(goal.name())) {
            System.err.println("----------------------------------------------------------------");
            System.err.println("Pretty-printing AST for " + job + " after " + goal.name());
            job.ast().prettyPrint(System.err);
        }
        if (job != null && this.extInfo.getOptions().dump_ast.contains(goal.name())) {
            System.err.println("----------------------------------------------------------------");
            System.err.println("Dumping AST for " + job + " after " + goal.name());
            job.ast().dump(System.err);
        }
        if (!result) {
            this.failed = true;
        }
        if (Report.should_report("frontend", 1)) {
            Report.report(1, "Finished " + goal + " status=" + Scheduler.statusString(result));
        }
        if (job != null) {
            job.updateStatus(result);
        }
        return result;
    }

    protected static String statusString(boolean okay) {
        if (okay) {
            return "done";
        }
        return "failed";
    }

    public Collection<Job> jobs() {
        ArrayList<Job> l = new ArrayList<Job>(this.jobs.size());
        for (Option<Job> o : this.jobs.values()) {
            if (o == COMPLETED_JOB) continue;
            l.add(o.get());
        }
        return l;
    }

    public Job addJob(Source source) {
        return this.addJob(source, null);
    }

    public Job addJob(Source source, Node ast) {
        Option<Job> o = this.jobs.get(source);
        Job job = null;
        if (o == COMPLETED_JOB) {
            return null;
        }
        if (o == null) {
            job = this.createSourceJob(source, ast);
            this.jobs.put(source, new Option.Some<Job>(job));
            if (Report.should_report("frontend", 4)) {
                Report.report(4, "Adding job for " + source + " at the " + "request of goal " + this.currentGoal);
            }
        } else {
            job = o.get();
        }
        return job;
    }

    public abstract List<Goal> goals(Job var1);

    public void addDependenciesForJob(Job job, boolean compile) {
        ExtensionInfo extInfo = this.extInfo;
        List<Goal> goals = this.goals(job);
        Goal prev = null;
        for (Goal goal : goals) {
            if (prev != null) {
                goal.addPrereq(prev);
            }
            if (goal.hasBeenReached()) continue;
            prev = goal;
        }
        assert (prev == this.End(job));
        if (compile) {
            this.shouldCompile.add(job);
            this.EndAll().addPrereq(prev);
        }
    }

    protected Job createSourceJob(Source source, Node ast) {
        return new Job(this.extInfo, this.extInfo.jobExt(), source, ast);
    }

    public String toString() {
        return this.getClass().getName();
    }

    public abstract Goal Parsed(Job var1);

    public abstract Goal ImportTableInitialized(Job var1);

    public abstract Goal TypesInitialized(Job var1);

    public abstract Goal TypesInitializedForCommandLineBarrier();

    public abstract Goal PreTypeCheck(Job var1);

    public abstract Goal TypeChecked(Job var1);

    public abstract Goal ReachabilityChecked(Job var1);

    public abstract Goal ExceptionsChecked(Job var1);

    public abstract Goal ExitPathsChecked(Job var1);

    public abstract Goal InitializationsChecked(Job var1);

    public abstract Goal ConstructorCallsChecked(Job var1);

    public abstract Goal ForwardReferencesChecked(Job var1);

    public abstract Goal Serialized(Job var1);

    public abstract Goal CodeGenerated(Job var1);

    public abstract Goal LookupGlobalType(LazyRef<Type> var1);

    public abstract Goal LookupGlobalTypeDef(LazyRef<ClassDef> var1, QName var2);

    public abstract Goal LookupGlobalTypeDefAndSetFlags(LazyRef<ClassDef> var1, QName var2, Flags var3);

    protected static class Complete
    extends RuntimeException {
        protected Goal goal;

        Complete(Goal goal) {
            this.goal = goal;
        }
    }

    public static class State {
        SystemResolver resolver;

        State(SystemResolver resolver) {
            this.resolver = resolver;
        }
    }
}

