/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import polyglot.frontend.ClassPathResourceLoader;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.FileResource;
import polyglot.frontend.FileSource;
import polyglot.frontend.Resource;
import polyglot.frontend.Source;
import polyglot.main.Report;
import polyglot.types.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceLoader {
    protected ExtensionInfo sourceExt;
    protected List<File> sourcePath;
    protected int caseInsensitive;
    protected Map<Object, Source> loadedSources;
    protected static File current_dir = null;
    ClassPathResourceLoader pathloader;

    public SourceLoader(ExtensionInfo sourceExt, List<File> sourcePath) {
        this.sourcePath = sourcePath;
        this.sourceExt = sourceExt;
        this.caseInsensitive = 0;
        this.loadedSources = new HashMap<Object, Source>();
    }

    public FileSource fileSource(String fileName) throws IOException {
        return this.fileSource(fileName, false);
    }

    public FileSource fileSource(String fileName, boolean userSpecified) throws IOException {
        FileResource r;
        FileSource s;
        File sourceFile = new File(fileName);
        if (!sourceFile.exists()) {
            throw new FileNotFoundException(fileName);
        }
        String[] exts = this.sourceExt.fileExtensions();
        boolean ok = false;
        for (int i = 0; i < exts.length; ++i) {
            String ext = exts[i];
            if (!fileName.endsWith("." + ext)) continue;
            ok = true;
            break;
        }
        if (!ok) {
            String extString = "";
            for (int i = 0; i < exts.length; ++i) {
                if (exts.length == 2 && i == exts.length - 1) {
                    extString = extString + " or ";
                } else if (exts.length != 1 && i == exts.length - 1) {
                    extString = extString + ", or ";
                } else if (i != 0) {
                    extString = extString + ", ";
                }
                extString = extString + "\"." + exts[i] + "\"";
            }
            if (exts.length == 1) {
                throw new IOException("Source \"" + fileName + "\" does not have the extension " + extString + ".");
            }
            throw new IOException("Source \"" + fileName + "\" does not have any of the extensions " + extString + ".");
        }
        if (Report.should_report("loader", 2)) {
            Report.report(2, "Loading class from " + sourceFile);
        }
        if ((s = (FileSource)this.loadedSources.get(this.fileKey(r = new FileResource(sourceFile)))) != null) {
            if (!s.userSpecified && userSpecified) {
                s.setUserSpecified(true);
            }
            return s;
        }
        s = this.sourceExt.createFileSource(r, userSpecified);
        this.loadedSources.put(this.fileKey(r), s);
        return s;
    }

    protected static File current_dir() {
        if (current_dir == null) {
            current_dir = new File(System.getProperty("user.dir"));
        }
        return current_dir;
    }

    public boolean packageExists(QName name) {
        String fileName = name.toString().replace('.', '/');
        boolean result = this.pathloader().dirExists(fileName);
        return result;
    }

    private ClassPathResourceLoader pathloader() {
        if (this.pathloader == null) {
            this.pathloader = new ClassPathResourceLoader(this.sourcePath);
        }
        return this.pathloader;
    }

    public FileSource classSource(QName className) {
        ClassPathResourceLoader loader = this.pathloader();
        String[] exts = this.sourceExt.fileExtensions();
        for (int k = 0; k < exts.length; ++k) {
            String fileName = className.toString().replace('.', File.separatorChar) + "." + exts[k];
            Resource r = loader.loadResource(fileName);
            if (r == null) continue;
            try {
                if (Report.should_report("loader", 2)) {
                    Report.report(2, "Loading " + className + " from " + r);
                }
                FileSource s = this.sourceExt.createFileSource(r, false);
                this.loadedSources.put(this.fileKey(r), s);
                return s;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    public Object fileKey(Resource r) {
        File file = r.file();
        String suffix = r instanceof FileResource ? "" : ":" + r.name();
        try {
            return file.getCanonicalPath() + suffix;
        }
        catch (IOException e) {
            return file.getAbsolutePath() + suffix;
        }
    }
}

