/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import polyglot.frontend.Resource;

public class ZipResource
implements Resource {
    private final ZipFile zip;
    private final String entryName;
    private final File source;

    public ZipResource(File source, ZipFile zip, String entryName) {
        this.zip = zip;
        this.entryName = entryName;
        this.source = source;
    }

    public int hashCode() {
        return this.canonicalPath().hashCode() + this.entryName.hashCode();
    }

    private String canonicalPath() {
        try {
            return this.source.getCanonicalPath();
        }
        catch (IOException e) {
            return this.source.getAbsolutePath();
        }
    }

    public boolean equals(Object o) {
        if (o instanceof ZipResource) {
            ZipResource r = (ZipResource)o;
            return this.canonicalPath().equals(r.canonicalPath()) && this.entryName.equals(r.entryName);
        }
        return false;
    }

    public InputStream getInputStream() throws IOException {
        ZipEntry entry = this.zip.getEntry(this.entryName);
        if (entry == null) {
            throw new ZipException("Entry " + this.entryName + " not found in " + this.zip);
        }
        InputStream in = this.zip.getInputStream(entry);
        return in;
    }

    public File file() {
        return this.source;
    }

    public String name() {
        return this.entryName.substring(this.entryName.lastIndexOf(47) + 1);
    }

    public String toString() {
        return this.source.getPath() + ":" + this.entryName;
    }
}

