/*
 * Decompiled with CFR 0.152.
 */
package polyglot.parse;

import polyglot.ast.Expr;
import polyglot.ast.Id;
import polyglot.ast.NodeFactory;
import polyglot.ast.PackageNode;
import polyglot.ast.Prefix;
import polyglot.ast.QualifierNode;
import polyglot.ast.Receiver;
import polyglot.ast.TypeNode;
import polyglot.types.Package;
import polyglot.types.Ref;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.util.Position;

public class ParsedName {
    public final ParsedName prefix;
    public final Id name;
    public final Position pos;
    public final NodeFactory nf;
    public final TypeSystem ts;

    public ParsedName(NodeFactory nf, TypeSystem ts, Position pos, Id name) {
        this(nf, ts, pos, null, name);
    }

    public ParsedName(NodeFactory nf, TypeSystem ts, Position pos, ParsedName prefix, Id name) {
        this.nf = nf;
        this.ts = ts;
        this.pos = pos != null ? pos : Position.COMPILER_GENERATED;
        this.prefix = prefix;
        this.name = name;
    }

    public Expr toExpr() {
        if (this.prefix == null) {
            return this.nf.AmbExpr(this.pos, this.name);
        }
        return this.nf.Field(this.pos, this.prefix.toReceiver(), this.name);
    }

    public Receiver toReceiver() {
        if (this.prefix == null) {
            return this.nf.AmbReceiver(this.pos, this.name);
        }
        return this.nf.AmbReceiver(this.pos, this.prefix.toPrefix(), this.name);
    }

    public Prefix toPrefix() {
        if (this.prefix == null) {
            return this.nf.AmbPrefix(this.pos, this.name);
        }
        return this.nf.AmbPrefix(this.pos, this.prefix.toPrefix(), this.name);
    }

    public QualifierNode toQualifier() {
        if (this.prefix == null) {
            return this.nf.AmbQualifierNode(this.pos, this.name);
        }
        return this.nf.AmbQualifierNode(this.pos, this.prefix.toQualifier(), this.name);
    }

    public PackageNode toPackage() {
        if (this.prefix == null) {
            return this.nf.PackageNode(this.pos, Types.ref(this.ts.createPackage((Ref<? extends Package>)null, this.name.id())));
        }
        return this.nf.PackageNode(this.pos, Types.ref(this.ts.createPackage(this.prefix.toPackage().package_(), this.name.id())));
    }

    public TypeNode toType() {
        if (this.prefix == null) {
            return this.nf.AmbTypeNode(this.pos, this.name);
        }
        return this.nf.AmbTypeNode(this.pos, this.prefix.toQualifier(), this.name);
    }

    public String toString() {
        if (this.prefix == null) {
            return this.name.toString();
        }
        return this.prefix.toString() + "." + this.name.toString();
    }
}

