/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import polyglot.types.ArrayType;
import polyglot.types.DerefTransform;
import polyglot.types.FieldAsTypeTransform;
import polyglot.types.FieldDef;
import polyglot.types.FieldInstance;
import polyglot.types.MethodAsTypeTransform;
import polyglot.types.MethodDef;
import polyglot.types.MethodInstance;
import polyglot.types.Name;
import polyglot.types.Ref;
import polyglot.types.ReferenceType_c;
import polyglot.types.Resolver;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.Transformation;
import polyglot.util.TransformingList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayType_c
extends ReferenceType_c
implements ArrayType {
    protected Ref<? extends Type> base;
    protected List<FieldDef> fields;
    protected List<MethodDef> methods;
    protected List<Ref<? extends Type>> interfaces;

    protected ArrayType_c() {
    }

    public ArrayType_c(TypeSystem ts, Position pos, Ref<? extends Type> base) {
        super(ts, pos);
        this.base = base;
        this.methods = null;
        this.fields = null;
        this.interfaces = null;
    }

    protected void init() {
        if (this.methods == null) {
            this.methods = new ArrayList<MethodDef>(1);
            MethodDef mi = this.ts.methodDef(this.position(), Types.ref(this), this.ts.Public(), Types.ref(this.ts.Object()), Name.make("clone"), Collections.EMPTY_LIST, Collections.EMPTY_LIST);
            this.methods.add(mi);
        }
        if (this.fields == null) {
            this.fields = new ArrayList<FieldDef>(1);
            FieldDef fi = this.ts.fieldDef(this.position(), Types.ref(this), this.ts.Public().Final(), Types.ref(this.ts.Int()), Name.make("length"));
            fi.setNotConstant();
            this.fields.add(fi);
        }
        if (this.interfaces == null) {
            this.interfaces = new ArrayList<Ref<? extends Type>>(2);
            this.interfaces.add(Types.ref(this.ts.Cloneable()));
            this.interfaces.add(Types.ref(this.ts.Serializable()));
        }
    }

    @Override
    public Ref<? extends Type> theBaseType() {
        return this.base;
    }

    @Override
    public Type base() {
        return Types.get(this.base);
    }

    public ArrayType base(Type base) {
        return this.base(Types.ref(base));
    }

    @Override
    public ArrayType base(Ref<? extends Type> base) {
        if (base == this.base) {
            return this;
        }
        ArrayType_c n = (ArrayType_c)this.copy();
        n.base = base;
        return n;
    }

    @Override
    public Type ultimateBase() {
        if (this.base().isArray()) {
            return this.base().toArray().ultimateBase();
        }
        return this.base();
    }

    @Override
    public int dims() {
        return 1 + (this.base().isArray() ? this.base().toArray().dims() : 0);
    }

    @Override
    public String toString() {
        return this.base.toString() + "[]";
    }

    @Override
    public void print(CodeWriter w) {
        this.base().print(w);
        w.write("[]");
    }

    @Override
    public String translate(Resolver c) {
        return this.base().translate(c) + "[]";
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public ArrayType toArray() {
        return this;
    }

    @Override
    public List<MethodInstance> methods() {
        this.init();
        return new TransformingList<MethodDef, MethodInstance>(this.methods, (Transformation<MethodDef, MethodInstance>)new MethodAsTypeTransform());
    }

    @Override
    public List<FieldInstance> fields() {
        this.init();
        return new TransformingList<FieldDef, FieldInstance>(this.fields, (Transformation<FieldDef, FieldInstance>)new FieldAsTypeTransform());
    }

    @Override
    public MethodInstance cloneMethod() {
        return this.methods().get(0);
    }

    @Override
    public FieldInstance fieldNamed(Name name) {
        FieldInstance fi = this.lengthField();
        return name.equals(fi.name()) ? fi : null;
    }

    @Override
    public FieldInstance lengthField() {
        return this.fields().get(0);
    }

    @Override
    public Type superClass() {
        return this.ts.Object();
    }

    @Override
    public List<Type> interfaces() {
        this.init();
        return new TransformingList(this.interfaces, new DerefTransform());
    }

    @Override
    public int hashCode() {
        return this.base().hashCode() << 1;
    }

    @Override
    public boolean equalsImpl(TypeObject t) {
        if (t instanceof ArrayType) {
            ArrayType a = (ArrayType)t;
            return this.ts.equals((TypeObject)this.base(), (TypeObject)a.base());
        }
        return false;
    }
}

