/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import polyglot.main.Report;
import polyglot.types.AbstractAccessControlResolver;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.Matcher;
import polyglot.types.MemberInstance;
import polyglot.types.Name;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.ParsedTypeObject;
import polyglot.types.QName;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.StructType;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassContextResolver
extends AbstractAccessControlResolver {
    protected Type type;
    private static final Collection TOPICS = CollectionUtil.list("types", "resolver", new String[0]);

    public ClassContextResolver(TypeSystem ts, Type type) {
        super(ts);
        this.type = type;
    }

    public String toString() {
        return "(class-context " + this.type + ")";
    }

    @Override
    public Named find(Matcher<Named> matcher, Context context) throws SemanticException {
        Type sup;
        MemberInstance mi;
        Name name = matcher.name();
        if (Report.should_report(TOPICS, 2)) {
            Report.report(2, "Looking for " + name + " in " + this);
        }
        if (!(this.type instanceof ClassType)) {
            throw new NoClassException(name.toString(), this.type);
        }
        ClassType type = (ClassType)this.type;
        Named m = null;
        QName fullName = null;
        QName rawName = null;
        if (type.isGloballyAccessible()) {
            fullName = QName.make(type.fullName(), name);
            QName q = this.ts.getTransformedClassName((ClassDef)type.def());
            rawName = QName.make(q.qualifier(), Name.make(q.name() + "$" + name));
        }
        if (fullName != null) {
            m = this.ts.systemResolver().check(fullName);
            if (m == null) {
                m = this.ts.systemResolver().check(rawName);
            }
            if (m == null) {
                ParsedTypeObject pto;
                boolean useLoadedResolver = true;
                if (type instanceof ParsedTypeObject && (pto = (ParsedTypeObject)((Object)type)).job() != null) {
                    useLoadedResolver = false;
                }
                if (useLoadedResolver) {
                    try {
                        m = this.ts.systemResolver().find(rawName);
                    }
                    catch (SemanticException e) {
                        // empty catch block
                    }
                }
            }
            if (m != null) {
                try {
                    m = matcher.instantiate(m);
                }
                catch (SemanticException e) {
                    m = null;
                }
            }
        }
        if (m == null) {
            m = type.memberTypeMatching(matcher);
        }
        if (m instanceof ClassType) {
            ClassType mt = (ClassType)m;
            if (!mt.isMember()) {
                throw new SemanticException("Class " + mt + " is not a member class, " + " but was found in " + type + ".");
            }
            if (!mt.outer().equals((Object)type)) {
                throw new SemanticException("Class " + mt + " is not a member class " + " of " + type + ".");
            }
            return mt;
        }
        if (m instanceof MemberInstance && !(mi = (MemberInstance)((Object)m)).container().equals((Object)type)) {
            throw new SemanticException("Type " + mi + " is not a member " + " of " + type + ".");
        }
        if (m != null) {
            if (!this.canAccess(m, context.currentClassDef(), context)) {
                throw new SemanticException("Cannot access member type \"" + m + "\".");
            }
            return m;
        }
        HashSet<Named> acceptable = new HashSet<Named>();
        if (type.superClass() != null && (sup = type.superClass()) instanceof ClassType) {
            Resolver r = this.ts.classContextResolver((ClassType)sup, context);
            try {
                Named n = r.find(matcher);
                acceptable.add(n);
            }
            catch (SemanticException e) {
                // empty catch block
            }
        }
        for (Type sup2 : type.interfaces()) {
            if (!(sup2 instanceof ClassType)) continue;
            Resolver r = this.ts.classContextResolver((ClassType)sup2, context);
            try {
                Named n = r.find(matcher);
                acceptable.add(n);
            }
            catch (SemanticException e) {}
        }
        if (acceptable.size() == 0) {
            throw new NoClassException(name.toString(), type);
        }
        if (acceptable.size() > 1) {
            HashSet<StructType> containers = new HashSet<StructType>(acceptable.size());
            for (Named n : acceptable) {
                if (!(n instanceof MemberInstance)) continue;
                MemberInstance mi2 = (MemberInstance)((Object)n);
                containers.add(mi2.container());
            }
            if (containers.size() == 2) {
                Iterator i = containers.iterator();
                Type t1 = (Type)i.next();
                Type t2 = (Type)i.next();
                throw new SemanticException("Member \"" + name + "\" of " + type + " is ambiguous; it is defined in both " + t1 + " and " + t2 + ".");
            }
            if (containers.size() == 0) {
                throw new SemanticException("Member \"" + name + "\" of " + type + " is ambiguous.");
            }
            throw new SemanticException("Member \"" + name + "\" of " + type + " is ambiguous; it is defined in " + CollectionUtil.listToString(new ArrayList(containers)) + ".");
        }
        assert (acceptable.size() == 1);
        Named t = (Named)acceptable.iterator().next();
        if (Report.should_report(TOPICS, 2)) {
            Report.report(2, "Found member type " + t);
        }
        return t;
    }

    protected boolean canAccess(Named n, ClassDef accessor, Context context) {
        if (n instanceof MemberInstance) {
            return accessor == null || this.ts.isAccessible((MemberInstance)((Object)n), context);
        }
        return true;
    }

    public Type classType() {
        return this.type;
    }
}

