/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import polyglot.main.Report;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.Matcher;
import polyglot.types.Name;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.Package;
import polyglot.types.QName;
import polyglot.types.Ref;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.util.CollectionUtil;
import polyglot.util.Option;
import polyglot.util.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportTable
implements Resolver {
    protected TypeSystem ts;
    protected Map<Object, Option<Named>> map;
    protected List<QName> onDemandImports;
    protected List<Position> onDemandImportPositions;
    protected List<QName> explicitImports;
    protected List<Position> explicitImportPositions;
    protected String sourceName;
    protected Position sourcePos;
    protected Ref<? extends Package> pkg;
    private static final Option<Named> NOT_FOUND = Option.None();
    private static final Collection<String> TOPICS = CollectionUtil.list("types", "resolver", "imports");

    public ImportTable(TypeSystem ts, Ref<? extends Package> pkg) {
        this(ts, pkg, null);
    }

    public ImportTable(TypeSystem ts, Ref<? extends Package> pkg, String src) {
        this.ts = ts;
        this.sourceName = src;
        this.sourcePos = src != null ? new Position(null, src) : null;
        this.pkg = pkg;
        this.map = new HashMap<Object, Option<Named>>();
        this.onDemandImports = new ArrayList<QName>();
        this.onDemandImportPositions = new ArrayList<Position>();
        this.explicitImports = new ArrayList<QName>();
        this.explicitImportPositions = new ArrayList<Position>();
    }

    public Ref<? extends Package> package_() {
        return this.pkg;
    }

    public void addExplicitImport(QName name) {
        this.addExplicitImport(name, null);
    }

    public void addExplicitImport(QName name, Position pos) {
        if (Report.should_report(TOPICS, 2)) {
            Report.report(2, this + ": lazy import " + name);
        }
        this.explicitImports.add(name);
        this.explicitImportPositions.add(pos);
    }

    public void addOnDemandImport(QName containerName, Position pos) {
        if (this.pkg != null && this.pkg.get().fullName().equals(containerName) || this.ts.defaultOnDemandImports().contains(containerName) || this.onDemandImports.contains(containerName)) {
            return;
        }
        this.onDemandImports.add(containerName);
        this.onDemandImportPositions.add(pos);
    }

    public void addOnDemandImport(QName containerName) {
        this.addOnDemandImport(containerName, null);
    }

    public List<QName> onDemandImports() {
        return this.onDemandImports;
    }

    public List<QName> explicitImports() {
        return this.explicitImports;
    }

    public String sourceName() {
        return this.sourceName;
    }

    protected Named cachedFind(Name name) throws SemanticException {
        Option<Named> res = this.map.get(name);
        if (res != null && res != NOT_FOUND) {
            return res.get();
        }
        Named t = this.ts.systemResolver().find(QName.make(null, name));
        this.map.put(name, Option.Some(t));
        return t;
    }

    @Override
    public Named find(Matcher<Named> matcher) throws SemanticException {
        Option<Named> res;
        if (Report.should_report(TOPICS, 2)) {
            Report.report(2, this + ".find(" + matcher.signature() + ")");
        }
        Option<Named> option = res = matcher.key() != null ? this.map.get(matcher.key()) : null;
        if (res != null) {
            if (res == NOT_FOUND) {
                throw new NoClassException(matcher.name().toString(), this.sourcePos);
            }
            return res.get();
        }
        NoClassException ex = null;
        Named resolved = null;
        try {
            resolved = this.lookupExplicit(matcher);
        }
        catch (NoClassException e) {
            ex = e;
        }
        if (resolved == null) {
            Package p = Types.get(this.pkg);
            QName containerName = p != null ? p.fullName() : null;
            Position pos = null;
            resolved = this.findInContainer(matcher, containerName, pos);
        }
        if (resolved == null) {
            try {
                resolved = this.lookupOnDemand(matcher);
            }
            catch (NoClassException e) {
                ex = e;
            }
        }
        if (matcher.key() != null) {
            if (resolved != null) {
                this.map.put(matcher.key(), Option.Some(resolved));
            } else {
                this.map.put(matcher.key(), NOT_FOUND);
            }
        }
        if (resolved != null) {
            return resolved;
        }
        if (ex != null) {
            throw ex;
        }
        throw new NoClassException(matcher.name().toString(), this.sourcePos);
    }

    protected Named lookupOnDemand(Matcher<Named> matcher) throws SemanticException, NoClassException {
        ArrayList<QName> imports = new ArrayList<QName>(this.onDemandImports.size() + 5);
        ArrayList<Position> positions = new ArrayList<Position>(this.onDemandImports.size() + 5);
        imports.addAll(this.ts.defaultOnDemandImports());
        positions.addAll(Arrays.asList(new Position[imports.size()]));
        imports.addAll(this.onDemandImports);
        positions.addAll(this.onDemandImportPositions);
        assert (imports.size() == positions.size());
        Named resolved = null;
        HashSet<QName> tried = new HashSet<QName>();
        for (int i = 0; i < imports.size(); ++i) {
            QName containerName = (QName)imports.get(i);
            Position pos = (Position)positions.get(i);
            if (tried.contains(containerName)) continue;
            tried.add(containerName);
            Named n = this.findInContainer(matcher, containerName, pos);
            if (n == null) continue;
            if (resolved == null) {
                resolved = n;
                continue;
            }
            throw new SemanticException("Reference to " + matcher.signature() + " is ambiguous; both " + resolved + " and " + n + " match.");
        }
        return resolved;
    }

    protected Named findInContainer(Matcher<Named> matcher, QName containerName, Position containerPos) throws SemanticException {
        Named resolved = null;
        if (containerName != null) {
            try {
                Resolver r;
                Named container = this.ts.systemResolver().find(containerName);
                if (container instanceof Package) {
                    r = this.ts.packageContextResolver((Package)container);
                } else if (container instanceof Type) {
                    r = this.ts.classContextResolver((Type)((Object)container));
                } else {
                    return null;
                }
                resolved = r.find(matcher);
            }
            catch (SemanticException e) {
                // empty catch block
            }
        }
        if (resolved == null) {
            Name name = matcher.name();
            try {
                resolved = this.ts.systemResolver().find(QName.make(containerName, name));
                if (resolved != null) {
                    resolved = matcher.instantiate(resolved);
                }
            }
            catch (SemanticException e) {
                return null;
            }
        }
        if (resolved != null && this.isVisibleFromThisPackage(resolved, containerName)) {
            return resolved;
        }
        return null;
    }

    protected boolean isVisibleFromThisPackage(Named n, QName containerName) {
        boolean inSamePackage;
        boolean isVisible = false;
        Package p = Types.get(this.pkg);
        boolean bl = inSamePackage = p != null && p.fullName().equals(containerName) || p == null && containerName == null;
        if (inSamePackage) {
            isVisible = true;
        } else if (n instanceof Type) {
            Type t = (Type)((Object)n);
            if (t.isClass()) {
                ClassType ct = t.toClass();
                isVisible = this.ts.classAccessibleFromPackage((ClassDef)ct.def(), Types.get(this.pkg));
            } else {
                isVisible = true;
            }
        }
        return isVisible;
    }

    protected Named lookupExplicit(Matcher<Named> matcher) throws SemanticException {
        HashSet<QName> tried = new HashSet<QName>();
        for (int i = 0; i < this.explicitImports.size(); ++i) {
            QName longName = this.explicitImports.get(i);
            Position pos = this.explicitImportPositions.get(i);
            if (tried.contains(longName)) continue;
            tried.add(longName);
            if (Report.should_report(TOPICS, 2)) {
                Report.report(2, this + ": import " + longName);
            }
            if (!longName.name().equals(matcher.name())) continue;
            return this.findInContainer(matcher, longName.qualifier(), pos);
        }
        return null;
    }

    public String toString() {
        if (this.sourceName != null) {
            return "(import " + this.sourceName + ")";
        }
        return "(import)";
    }
}

