/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.io.File;
import java.io.InvalidClassException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import polyglot.frontend.ClassPathResourceLoader;
import polyglot.frontend.Resource;
import polyglot.frontend.SchedulerException;
import polyglot.main.Report;
import polyglot.main.Version;
import polyglot.types.BadSerializationException;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.FieldInstance;
import polyglot.types.MethodInstance;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.QName;
import polyglot.types.SemanticException;
import polyglot.types.TopLevelResolver;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.types.reflect.ClassFile;
import polyglot.types.reflect.ClassFileLoader;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.ObjectDumper;
import polyglot.util.SimpleCodeWriter;
import polyglot.util.TypeEncoder;

public class LoadedClassResolver
implements TopLevelResolver {
    protected static final int NOT_COMPATIBLE = -1;
    protected static final int MINOR_NOT_COMPATIBLE = 1;
    protected static final int COMPATIBLE = 0;
    protected TypeSystem ts;
    protected TypeEncoder te;
    protected ClassFileLoader loader;
    protected ClassPathResourceLoader pathloader;
    protected Version version;
    protected Set<QName> nocache;
    protected boolean allowRawClasses;
    protected static final Collection<String> report_topics = CollectionUtil.list("types", "resolver", "loader");
    protected boolean recursive = false;

    public LoadedClassResolver(TypeSystem ts, String classpath, ClassFileLoader loader, Version version, boolean allowRawClasses) {
        this.ts = ts;
        this.te = new TypeEncoder(ts);
        this.loader = loader;
        this.pathloader = new ClassPathResourceLoader(classpath);
        this.version = version;
        this.nocache = new HashSet<QName>();
        this.allowRawClasses = allowRawClasses;
    }

    public boolean allowRawClasses() {
        return this.allowRawClasses;
    }

    public boolean packageExists(QName name) {
        return this.pathloader.dirExists(name.toString().replace('.', File.separatorChar));
    }

    protected ClassFile loadFile(QName name) {
        block6: {
            if (this.nocache.contains(name)) {
                return null;
            }
            try {
                String classFileName = name.toString().replace('.', File.separatorChar) + ".class";
                Resource r = this.pathloader.loadResource(classFileName);
                ClassFile clazz = this.loader.loadClass(r);
                if (clazz == null) {
                    if (Report.should_report(report_topics, 4)) {
                        Report.report(4, "Class " + name + " not found in classpath " + this.pathloader.classpath());
                    }
                    break block6;
                }
                if (Report.should_report(report_topics, 4)) {
                    Report.report(4, "Class " + name + " found in classpath " + this.pathloader.classpath());
                }
                return clazz;
            }
            catch (ClassFormatError e) {
                if (!Report.should_report(report_topics, 4)) break block6;
                Report.report(4, "Class " + name + " format error");
            }
        }
        this.nocache.add(name);
        return null;
    }

    public Named find(QName name) throws SemanticException {
        if (Report.should_report(report_topics, 3)) {
            Report.report(3, "LoadedCR.find(" + name + ")");
        }
        Named result = null;
        ClassFile clazz = this.loadFile(name);
        if (clazz == null) {
            throw new NoClassException(name.toString());
        }
        if (clazz.encodedClassType(this.version.name()) != null) {
            if (Report.should_report(report_topics, 4)) {
                Report.report(4, "Using encoded class type for " + name);
            }
            result = this.getEncodedType(clazz, name);
        }
        if (this.allowRawClasses) {
            if (Report.should_report(report_topics, 4)) {
                Report.report(4, "Using raw class file for " + name);
            }
            result = this.ts.rawify(this.ts.classFileLazyClassInitializer(clazz).type());
        }
        if (result != null) {
            if (name.equals(result.fullName())) {
                return result;
            }
            if (result instanceof ClassType && name.equals(this.ts.getTransformedClassName((ClassDef)((ClassType)result).def()))) {
                return result;
            }
        }
        throw new SemanticException("Unable to find a suitable definition of \"" + name + "\". A class file was found," + " but it did not contain appropriate information for this" + " language extension. If the source for this file is written" + " in the language extension, try recompiling the source code.");
    }

    protected ClassType getEncodedType(ClassFile clazz, QName name) throws SemanticException {
        TypeObject dt;
        int comp = this.checkCompilerVersion(clazz.compilerVersion(this.version.name()));
        if (comp == -1) {
            throw new SemanticException("Unable to find a suitable definition of " + clazz.name() + ". Try recompiling or obtaining " + " a newer version of the class file.");
        }
        try {
            if (Report.should_report("serialize", 1)) {
                Report.report(1, "Decoding " + name + " in " + clazz);
            }
            if ((dt = this.te.decode(clazz.encodedClassType(this.version.name()), name)) == null) {
                if (Report.should_report("serialize", 1)) {
                    Report.report(1, "* Decoding " + name + " failed");
                }
                throw new SchedulerException("Could not decode " + name);
            }
        }
        catch (InternalCompilerError e) {
            throw e;
        }
        catch (InvalidClassException e) {
            throw new BadSerializationException(clazz.name());
        }
        if (dt instanceof ClassType) {
            ClassType ct = (ClassType)dt;
            this.ts.systemResolver().addNamed(name, ct);
            if (Report.should_report("serialize", 1)) {
                Report.report(1, "* Decoding " + name + " succeeded");
            }
            if (Report.should_report("typedump", 1)) {
                new ObjectDumper(new SimpleCodeWriter(System.out, 72)).dump(dt);
            }
            if (Report.should_report("serialize", 2)) {
                for (MethodInstance mi : ct.methods()) {
                    Report.report(2, "* " + mi);
                }
                for (FieldInstance fi : ct.fields()) {
                    Report.report(2, "* " + fi);
                }
                for (ConstructorInstance ci : ct.constructors()) {
                    Report.report(2, "* " + ci);
                }
            }
            if (Report.should_report(report_topics, 2)) {
                Report.report(2, "Returning serialized ClassType for " + clazz.name() + ".");
            }
            return ct;
        }
        throw new SemanticException("Class " + name + " not found in " + clazz.name() + ".");
    }

    protected int checkCompilerVersion(String clazzVersion) {
        if (clazzVersion == null) {
            return -1;
        }
        StringTokenizer st = new StringTokenizer(clazzVersion, ".");
        try {
            int v = Integer.parseInt(st.nextToken());
            Version version = this.version;
            if (v != version.major()) {
                return -1;
            }
            v = Integer.parseInt(st.nextToken());
            if (v != version.minor()) {
                return 1;
            }
        }
        catch (NumberFormatException e) {
            return -1;
        }
        return 0;
    }
}

