/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import polyglot.types.AnotherCachingResolver;
import polyglot.types.Name;
import polyglot.types.Package;
import polyglot.types.QName;
import polyglot.types.Ref;
import polyglot.types.Resolver;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeObject_c;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.util.CodeWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Package_c
extends TypeObject_c
implements Package {
    protected Ref<? extends Package> prefix;
    protected Name name;
    protected String fullname = null;
    protected transient Resolver memberCache;

    protected Package_c() {
    }

    public Package_c(TypeSystem ts) {
        this(ts, null, null);
    }

    public Package_c(TypeSystem ts, Name name) {
        this(ts, null, name);
    }

    public Package_c(TypeSystem ts, Ref<? extends Package> prefix, Name name) {
        super(ts);
        this.prefix = prefix;
        this.name = name;
    }

    @Override
    public boolean isGloballyAccessible() {
        return true;
    }

    @Override
    public Resolver resolver() {
        if (this.memberCache == null) {
            this.memberCache = new AnotherCachingResolver(this.ts.createPackageContextResolver(this));
        }
        return this.memberCache;
    }

    @Override
    public Object copy() {
        Package_c n = (Package_c)super.copy();
        n.memberCache = null;
        return n;
    }

    @Override
    public boolean equalsImpl(TypeObject o) {
        Package p;
        if (o instanceof Package && this.name.equals((p = (Package)o).name())) {
            if (this.prefix == null) {
                return p.prefix() == null;
            }
            return this.prefix.equals(p.prefix());
        }
        return false;
    }

    @Override
    public boolean packageEquals(Package p) {
        if (p == null) {
            return false;
        }
        if (this.name.equals(p.name())) {
            if (this.prefix == null) {
                return p.prefix() == null;
            }
            return this.ts.packageEquals(Types.get(this.prefix), Types.get(p.prefix()));
        }
        return false;
    }

    @Override
    public boolean isType() {
        return false;
    }

    @Override
    public boolean isPackage() {
        return true;
    }

    @Override
    public Type toType() {
        return null;
    }

    @Override
    public Package toPackage() {
        return this;
    }

    @Override
    public Ref<? extends Package> prefix() {
        return this.prefix;
    }

    @Override
    public Name name() {
        return this.name;
    }

    @Override
    public String translate(Resolver c) {
        if (this.prefix() == null) {
            return this.name().toString();
        }
        return this.prefix().get().translate(c) + "." + this.name();
    }

    @Override
    public QName fullName() {
        return QName.make(this.prefix() != null ? this.prefix().get().fullName() : null, this.name);
    }

    public String toString() {
        String s = (this.prefix() != null ? this.prefix().toString() + "." : "") + this.name;
        return s;
    }

    @Override
    public void print(CodeWriter w) {
        if (this.prefix() != null) {
            this.prefix().get().print(w);
            w.write(".");
            w.allowBreak(2, 3, "", 0);
        }
        w.write(this.name.toString());
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }
}

