/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import polyglot.types.Context;
import polyglot.types.DerefTransform;
import polyglot.types.MemberInstance;
import polyglot.types.ProcedureDef;
import polyglot.types.ProcedureInstance;
import polyglot.types.Ref;
import polyglot.types.StructType;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.TypeSystem_c;
import polyglot.types.Use_c;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.SubtypeSet;
import polyglot.util.TransformingList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcedureInstance_c<T extends ProcedureDef>
extends Use_c<T>
implements ProcedureInstance<T> {
    protected List<Type> formalTypes;
    protected List<Type> throwTypes;

    protected ProcedureInstance_c(TypeSystem ts, Position pos, Ref<? extends T> def) {
        super(ts, pos, def);
    }

    @Override
    public ProcedureInstance<T> formalTypes(List<Type> formalTypes) {
        ProcedureInstance_c p = (ProcedureInstance_c)this.copy();
        p.formalTypes = formalTypes;
        return p;
    }

    @Override
    public ProcedureInstance<T> throwTypes(List<Type> throwTypes) {
        ProcedureInstance_c p = (ProcedureInstance_c)this.copy();
        p.throwTypes = throwTypes;
        return p;
    }

    @Override
    public List<Type> formalTypes() {
        if (this.formalTypes == null) {
            return new TransformingList(((ProcedureDef)this.def()).formalTypes(), new DerefTransform());
        }
        return this.formalTypes;
    }

    @Override
    public List<Type> throwTypes() {
        if (this.throwTypes == null) {
            return new TransformingList(((ProcedureDef)this.def()).throwTypes(), new DerefTransform());
        }
        return this.throwTypes;
    }

    @Override
    public boolean moreSpecific(ProcedureInstance<T> p, Context context) {
        ProcedureInstance_c p1 = this;
        ProcedureInstance<T> p2 = p;
        StructType t1 = null;
        StructType t2 = null;
        if (p1 instanceof MemberInstance) {
            t1 = ((MemberInstance)((Object)p1)).container();
        }
        if (p2 instanceof MemberInstance) {
            t2 = ((MemberInstance)((Object)p2)).container();
        }
        if (t1 != null && t2 != null && (t1.isClass() && t2.isClass() ? !t1.isSubtype(t2, context) && !t1.toClass().isEnclosed(t2.toClass()) : !t1.isSubtype(t2, context))) {
            return false;
        }
        return p2.callValid(t1, p1.formalTypes(), context);
    }

    @Override
    public boolean hasFormals(List<Type> formalTypes, Context context) {
        return CollectionUtil.allElementwise(this.formalTypes(), formalTypes, new TypeSystem_c.TypeEquals(context));
    }

    @Override
    public boolean throwsSubset(ProcedureInstance<T> p) {
        SubtypeSet s1 = new SubtypeSet(this.ts.Throwable());
        SubtypeSet s2 = new SubtypeSet(this.ts.Throwable());
        s1.addAll((Collection<? extends Type>)this.throwTypes());
        s2.addAll((Collection<? extends Type>)p.throwTypes());
        for (Type t : s1) {
            if (this.ts.isUncheckedException(t) || s2.contains(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean callValid(Type thisType, List<Type> argTypes, Context context) {
        List<Type> l1 = this.formalTypes();
        List<Type> l2 = argTypes;
        Iterator<Type> i1 = l1.iterator();
        Iterator<Type> i2 = l2.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            Type t1 = i1.next();
            Type t2 = i2.next();
            if (this.ts.isImplicitCastValid(t2, t1, context)) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    @Override
    public String designator() {
        return ((ProcedureDef)this.def()).designator();
    }

    @Override
    public String signature() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> formals = new ArrayList<String>();
        if (this.formalTypes != null) {
            for (int i = 0; i < this.formalTypes.size(); ++i) {
                String s = ((Object)this.formalTypes.get(i)).toString();
                formals.add(s);
            }
        } else {
            for (int i = 0; i < ((ProcedureDef)this.def()).formalTypes().size(); ++i) {
                formals.add(((ProcedureDef)this.def()).formalTypes().get(i).toString());
            }
        }
        sb.append("(");
        sb.append(CollectionUtil.listToString(formals));
        sb.append(")");
        return sb.toString();
    }
}

