/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import polyglot.types.Def_c;
import polyglot.types.Flags;
import polyglot.types.Name;
import polyglot.types.Ref;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.types.VarDef;
import polyglot.util.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VarDef_c
extends Def_c
implements VarDef {
    protected Flags flags;
    protected Ref<? extends Type> type;
    protected Name name;
    protected Ref<ConstantValue> constantRef;

    protected VarDef_c() {
    }

    public VarDef_c(TypeSystem ts, Position pos, Flags flags, Ref<? extends Type> type, Name name) {
        super(ts, pos);
        this.flags = flags;
        this.type = type;
        this.name = name;
        this.constantRef = Types.lazyRef(null);
    }

    @Override
    public Object constantValue() {
        ConstantValue cv = this.constantRef.get();
        if (cv == null) {
            return null;
        }
        return cv.value();
    }

    @Override
    public boolean isConstant() {
        ConstantValue cv = this.constantRef.get();
        if (cv == null) {
            return false;
        }
        return cv.isConstant();
    }

    @Override
    public Ref<ConstantValue> constantValueRef() {
        return this.constantRef;
    }

    @Override
    public Flags flags() {
        return this.flags;
    }

    @Override
    public Ref<? extends Type> type() {
        return this.type;
    }

    @Override
    public Name name() {
        return this.name;
    }

    @Override
    public void setType(Ref<? extends Type> type) {
        this.type = type;
    }

    @Override
    public void setFlags(Flags flags) {
        this.flags = flags;
    }

    @Override
    public void setConstantValue(Object constantValue) {
        this.constantRef.update(new ConstantValue(constantValue));
    }

    @Override
    public void setNotConstant() {
        this.constantRef.update(new ConstantValue());
    }

    @Override
    public void setName(Name name) {
        this.name = name;
    }

    public static class ConstantValue {
        private Object value;
        private boolean isConstant;

        public ConstantValue() {
            this.value = null;
            this.isConstant = false;
        }

        public ConstantValue(Object v) {
            this.value = v;
            this.isConstant = true;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Object value() {
            return this.value;
        }

        public void setConstant(boolean isConstant) {
            this.isConstant = isConstant;
        }

        public boolean isConstant() {
            return this.isConstant;
        }
    }
}

