/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import polyglot.main.Report;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.IdentityKey;

public class TypeOutputStream
extends ObjectOutputStream {
    protected TypeSystem ts;
    protected Set<Object> roots;
    protected Map<Object, Object> placeHolders;

    public TypeOutputStream(OutputStream out, TypeSystem ts, TypeObject root) throws IOException {
        super(out);
        this.ts = ts;
        this.roots = ts.getTypeEncoderRootSet(root);
        this.placeHolders = new HashMap<Object, Object>();
        if (Report.should_report("serialize", 2)) {
            Report.report(2, "Began TypeOutputStream with roots: " + this.roots);
        }
        this.enableReplaceObject(true);
    }

    protected Object placeHolder(TypeObject o, boolean useRoots) {
        IdentityKey k = new IdentityKey(o);
        Object p = this.placeHolders.get(k);
        if (p == null) {
            p = this.ts.placeHolder(o, useRoots ? this.roots : Collections.EMPTY_SET);
            this.placeHolders.put(k, p);
        }
        return p;
    }

    protected Object replaceObject(Object o) throws IOException {
        if (o instanceof TypeObject) {
            Object r;
            if (this.roots.contains(o)) {
                if (Report.should_report("serialize", 2)) {
                    Report.report(2, "+ In roots: " + o + " : " + o.getClass());
                }
                r = o;
            } else {
                r = this.placeHolder((TypeObject)o, true);
            }
            if (Report.should_report("serialize", 2)) {
                if (r != o) {
                    Report.report(2, "+ Replacing: " + o + " : " + o.getClass() + " with " + r);
                } else {
                    Report.report(2, "+ " + o + " : " + o.getClass());
                }
            }
            return r;
        }
        if (Report.should_report("serialize", 2)) {
            Report.report(2, "+ " + o + " : " + o.getClass());
        }
        return o;
    }
}

