/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedListIterator<T>
implements ListIterator<T> {
    private Class<? super T> allowed_type;
    private boolean immutable;
    private ListIterator<T> backing_iterator;

    public TypedListIterator(ListIterator<T> iter, Class<? super T> c, boolean immutable) {
        this.immutable = immutable;
        this.allowed_type = c;
        this.backing_iterator = iter;
    }

    public Class<? super T> getAllowedType() {
        return this.allowed_type;
    }

    @Override
    public void add(T o) {
        this.tryIns(o);
        this.backing_iterator.add(o);
    }

    @Override
    public void set(T o) {
        this.tryIns(o);
        this.backing_iterator.set(o);
    }

    @Override
    public boolean hasNext() {
        return this.backing_iterator.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        return this.backing_iterator.hasPrevious();
    }

    @Override
    public T next() {
        return this.backing_iterator.next();
    }

    @Override
    public int nextIndex() {
        return this.backing_iterator.nextIndex();
    }

    @Override
    public T previous() {
        return this.backing_iterator.previous();
    }

    @Override
    public int previousIndex() {
        return this.backing_iterator.previousIndex();
    }

    @Override
    public void remove() {
        if (this.immutable) {
            throw new UnsupportedOperationException("Remove from an immutable TypedListIterator");
        }
        this.backing_iterator.remove();
    }

    private final void tryIns(T o) {
        if (this.immutable) {
            throw new UnsupportedOperationException("Add to an immutable TypedListIterator");
        }
        if (this.allowed_type != null && !this.allowed_type.isAssignableFrom(o.getClass())) {
            String why = "Tried to add a " + o.getClass().getName() + " to a list of type " + this.allowed_type.getName();
            throw new UnsupportedOperationException(why);
        }
    }
}

