/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import polyglot.ast.Block;
import polyglot.ast.Branch;
import polyglot.ast.Labeled;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Return;
import polyglot.ast.Stmt;
import polyglot.ast.SwitchBlock;
import polyglot.ast.Throw;
import polyglot.types.Name;
import polyglot.visit.AlphaRenamer;
import polyglot.visit.NodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeCleaner
extends NodeVisitor {
    protected NodeFactory nf;
    protected AlphaRenamer alphaRen;

    public CodeCleaner(NodeFactory nf) {
        this.nf = nf;
        this.alphaRen = new AlphaRenamer();
    }

    @Override
    public Node leave(Node old, Node n, NodeVisitor v) {
        if (!(n instanceof Block) && !(n instanceof Labeled)) {
            return n;
        }
        if (n instanceof Labeled) {
            Labeled l = (Labeled)n;
            if (!(l.statement() instanceof Block)) {
                return n;
            }
            Block b = (Block)l.statement();
            if (b.statements().size() != 1) {
                if (this.labelRefs(b).contains(l.labelNode().id())) {
                    return n;
                }
                return this.nf.Block(b.position(), this.clean(this.flattenBlock(b)));
            }
            b = (Block)b.visit(this.alphaRen);
            return this.nf.Labeled(l.position(), l.labelNode(), b.statements().get(0));
        }
        Block b = (Block)n;
        List stmtList = this.clean(this.flattenBlock(b));
        if (b instanceof SwitchBlock) {
            return this.nf.SwitchBlock(b.position(), stmtList);
        }
        return this.nf.Block(b.position(), stmtList);
    }

    protected List flattenBlock(Block b) {
        LinkedList<Stmt> stmtList = new LinkedList<Stmt>();
        for (Stmt stmt : b.statements()) {
            if (stmt instanceof Block) {
                stmt = (Stmt)stmt.visit(this.alphaRen);
                stmtList.addAll(((Block)stmt).statements());
                continue;
            }
            stmtList.add(stmt);
        }
        return stmtList;
    }

    protected List clean(List l) {
        LinkedList<Stmt> stmtList = new LinkedList<Stmt>();
        for (Stmt stmt : l) {
            stmtList.add(stmt);
            if (!(stmt instanceof Branch) && !(stmt instanceof Return) && !(stmt instanceof Throw)) continue;
            return stmtList;
        }
        return l;
    }

    protected Set<Name> labelRefs(Block b) {
        final HashSet<Name> result = new HashSet<Name>();
        b.visit(new NodeVisitor(){

            public Node leave(Node old, Node n, NodeVisitor v) {
                if (n instanceof Branch) {
                    result.add(((Branch)n).labelNode().id());
                }
                return n;
            }
        });
        return result;
    }
}

