/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import polyglot.ast.Call;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.ClassDecl;
import polyglot.ast.ConstructorCall;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldDecl;
import polyglot.ast.Formal;
import polyglot.ast.Initializer;
import polyglot.ast.Local;
import polyglot.ast.LocalDecl;
import polyglot.ast.MethodDecl;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.PackageNode;
import polyglot.ast.TypeNode;
import polyglot.frontend.ExtensionInfo;
import polyglot.types.Package;
import polyglot.types.QName;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.util.InternalCompilerError;
import polyglot.visit.NodeVisitor;

public class ExtensionCleaner
extends NodeVisitor {
    protected NodeFactory nf;
    protected TypeSystem ts;
    protected ExtensionInfo javaExt;

    public ExtensionCleaner(ExtensionInfo javaExt) {
        this.javaExt = javaExt;
        this.nf = javaExt.nodeFactory();
        this.ts = javaExt.typeSystem();
    }

    public Node leave(Node old, Node n, NodeVisitor v) {
        n = n.ext(null);
        n = n.del(null);
        n = this.strip(n);
        return n;
    }

    protected Node strip(Node n) {
        if (n instanceof Call) {
            n = ((Call)n).methodInstance(null);
        }
        if (n instanceof ClassDecl) {
            n = ((ClassDecl)n).classDef(null);
        }
        if (n instanceof ConstructorCall) {
            n = ((ConstructorCall)n).constructorInstance(null);
        }
        if (n instanceof Field) {
            n = ((Field)n).fieldInstance(null);
        }
        if (n instanceof FieldDecl) {
            n = ((FieldDecl)n).fieldDef(null);
            n = ((FieldDecl)n).initializerDef(null);
        }
        if (n instanceof Formal) {
            n = ((Formal)n).localDef(null);
        }
        if (n instanceof Initializer) {
            n = ((Initializer)n).initializerDef(null);
        }
        if (n instanceof Local) {
            n = ((Local)n).localInstance(null);
        }
        if (n instanceof LocalDecl) {
            n = ((LocalDecl)n).localDef(null);
        }
        if (n instanceof MethodDecl) {
            n = ((MethodDecl)n).methodDef(null);
        }
        if (n instanceof New) {
            n = ((New)n).anonType(null);
            n = ((New)n).constructorInstance(null);
        }
        if (n instanceof TypeNode) {
            n = this.convert((TypeNode)n);
        }
        if (n instanceof PackageNode) {
            n = this.convert((PackageNode)n);
        }
        if (n instanceof Expr) {
            n = ((Expr)n).type(null);
        }
        return n;
    }

    protected TypeNode convert(TypeNode n) {
        Type t = n.type();
        if (n instanceof CanonicalTypeNode) {
            if (t.typeSystem() == this.ts) {
                return n;
            }
            throw new InternalCompilerError("Unexpected Jx type: " + t + " found in rewritten AST.");
        }
        if (t != null && t.typeSystem() == this.ts) {
            return this.nf.CanonicalTypeNode(n.position(), t);
        }
        assert (false);
        return n;
    }

    protected PackageNode convert(PackageNode n) {
        Package p = Types.get(n.package_());
        if (p != null && p.typeSystem() == this.ts) {
            return this.nf.PackageNode(n.position(), Types.ref(p));
        }
        return this.nf.PackageNode(n.position(), Types.ref(this.ts.createPackage(QName.make(n.toString()))));
    }
}

