/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import polyglot.ast.ArrayInit;
import polyglot.ast.Assign;
import polyglot.ast.Block;
import polyglot.ast.ConstructorCall;
import polyglot.ast.Expr;
import polyglot.ast.FieldDecl;
import polyglot.ast.Lit;
import polyglot.ast.Local;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Special;
import polyglot.ast.Stmt;
import polyglot.ast.Switch;
import polyglot.types.Flags;
import polyglot.types.LocalDef;
import polyglot.types.Name;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.visit.NodeVisitor;

public class FlattenVisitor
extends NodeVisitor {
    protected TypeSystem ts;
    protected NodeFactory nf;
    protected LinkedList stack;
    protected static int count = 0;
    protected Set noFlatten = new HashSet();
    protected Set neverFlatten = new HashSet();

    public FlattenVisitor(TypeSystem ts, NodeFactory nf) {
        this.ts = ts;
        this.nf = nf;
        this.stack = new LinkedList();
    }

    public Node override(Node parent, Node n) {
        Stmt s1;
        if (parent instanceof Stmt && n instanceof Stmt && !((s1 = (Stmt)n) instanceof Block)) {
            Block s2 = this.nf.Block(s1.position(), s1);
            return this.visitEdgeNoOverride(parent, s2);
        }
        if (n instanceof FieldDecl || n instanceof ConstructorCall) {
            if (!this.stack.isEmpty()) {
                List l = (List)this.stack.getFirst();
                l.add(n);
            }
            return n;
        }
        if (n instanceof Switch) {
            return n;
        }
        if (this.neverFlatten.contains(n)) {
            return n;
        }
        if (n instanceof ArrayInit) {
            return n;
        }
        return null;
    }

    protected static Name newID() {
        return Name.makeFresh("tmp");
    }

    public NodeVisitor enter(Node parent, Node n) {
        if (n instanceof Block) {
            this.stack.addLast(new LinkedList());
        }
        if (parent instanceof Stmt && n instanceof Expr) {
            this.noFlatten.add(n);
        }
        if (parent instanceof Assign) {
            this.noFlatten.add(n);
        }
        return this;
    }

    public Node leave(Node parent, Node old, Node n, NodeVisitor v) {
        if (this.noFlatten.contains(old)) {
            this.noFlatten.remove(old);
            return n;
        }
        if (n instanceof Block) {
            List l = (List)this.stack.removeFirst();
            Block block = ((Block)n).statements(l);
            if (parent instanceof Block && !this.stack.isEmpty()) {
                l = (List)this.stack.getFirst();
                l.add(block);
            }
            return block;
        }
        if (n instanceof Stmt) {
            List l = (List)this.stack.getFirst();
            l.add(n);
            return n;
        }
        if (n instanceof Expr && !(n instanceof Lit) && !(n instanceof Special) && !(n instanceof Local)) {
            Expr e = (Expr)n;
            if (e instanceof Assign) {
                return n;
            }
            Name name = FlattenVisitor.newID();
            LocalDecl def = this.nf.LocalDecl(e.position(), this.nf.FlagsNode(e.position(), Flags.FINAL), this.nf.CanonicalTypeNode(e.position(), Types.ref(e.type())), this.nf.Id(e.position(), name), e);
            LocalDef li = this.ts.localDef(e.position(), Flags.FINAL, Types.ref(e.type()), name);
            def = def.localDef(li);
            List l = (List)this.stack.getFirst();
            l.add(def);
            Local use = this.nf.Local(e.position(), this.nf.Id(e.position(), name));
            use = (Local)use.type(e.type());
            use = use.localInstance(li.asInstance());
            return use;
        }
        return n;
    }
}

