/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.Binary;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.CodeNode;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldAssign;
import polyglot.ast.FieldDecl;
import polyglot.ast.Formal;
import polyglot.ast.Initializer;
import polyglot.ast.Local;
import polyglot.ast.LocalAssign;
import polyglot.ast.LocalDecl;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Special;
import polyglot.ast.Term;
import polyglot.ast.Unary;
import polyglot.frontend.Globals;
import polyglot.frontend.Job;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.CodeDef;
import polyglot.types.ConstructorDef;
import polyglot.types.FieldDef;
import polyglot.types.LocalDef;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.VarDef;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.DataFlow;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitChecker
extends DataFlow {
    protected ClassBodyInfo currCBI = null;
    protected static final DataFlow.Item BOTTOM = new BottomItem();

    public InitChecker(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf, true, false);
    }

    @Override
    protected FlowGraph initGraph(CodeNode code, Term root) {
        this.currCBI.currCodeDecl = code;
        return new FlowGraph(root, this.forward);
    }

    @Override
    protected NodeVisitor enterCall(Node parent, Node n) throws SemanticException {
        if (n instanceof ClassBody) {
            ClassDef ct = null;
            if (parent instanceof ClassDecl) {
                ct = ((ClassDecl)parent).classDef();
            } else if (parent instanceof New) {
                ct = ((New)parent).anonType();
            }
            if (ct == null) {
                throw new InternalCompilerError("ClassBody found but cannot find the class.", n.position());
            }
            this.setupClassBody(ct, (ClassBody)n);
        }
        return super.enterCall(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        if (n instanceof ConstructorDecl) {
            this.currCBI.allConstructors.add((ConstructorDecl)n);
            return n;
        }
        if (n instanceof ClassBody) {
            try {
                for (ConstructorDecl cd : this.currCBI.allConstructors) {
                    this.dataflow(cd);
                }
                this.checkStaticFinalFieldsInit((ClassBody)n);
                this.checkNonStaticFinalFieldsInit((ClassBody)n);
                if (this.currCBI.outer != null) {
                    this.currCBI.outer.localsUsedInClassBodies.put(n, this.currCBI.outerLocalsUsed);
                }
            }
            finally {
                this.currCBI = this.currCBI.outer;
            }
        }
        return super.leaveCall(old, n, v);
    }

    protected void setupClassBody(ClassDef ct, ClassBody n) throws SemanticException {
        ClassBodyInfo newCDI = new ClassBodyInfo();
        newCDI.outer = this.currCBI;
        newCDI.currClass = ct;
        this.currCBI = newCDI;
        for (ClassMember cm : n.members()) {
            MinMaxInitCount initCount;
            FieldDecl fd;
            if (!(cm instanceof FieldDecl) || !(fd = (FieldDecl)cm).flags().flags().isFinal()) continue;
            if (fd.init() != null) {
                initCount = new MinMaxInitCount(InitCount.ONE, InitCount.ONE);
                if (this.currCBI.outer != null) {
                    this.dataflow(fd.init());
                }
            } else {
                initCount = new MinMaxInitCount(InitCount.ZERO, InitCount.ZERO);
            }
            newCDI.currClassFinalFieldInitCounts.put(fd.fieldDef(), initCount);
        }
    }

    protected void checkStaticFinalFieldsInit(ClassBody cb) throws SemanticException {
        for (Map.Entry<FieldDef, MinMaxInitCount> e : this.currCBI.currClassFinalFieldInitCounts.entrySet()) {
            MinMaxInitCount initCount;
            FieldDef fi;
            if (!(e.getKey() instanceof FieldDef) || !(fi = e.getKey()).flags().isStatic() || !fi.flags().isFinal() || !InitCount.ZERO.equals((initCount = e.getValue()).getMin())) continue;
            throw new SemanticException("Final field \"" + fi.name() + "\" might not have been initialized", cb.position());
        }
    }

    protected void checkNonStaticFinalFieldsInit(ClassBody cb) throws SemanticException {
        for (FieldDef fi : this.currCBI.currClassFinalFieldInitCounts.keySet()) {
            if (!fi.flags().isFinal() || fi.flags().isStatic()) continue;
            boolean fieldInitializedBeforeConstructors = false;
            MinMaxInitCount ic = this.currCBI.currClassFinalFieldInitCounts.get(fi);
            if (ic != null && !InitCount.ZERO.equals(ic.getMin())) {
                fieldInitializedBeforeConstructors = true;
            }
            for (ConstructorDecl cd : this.currCBI.allConstructors) {
                ConstructorDef ciStart;
                ConstructorDef ci = ciStart = cd.constructorDef();
                boolean isInitialized = fieldInitializedBeforeConstructors;
                if (cd.body() == null) {
                    isInitialized = true;
                }
                while (ci != null) {
                    Set<FieldDef> s = this.currCBI.fieldsConstructorInitializes.get(ci);
                    if (s != null && s.contains(fi)) {
                        if (isInitialized) {
                            throw new SemanticException("Final field \"" + fi.name() + "\" might have already been initialized", cd.position());
                        }
                        isInitialized = true;
                    }
                    ci = this.currCBI.constructorCalls.get(ci);
                }
                if (isInitialized) continue;
                throw new SemanticException("Final field \"" + fi.name() + "\" might not have been initialized", ciStart.position());
            }
        }
    }

    protected void dataflow(Expr root) throws SemanticException {
        FlowGraph g = new FlowGraph(root, this.forward);
        CFGBuilder v = this.createCFGBuilder(this.ts, g);
        v.visitGraph();
        this.dataflow(g);
        this.post(g, root);
    }

    @Override
    public DataFlow.Item createInitialItem(FlowGraph graph, Term node, boolean entry) {
        if (node == graph.root() && entry) {
            return this.createInitDFI();
        }
        return BOTTOM;
    }

    private DataFlowItem createInitDFI() {
        return new DataFlowItem(new LinkedHashMap<VarDef, MinMaxInitCount>(this.currCBI.currClassFinalFieldInitCounts));
    }

    @Override
    protected DataFlow.Item confluence(List items, List itemKeys, Term node, boolean entry, FlowGraph graph) {
        if (node instanceof Initializer || node instanceof ConstructorDecl) {
            List filtered = this.filterItemsNonException(items, itemKeys);
            if (filtered.isEmpty()) {
                return this.createInitDFI();
            }
            if (filtered.size() == 1) {
                return (DataFlow.Item)filtered.get(0);
            }
            return this.confluence(filtered, node, entry, graph);
        }
        return this.confluence(items, node, entry, graph);
    }

    @Override
    public DataFlow.Item confluence(List inItems, Term node, boolean entry, FlowGraph graph) {
        Iterator iter = inItems.iterator();
        LinkedHashMap<VarDef, MinMaxInitCount> m = null;
        while (iter.hasNext()) {
            DataFlow.Item itm = (DataFlow.Item)iter.next();
            if (itm == BOTTOM) continue;
            if (m == null) {
                m = new LinkedHashMap<VarDef, MinMaxInitCount>(((DataFlowItem)itm).initStatus);
                continue;
            }
            Map<VarDef, MinMaxInitCount> n = ((DataFlowItem)itm).initStatus;
            for (Map.Entry<VarDef, MinMaxInitCount> e : n.entrySet()) {
                VarDef v = e.getKey();
                MinMaxInitCount initCount1 = (MinMaxInitCount)m.get(v);
                MinMaxInitCount initCount2 = e.getValue();
                m.put(v, MinMaxInitCount.join(initCount1, initCount2));
            }
        }
        if (m == null) {
            return BOTTOM;
        }
        return new DataFlowItem(m);
    }

    @Override
    protected Map flow(List inItems, List inItemKeys, FlowGraph graph, Term n, boolean entry, Set edgeKeys) {
        return this.flowToBooleanFlow(inItems, inItemKeys, graph, n, entry, edgeKeys);
    }

    @Override
    public Map flow(DataFlow.Item trueItem, DataFlow.Item falseItem, DataFlow.Item otherItem, FlowGraph graph, Term n, boolean entry, Set succEdgeKeys) {
        DataFlow.Item inItem = this.safeConfluence(trueItem, FlowGraph.EDGE_KEY_TRUE, falseItem, FlowGraph.EDGE_KEY_FALSE, otherItem, FlowGraph.EDGE_KEY_OTHER, n, entry, graph);
        if (entry) {
            return InitChecker.itemToMap(inItem, succEdgeKeys);
        }
        if (inItem == BOTTOM) {
            return InitChecker.itemToMap(BOTTOM, succEdgeKeys);
        }
        DataFlowItem inDFItem = (DataFlowItem)inItem;
        Map ret = null;
        if (n instanceof Formal) {
            ret = this.flowFormal(inDFItem, graph, (Formal)n, succEdgeKeys);
        } else if (n instanceof LocalDecl) {
            ret = this.flowLocalDecl(inDFItem, graph, (LocalDecl)n, succEdgeKeys);
        } else if (n instanceof LocalAssign) {
            ret = this.flowLocalAssign(inDFItem, graph, (LocalAssign)n, succEdgeKeys);
        } else if (n instanceof FieldAssign) {
            ret = this.flowFieldAssign(inDFItem, graph, (FieldAssign)n, succEdgeKeys);
        } else if (n instanceof ConstructorCall) {
            ret = this.flowConstructorCall(inDFItem, graph, (ConstructorCall)n, succEdgeKeys);
        } else if (n instanceof Expr && ((Expr)n).type().isBoolean() && (n instanceof Binary || n instanceof Unary)) {
            if (trueItem == null) {
                trueItem = inDFItem;
            }
            if (falseItem == null) {
                falseItem = inDFItem;
            }
            ret = this.flowBooleanConditions(trueItem, falseItem, inDFItem, graph, (Expr)n, succEdgeKeys);
        } else {
            ret = this.flowOther(inDFItem, graph, n, succEdgeKeys);
        }
        if (ret != null) {
            return ret;
        }
        return InitChecker.itemToMap(inItem, succEdgeKeys);
    }

    protected Map flowFormal(DataFlowItem inItem, FlowGraph graph, Formal f, Set succEdgeKeys) {
        LinkedHashMap<VarDef, MinMaxInitCount> m = new LinkedHashMap<VarDef, MinMaxInitCount>(inItem.initStatus);
        m.put(f.localDef(), new MinMaxInitCount(InitCount.ONE, InitCount.ONE));
        this.currCBI.localDeclarations.add(f.localDef());
        return InitChecker.itemToMap(new DataFlowItem(m), succEdgeKeys);
    }

    protected Map flowLocalDecl(DataFlowItem inItem, FlowGraph graph, LocalDecl ld, Set succEdgeKeys) {
        LinkedHashMap<VarDef, MinMaxInitCount> m = new LinkedHashMap<VarDef, MinMaxInitCount>(inItem.initStatus);
        MinMaxInitCount initCount = (MinMaxInitCount)m.get(ld.localDef());
        initCount = ld.init() != null ? new MinMaxInitCount(InitCount.ONE, InitCount.ONE) : new MinMaxInitCount(InitCount.ZERO, InitCount.ZERO);
        m.put(ld.localDef(), initCount);
        this.currCBI.localDeclarations.add(ld.localDef());
        return InitChecker.itemToMap(new DataFlowItem(m), succEdgeKeys);
    }

    protected Map flowLocalAssign(DataFlowItem inItem, FlowGraph graph, LocalAssign a, Set succEdgeKeys) {
        LinkedHashMap<VarDef, MinMaxInitCount> m = new LinkedHashMap<VarDef, MinMaxInitCount>(inItem.initStatus);
        Local l = a.local();
        MinMaxInitCount initCount = (MinMaxInitCount)m.get(l.localInstance().def());
        if (initCount == null) {
            initCount = new MinMaxInitCount(InitCount.ZERO, InitCount.ZERO);
        }
        initCount = new MinMaxInitCount(initCount.getMin().increment(), initCount.getMax().increment());
        m.put((VarDef)l.localInstance().def(), initCount);
        return InitChecker.itemToMap(new DataFlowItem(m), succEdgeKeys);
    }

    protected Map flowFieldAssign(DataFlowItem inItem, FlowGraph graph, FieldAssign a, Set succEdgeKeys) {
        LinkedHashMap<VarDef, MinMaxInitCount> m;
        MinMaxInitCount initCount;
        FieldDef fi = (FieldDef)a.fieldInstance().def();
        if (fi.flags().isFinal() && this.isFieldsTargetAppropriate(a) && (initCount = (MinMaxInitCount)(m = new LinkedHashMap<VarDef, MinMaxInitCount>(inItem.initStatus)).get(fi)) != null) {
            initCount = new MinMaxInitCount(initCount.getMin().increment(), initCount.getMax().increment());
            m.put(fi, initCount);
            return InitChecker.itemToMap(new DataFlowItem(m), succEdgeKeys);
        }
        return null;
    }

    protected Map flowConstructorCall(DataFlowItem inItem, FlowGraph graph, ConstructorCall cc, Set succEdgeKeys) {
        if (ConstructorCall.THIS.equals(cc.kind())) {
            this.currCBI.constructorCalls.put(((ConstructorDecl)this.currCBI.currCodeDecl).constructorDef(), (ConstructorDef)cc.constructorInstance().def());
        }
        return null;
    }

    protected Map flowOther(DataFlowItem inItem, FlowGraph graph, Node n, Set succEdgeKeys) {
        return null;
    }

    protected boolean isFieldsTargetAppropriate(Field f) {
        Special s;
        if (this.currCBI == null || this.currCBI.currCodeDecl == null) {
            return false;
        }
        CodeDef ci = this.currCBI.currCodeDecl.codeDef();
        ClassType containingClass = this.currCBI.currClass.asType();
        if (f.fieldInstance().flags().isStatic()) {
            Type container = ((FieldDef)f.fieldInstance().def()).container().get();
            return container instanceof ClassType && ((ClassDef)containingClass.def()).equals(((ClassType)container).def());
        }
        if (f.target() instanceof Special && Special.THIS.equals((s = (Special)f.target()).kind())) {
            return s.qualifier() == null || s.qualifier().type() instanceof ClassType && ((ClassDef)containingClass.def()).equals(((ClassType)s.qualifier().type()).def());
        }
        return false;
    }

    protected boolean isFieldsTargetAppropriate(FieldAssign f) {
        Special s;
        if (this.currCBI == null || this.currCBI.currCodeDecl == null) {
            return false;
        }
        CodeDef ci = this.currCBI.currCodeDecl.codeDef();
        ClassType containingClass = this.currCBI.currClass.asType();
        if (f.fieldInstance().flags().isStatic()) {
            Type container = ((FieldDef)f.fieldInstance().def()).container().get();
            return container instanceof ClassType && ((ClassDef)containingClass.def()).equals(((ClassType)container).def());
        }
        if (f.target() instanceof Special && Special.THIS.equals((s = (Special)f.target()).kind())) {
            return s.qualifier() == null || s.qualifier().type() instanceof ClassType && ((ClassDef)containingClass.def()).equals(((ClassType)s.qualifier().type()).def());
        }
        return false;
    }

    @Override
    public void check(FlowGraph graph, Term n, boolean entry, DataFlow.Item inItem, Map outItems) throws SemanticException {
        DataFlowItem dfIn = (DataFlowItem)inItem;
        if (dfIn == null) {
            dfIn = this.createInitDFI();
        }
        long t = System.currentTimeMillis();
        DataFlowItem dfOut = null;
        if (!entry && outItems != null && !outItems.isEmpty()) {
            dfOut = (DataFlowItem)outItems.values().iterator().next();
            if (n instanceof Local) {
                this.checkLocal(graph, (Local)n, dfIn, dfOut);
            } else if (n instanceof Field) {
                this.checkField(graph, (Field)n, dfIn, dfOut);
            } else if (n instanceof LocalAssign) {
                this.checkLocalAssign(graph, (LocalAssign)n, dfIn, dfOut);
            } else if (n instanceof FieldAssign) {
                this.checkFieldAssign(graph, (FieldAssign)n, dfIn, dfOut);
            } else if (n instanceof ClassBody) {
                this.checkClassBody(graph, (ClassBody)n, dfIn, dfOut);
            } else {
                this.checkOther(graph, n, dfIn, dfOut);
            }
        }
        long t2 = System.currentTimeMillis();
        if (n == graph.root() && !entry) {
            if (this.currCBI.currCodeDecl instanceof Initializer) {
                this.finishInitializer(graph, (Initializer)this.currCBI.currCodeDecl, dfIn, dfOut);
            }
            if (this.currCBI.currCodeDecl instanceof ConstructorDecl) {
                this.finishConstructorDecl(graph, (ConstructorDecl)this.currCBI.currCodeDecl, dfIn, dfOut);
            }
        }
        long t3 = System.currentTimeMillis();
        Globals.Stats().accumulate("InitChecker.check", 1L);
        Globals.Stats().accumulate("InitChecker.1", t2 - t);
        Globals.Stats().accumulate("InitChecker.2", t3 - t2);
        Globals.Stats().accumulate("InitChecker.1+2", t3 - t);
    }

    protected void finishInitializer(FlowGraph graph, Initializer initializer, DataFlowItem dfIn, DataFlowItem dfOut) {
        for (Map.Entry<VarDef, MinMaxInitCount> e : dfOut.initStatus.entrySet()) {
            FieldDef fi;
            if (!(e.getKey() instanceof FieldDef) || !(fi = (FieldDef)e.getKey()).flags().isFinal()) continue;
            this.currCBI.currClassFinalFieldInitCounts.put(fi, e.getValue());
        }
    }

    protected void finishConstructorDecl(FlowGraph graph, ConstructorDecl cd, DataFlowItem dfIn, DataFlowItem dfOut) {
        ConstructorDef ci = cd.constructorDef();
        HashSet<FieldDef> s = new HashSet<FieldDef>();
        for (Map.Entry<VarDef, MinMaxInitCount> e : dfOut.initStatus.entrySet()) {
            if (!(e.getKey() instanceof FieldDef) || !((FieldDef)e.getKey()).flags().isFinal() || ((FieldDef)e.getKey()).flags().isStatic()) continue;
            FieldDef fi = (FieldDef)e.getKey();
            MinMaxInitCount initCount = e.getValue();
            MinMaxInitCount origInitCount = this.currCBI.currClassFinalFieldInitCounts.get(fi);
            if (initCount.getMin() != InitCount.ONE || origInitCount != null && origInitCount.getMin() != InitCount.ZERO) continue;
            s.add(fi);
        }
        if (!s.isEmpty()) {
            this.currCBI.fieldsConstructorInitializes.put(ci, s);
        }
    }

    protected void checkField(FlowGraph graph, Field f, DataFlowItem dfIn, DataFlowItem dfOut) throws SemanticException {
        MinMaxInitCount initCount;
        if (this.isFieldsTargetAppropriate(f) && f.flags().isFinal() && (this.currCBI.currCodeDecl instanceof ConstructorDecl || this.currCBI.currCodeDecl instanceof FieldDecl) && (initCount = dfIn.initStatus.get(f.fieldInstance().def())) != null && InitCount.ZERO.equals(initCount.getMin())) {
            if (this.currCBI.currCodeDecl instanceof ConstructorDecl) {
                ConstructorCall cc;
                ConstructorDecl cd = (ConstructorDecl)this.currCBI.currCodeDecl;
                if (cd.body() == null) {
                    return;
                }
                if (cd.body().statements().size() > 0 && cd.body().statements().get(0) instanceof ConstructorCall && (cc = (ConstructorCall)cd.body().statements().get(0)).kind() == ConstructorCall.THIS) {
                    return;
                }
            }
            if (f.reachable()) {
                throw new SemanticException("Field \"" + f.name().id() + "\" may not have been initialized", f.position());
            }
        }
    }

    protected void checkLocal(FlowGraph graph, Local l, DataFlowItem dfIn, DataFlowItem dfOut) throws SemanticException {
        if (!this.currCBI.localDeclarations.contains(l.localInstance().def())) {
            this.currCBI.outerLocalsUsed.add((LocalDef)l.localInstance().def());
        } else {
            MinMaxInitCount initCount = dfIn.initStatus.get(l.localInstance().def());
            if (initCount != null && InitCount.ZERO.equals(initCount.getMin()) && l.reachable()) {
                throw new SemanticException("Local variable \"" + l.name().id() + "\" may not have been initialized", l.position());
            }
        }
    }

    protected void checkLocalInstanceInit(LocalDef li, DataFlowItem dfIn, Position pos) throws SemanticException {
        MinMaxInitCount initCount = dfIn.initStatus.get(li);
        if (initCount != null && InitCount.ZERO.equals(initCount.getMin())) {
            throw new SemanticException("Local variable \"" + li.name() + "\" may not have been initialized", pos);
        }
    }

    protected void checkLocalAssign(FlowGraph graph, LocalAssign a, DataFlowItem dfIn, DataFlowItem dfOut) throws SemanticException {
        LocalDef li = (LocalDef)a.local().localInstance().def();
        if (!this.currCBI.localDeclarations.contains(li)) {
            throw new SemanticException("Final local variable \"" + li.name() + "\" cannot be assigned to in an inner class.", a.position());
        }
        MinMaxInitCount initCount = dfOut.initStatus.get(li);
        if (li.flags().isFinal() && InitCount.MANY.equals(initCount.getMax())) {
            throw new SemanticException("Final variable \"" + li.name() + "\" might already have been initialized", a.position());
        }
    }

    protected void checkFieldAssign(FlowGraph graph, FieldAssign a, DataFlowItem dfIn, DataFlowItem dfOut) throws SemanticException {
        FieldDef fi = (FieldDef)a.fieldInstance().def();
        if (fi.flags().isFinal()) {
            if ((this.currCBI.currCodeDecl instanceof ConstructorDecl || this.currCBI.currCodeDecl instanceof Initializer) && this.isFieldsTargetAppropriate(a)) {
                MinMaxInitCount initCount = dfOut.initStatus.get(fi);
                if (initCount == null) {
                    throw new InternalCompilerError("Dataflow information not found for field \"" + fi.name() + "\".", a.position());
                }
                if (InitCount.MANY.equals(initCount.getMax())) {
                    throw new SemanticException("Final field \"" + fi.name() + "\" might already have been initialized", a.position());
                }
            } else {
                throw new SemanticException("Cannot assign a value to final field \"" + fi.name() + "\" of \"" + fi.container() + "\".", a.position());
            }
        }
    }

    protected void checkClassBody(FlowGraph graph, ClassBody cb, DataFlowItem dfIn, DataFlowItem dfOut) throws SemanticException {
        Set<LocalDef> localsUsed = this.currCBI.localsUsedInClassBodies.get(cb);
        if (localsUsed != null) {
            this.checkLocalsUsedByInnerClass(graph, cb, localsUsed, dfIn, dfOut);
        }
    }

    protected void checkLocalsUsedByInnerClass(FlowGraph graph, ClassBody cb, Set<LocalDef> localsUsed, DataFlowItem dfIn, DataFlowItem dfOut) throws SemanticException {
        for (LocalDef li : localsUsed) {
            MinMaxInitCount initCount = dfOut.initStatus.get(li);
            if (!this.currCBI.localDeclarations.contains(li)) {
                this.currCBI.outerLocalsUsed.add(li);
                continue;
            }
            if (initCount != null && !InitCount.ZERO.equals(initCount.getMin())) continue;
            throw new SemanticException("Local variable \"" + li.name() + "\" must be initialized before the class " + "declaration.", cb.position());
        }
    }

    protected void checkOther(FlowGraph graph, Node n, DataFlowItem dfIn, DataFlowItem dfOut) throws SemanticException {
    }

    protected static class BottomItem
    extends DataFlow.Item {
        protected BottomItem() {
        }

        public boolean equals(Object i) {
            return i == this;
        }

        public int hashCode() {
            return -5826349;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DataFlowItem
    extends DataFlow.Item {
        public Map<VarDef, MinMaxInitCount> initStatus;

        DataFlowItem(Map<VarDef, MinMaxInitCount> m) {
            this.initStatus = Collections.unmodifiableMap(m);
        }

        public String toString() {
            return this.initStatus.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof DataFlowItem) {
                return ((Object)this.initStatus).equals(((DataFlowItem)o).initStatus);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return ((Object)this.initStatus).hashCode();
        }
    }

    protected static class MinMaxInitCount {
        protected InitCount min;
        protected InitCount max;

        MinMaxInitCount(InitCount min, InitCount max) {
            this.min = min;
            this.max = max;
        }

        InitCount getMin() {
            return this.min;
        }

        InitCount getMax() {
            return this.max;
        }

        public int hashCode() {
            return this.min.hashCode() * 4 + this.max.hashCode();
        }

        public String toString() {
            return "[ min: " + this.min + "; max: " + this.max + " ]";
        }

        public boolean equals(Object o) {
            if (o instanceof MinMaxInitCount) {
                return this.min.equals(((MinMaxInitCount)o).min) && this.max.equals(((MinMaxInitCount)o).max);
            }
            return false;
        }

        static MinMaxInitCount join(MinMaxInitCount initCount1, MinMaxInitCount initCount2) {
            if (initCount1 == null) {
                return initCount2;
            }
            if (initCount2 == null) {
                return initCount1;
            }
            MinMaxInitCount t = new MinMaxInitCount(InitCount.min(initCount1.getMin(), initCount2.getMin()), InitCount.max(initCount1.getMax(), initCount2.getMax()));
            return t;
        }
    }

    protected static class InitCount {
        public static InitCount ZERO = new InitCount(0);
        public static InitCount ONE = new InitCount(1);
        public static InitCount MANY = new InitCount(2);
        public int count;

        protected InitCount(int i) {
            this.count = i;
        }

        public int hashCode() {
            return this.count;
        }

        public boolean equals(Object o) {
            if (o instanceof InitCount) {
                return this.count == ((InitCount)o).count;
            }
            return false;
        }

        public String toString() {
            if (this.count == 0) {
                return "0";
            }
            if (this.count == 1) {
                return "1";
            }
            if (this.count == 2) {
                return "many";
            }
            throw new RuntimeException("Unexpected value for count");
        }

        public InitCount increment() {
            if (this.count == 0) {
                return ONE;
            }
            return MANY;
        }

        public static InitCount min(InitCount a, InitCount b) {
            if (ZERO.equals(a) || ZERO.equals(b)) {
                return ZERO;
            }
            if (ONE.equals(a) || ONE.equals(b)) {
                return ONE;
            }
            return MANY;
        }

        public static InitCount max(InitCount a, InitCount b) {
            if (MANY.equals(a) || MANY.equals(b)) {
                return MANY;
            }
            if (ONE.equals(a) || ONE.equals(b)) {
                return ONE;
            }
            return ZERO;
        }
    }

    protected static class ClassBodyInfo {
        public ClassBodyInfo outer = null;
        public CodeNode currCodeDecl = null;
        public ClassDef currClass = null;
        public Map<FieldDef, MinMaxInitCount> currClassFinalFieldInitCounts = new LinkedHashMap<FieldDef, MinMaxInitCount>();
        public List<ConstructorDecl> allConstructors = new ArrayList<ConstructorDecl>();
        public Map<ConstructorDef, ConstructorDef> constructorCalls = new LinkedHashMap<ConstructorDef, ConstructorDef>();
        public Map<ConstructorDef, Set<FieldDef>> fieldsConstructorInitializes = new LinkedHashMap<ConstructorDef, Set<FieldDef>>();
        public Set<LocalDef> outerLocalsUsed = new HashSet<LocalDef>();
        public Map<Node, Set<LocalDef>> localsUsedInClassBodies = new LinkedHashMap<Node, Set<LocalDef>>();
        public Set<LocalDef> localDeclarations = new HashSet<LocalDef>();

        protected ClassBodyInfo() {
        }
    }
}

