/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Import;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.SourceCollection;
import polyglot.ast.SourceFile;
import polyglot.ast.TopLevelDecl;
import polyglot.frontend.Job;
import polyglot.frontend.TargetFactory;
import polyglot.types.Context;
import polyglot.types.Package;
import polyglot.types.QName;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Copy;
import polyglot.util.InternalCompilerError;
import polyglot.visit.PrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Translator
extends PrettyPrinter
implements Copy {
    protected Job job;
    protected NodeFactory nf;
    protected TargetFactory tf;
    protected TypeSystem ts;
    protected Context context;

    public Translator(Job job, TypeSystem ts, NodeFactory nf, TargetFactory tf) {
        this.job = job;
        this.nf = nf;
        this.tf = tf;
        this.ts = ts;
        this.context = ts.emptyContext();
    }

    public Job job() {
        return this.job;
    }

    @Override
    public Object copy() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalCompilerError("Java clone() weirdness.");
        }
    }

    public TypeSystem typeSystem() {
        return this.ts;
    }

    public NodeFactory nodeFactory() {
        return this.nf;
    }

    public Context context() {
        return this.context;
    }

    public Translator context(Context c) {
        if (c == this.context) {
            return this;
        }
        Translator tr = (Translator)this.copy();
        tr.context = c;
        return tr;
    }

    @Override
    public void print(Node parent, Node child, CodeWriter w) {
        Translator tr = this;
        if (this.context != null) {
            if (parent == null) {
                Context c = child.del().enterScope(this.context);
                tr = this.context(c);
            } else {
                Context c = parent.del().enterChildScope(child, this.context);
                tr = this.context(c);
            }
        }
        child.del().translate(w, tr);
        if (this.context != null) {
            child.addDecls(this.context);
        }
    }

    public boolean translate(Node ast) {
        if (ast instanceof SourceFile) {
            SourceFile sfn = (SourceFile)ast;
            return this.translateSource(sfn);
        }
        if (ast instanceof SourceCollection) {
            SourceCollection sc = (SourceCollection)ast;
            boolean okay = true;
            for (SourceFile sfn : sc.sources()) {
                okay &= this.translateSource(sfn);
            }
            return okay;
        }
        throw new InternalCompilerError("AST root must be a SourceFile; found a " + ast.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean translateSource(SourceFile sfn) {
        TypeSystem ts = this.typeSystem();
        NodeFactory nf = this.nodeFactory();
        TargetFactory tf = this.tf;
        int outputWidth = this.job.compiler().outputWidth();
        Collection outputFiles = this.job.compiler().outputFiles();
        List<TopLevelDecl> exports = this.exports(sfn);
        CodeWriter w = null;
        try {
            File of;
            QName pkg = null;
            if (sfn.package_() != null) {
                Package p = sfn.package_().package_().get();
                pkg = p.fullName();
            }
            TopLevelDecl first = null;
            if (exports.size() == 0) {
                of = tf.outputFile(pkg, sfn.source());
            } else {
                first = exports.get(0);
                of = tf.outputFile(pkg, first.name().id(), sfn.source());
            }
            String opfPath = of.getPath();
            if (!opfPath.endsWith("$")) {
                outputFiles.add(of.getPath());
            }
            w = tf.outputCodeWriter(of, outputWidth);
            this.writeHeader(sfn, w);
            Iterator<TopLevelDecl> i = sfn.decls().iterator();
            while (i.hasNext()) {
                TopLevelDecl decl = i.next();
                if (decl.flags().flags().isPublic() && decl != first) {
                    w.flush();
                    w.close();
                    of = tf.outputFile(pkg, decl.name().id(), sfn.source());
                    outputFiles.add(of.getPath());
                    w = tf.outputCodeWriter(of, outputWidth);
                    this.writeHeader(sfn, w);
                }
                this.translateTopLevelDecl(w, sfn, decl);
                if (!i.hasNext()) continue;
                w.newline(0);
            }
            w.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.job.compiler().errorQueue().enqueue(2, "I/O error while translating: " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException e) {
                    this.job.compiler().errorQueue().enqueue(2, "I/O error while closing output file: " + e.getMessage());
                }
            }
        }
    }

    protected void translateTopLevelDecl(CodeWriter w, SourceFile source, TopLevelDecl decl) {
        Context c = source.del().enterScope(this.context);
        Translator tr = this.context(c);
        decl.del().translate(w, tr);
    }

    protected void writeHeader(SourceFile sfn, CodeWriter w) {
        if (sfn.package_() != null) {
            w.write("package ");
            sfn.package_().del().translate(w, this);
            w.write(";");
            w.newline(0);
            w.newline(0);
        }
        boolean newline = false;
        for (Import imp : sfn.imports()) {
            imp.del().translate(w, this);
            newline = true;
        }
        if (newline) {
            w.newline(0);
        }
    }

    protected List<TopLevelDecl> exports(SourceFile sfn) {
        ArrayList<TopLevelDecl> exports = new ArrayList<TopLevelDecl>();
        for (TopLevelDecl decl : sfn.decls()) {
            if (!decl.flags().flags().isPublic()) continue;
            exports.add(decl);
        }
        return exports;
    }

    public String toString() {
        return "Translator";
    }
}

