/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.Map;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.frontend.Job;
import polyglot.main.Report;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.types.UnknownType;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeChecker
extends ContextVisitor {
    Map<Node, Node> memo;

    public TypeChecker(Job job, TypeSystem ts, NodeFactory nf, Map<Node, Node> memo) {
        super(job, ts, nf);
        this.memo = memo;
    }

    @Override
    public Node override(Node parent, Node n) {
        Node n_ = this.memo.get(n);
        n_ = null;
        if (n_ != null) {
            this.addDecls(n_);
            return n_;
        }
        try {
            Node m;
            if (Report.should_report("visit", 2)) {
                Report.report(2, ">> " + this + "::override " + n);
            }
            if ((m = n.del().typeCheckOverride(parent, this)) != null) {
                this.memo.put(n, m);
                this.memo.put(m, m);
            }
            return m;
        }
        catch (SemanticException e) {
            if (e.getMessage() != null) {
                Position position = e.position();
                if (position == null) {
                    position = n.position();
                }
                this.errorQueue().enqueue(5, e.getMessage(), position);
            }
            if (this.goal() != null) {
                this.goal().fail();
            }
            return n;
        }
    }

    @Override
    protected NodeVisitor enterCall(Node n) throws SemanticException {
        TypeChecker v = (TypeChecker)n.del().typeCheckEnter(this);
        return v;
    }

    @Override
    protected Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        TypeChecker tc = (TypeChecker)v;
        class AmbChecker
        extends NodeVisitor {
            boolean amb;

            AmbChecker() {
            }

            public Node override(Node n) {
                Expr e;
                if (n instanceof Expr && ((e = (Expr)n).type() == null || e.type() instanceof UnknownType)) {
                    this.amb = true;
                }
                return n;
            }
        }
        AmbChecker ac = new AmbChecker();
        n.visitChildren(ac);
        if (ac.amb) {
            return n;
        }
        Node m = n;
        m = m.del().disambiguate(tc);
        m = m.del().typeCheck(tc);
        m = m.del().checkConstants(tc);
        this.memo.put(old, m);
        this.memo.put(n, m);
        this.memo.put(m, m);
        return m;
    }
}

