/*
 * Decompiled with CFR 0.152.
 */
package hj.ant.task;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public class Hjc
extends Java {
    public static final String HJC_OPT_CLASSPATH = "-cp";
    public static final String HJC_OPT_SOURCEPATH = "-sp";
    public static final String HJC_OPT_DESTDIR = "-d";
    private static final String HJC_OPT_PREPEND = "-pp";
    private static final String HJC_OPT_HJ = "-hj";
    private static final String HJC_MAIN_CLASS = "soot.Main";
    private static final String HJC_FILE_EXT = ".hj";
    private Path hjcSourcepath;
    private Path hjcClasspath;
    private File destDir;
    private File hjHome;
    private String runtime;
    private String hjcArgs;
    private File source;
    private boolean showCommand = false;

    public File getDestDir() {
        return this.destDir;
    }

    public void setDestDir(File file) {
        this.destDir = file;
    }

    public File getHjHome() {
        return this.hjHome;
    }

    public void setHjHome(File file) {
        this.hjHome = file;
        Path path = this.buildHjHomePath();
        if (path != null) {
            super.setClasspath(path);
        }
    }

    public boolean getShowCommand() {
        return this.showCommand;
    }

    public void setShowCommand(boolean bl) {
        this.showCommand = bl;
    }

    protected Path buildHjHomePath() {
        File file = new File(this.hjHome + File.separator + "lib");
        if (file.exists()) {
            String[] stringArray = file.list();
            Path path = new Path(this.getProject());
            for (String string : stringArray) {
                if (!string.endsWith(".jar")) continue;
                path.add(new Path(this.getProject(), file.getAbsolutePath() + File.separator + string));
            }
            return path;
        }
        throw new BuildException("hjHome path is invalid");
    }

    public String getRuntime() {
        return this.runtime;
    }

    public void setRuntime(String string) {
        this.runtime = string;
    }

    public String getHjcArgs() {
        return this.hjcArgs;
    }

    public void setHjcArgs(String string) {
        this.hjcArgs = string;
    }

    public File getSource() {
        return this.source;
    }

    public void setSource(File file) {
        String string = file.getParent();
        if (string != null) {
            this.setSourcepath(new Path(this.getProject(), string));
        }
        if (!file.getName().endsWith(HJC_FILE_EXT)) {
            throw new BuildException("Source to compile must have the .hj extension");
        }
        this.source = file;
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public void setSourcepath(Path path) {
        if (this.hjcSourcepath == null) {
            this.hjcSourcepath = path;
        } else {
            this.hjcSourcepath.append(path);
        }
    }

    public Path createSourcepath() {
        if (this.hjcSourcepath == null) {
            this.hjcSourcepath = new Path(this.getProject());
        }
        return this.hjcSourcepath.createPath();
    }

    public void setClasspath(Path path) {
        if (this.hjcClasspath == null) {
            this.hjcClasspath = path;
        } else {
            this.hjcClasspath.append(path);
        }
    }

    public Path createClasspath() {
        return super.createClasspath();
    }

    protected void buildHjcArgs() {
        Commandline.Argument argument;
        String string = this.source.getName();
        String string2 = string.substring(0, string.length() - HJC_FILE_EXT.length());
        if (this.hjcClasspath != null) {
            argument = this.createArg();
            argument.setValue(HJC_OPT_CLASSPATH);
            argument = this.createArg();
            argument.setPath(this.hjcClasspath);
            super.setClasspath(this.hjcClasspath);
        }
        if (this.hjcSourcepath != null) {
            argument = this.createArg();
            argument.setValue(HJC_OPT_SOURCEPATH);
            argument = this.createArg();
            argument.setPath(this.hjcSourcepath);
        }
        if (this.runtime != null) {
            argument = this.createArg();
            argument.setLine("-rt " + this.checkRuntime());
        }
        if (this.hjcArgs != null) {
            argument = this.createArg();
            argument.setLine(this.hjcArgs);
        }
        if (this.destDir != null) {
            argument = this.createArg();
            argument.setValue(HJC_OPT_DESTDIR);
            argument = this.createArg();
            argument.setFile(this.destDir);
        }
        argument = this.createArg();
        argument.setValue(HJC_OPT_HJ);
        argument = this.createArg();
        argument.setValue(HJC_OPT_PREPEND);
        argument = this.createArg();
        argument.setValue(string2);
    }

    protected String checkRuntime() {
        if (!(this.runtime.equals("a") || this.runtime.equals("h") || this.runtime.equals("s") || this.runtime.equals("w"))) {
            throw new BuildException("Unknown runtime \"" + this.getRuntime() + "\"");
        }
        return this.runtime;
    }

    public void execute() throws BuildException {
        this.buildHjcArgs();
        super.setFork(true);
        super.setClassname(HJC_MAIN_CLASS);
        super.execute();
    }

    public int executeJava() throws BuildException {
        if (this.showCommand) {
            System.out.println(this.getCommandLine());
        }
        return super.executeJava();
    }
}

