/*
 * Decompiled with CFR 0.152.
 */
package hj.array;

import hj.array.ContiguousRange;
import hj.array.MultiDimRegion;
import hj.lang.RankMismatchException;
import hj.lang.point;
import hj.lang.region;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ArbitraryRegion
extends region {
    private final SortedSet points_;
    private final ArbitraryRegion[] rankCache_;

    public ArbitraryRegion(region[] dims) {
        super(dims.length, false, false);
        int sz;
        int sz_total = sz = dims[0].size();
        for (int i = 1; i < dims.length; ++i) {
            assert (dims[i].size() == sz);
            if (dims[i].rank != 1) {
                throw new RankMismatchException(dims[i], 1);
            }
            if (this.zeroBased()) assert (dims[i].zeroBased());
        }
        this.rankCache_ = new ArbitraryRegion[dims.length];
        this.points_ = new TreeSet();
        this.permutations_(this.points_, new int[0], dims);
    }

    private void permutations_(Set hs, int[] fix, region[] var) {
        if (var.length == 0) {
            point new_point = point.factory.point(fix);
            hs.add(new_point);
        } else {
            region[] var_new = new region[var.length - 1];
            System.arraycopy(var, 1, var_new, 0, var.length - 1);
            region cur_reg = var[0];
            int[] fix_new = new int[fix.length + 1];
            System.arraycopy(fix, 0, fix_new, 0, fix.length);
            Iterator it = cur_reg.iterator();
            while (it.hasNext()) {
                int tmp_i;
                point tmp = (point)it.next();
                fix_new[fix.length] = tmp_i = tmp.get(0);
                this.permutations_(hs, fix_new, var_new);
            }
        }
    }

    public ArbitraryRegion(int rank, Set points) {
        super(rank, false, false);
        assert (points != null);
        for (Object o : points) {
            assert (o instanceof point);
            point p = (point)o;
            if (p.rank == rank) continue;
            throw new RankMismatchException(p, rank);
        }
        this.rankCache_ = new ArbitraryRegion[rank];
        this.points_ = new TreeSet();
        this.points_.addAll(points);
    }

    private void add_(point p) {
        if (p.rank != this.rank) {
            throw new RankMismatchException(p, this.rank);
        }
        this.points_.add(p);
    }

    public int size() {
        return this.points_.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public region rank(int index) {
        ArbitraryRegion ret;
        assert (index >= 0);
        assert (index < this.rank);
        ArbitraryRegion arbitraryRegion = this;
        synchronized (arbitraryRegion) {
            ret = this.rankCache_[index];
        }
        if (ret == null) {
            TreeSet<point> points = new TreeSet<point>();
            Iterator it = this.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                point p_onedim = point.factory.point(new int[]{p.get(index)});
                points.add(p_onedim);
            }
            ArbitraryRegion arbitraryRegion2 = this;
            synchronized (arbitraryRegion2) {
                this.rankCache_[index] = ret;
            }
            ret = new ArbitraryRegion(1, points);
        }
        return ret;
    }

    public boolean isConvex() {
        boolean ret = true;
        if (this.rank == 1) {
            ret = this.high() - this.low() + 1 == this.size();
        } else {
            int conv_size = 1;
            for (int i = 0; ret && i < this.rank; ++i) {
                region r = this.rank(i);
                ret &= r.isConvex();
                conv_size *= r.size();
            }
            ret &= this.size() == conv_size;
        }
        return ret;
    }

    public int low() {
        if (this.rank != 1) {
            throw new UnsupportedOperationException();
        }
        if (this.points_.isEmpty()) {
            assert (false);
            throw new ArrayIndexOutOfBoundsException();
        }
        point p = (point)this.points_.first();
        return p.get(0);
    }

    public int high() {
        if (this.rank != 1) {
            throw new UnsupportedOperationException();
        }
        if (this.points_.isEmpty()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        point p = (point)this.points_.last();
        return p.get(0);
    }

    public region union(region r) {
        assert (r != null);
        return ArbitraryRegion.union(this, r);
    }

    protected static region union(region r1, region r2) {
        point p;
        if (r1.rank != r2.rank) {
            throw new RankMismatchException(r2, r1.rank);
        }
        TreeSet<point> points = new TreeSet<point>();
        Iterator it = r1.iterator();
        while (it.hasNext()) {
            p = (point)it.next();
            points.add(p);
        }
        it = r2.iterator();
        while (it.hasNext()) {
            p = (point)it.next();
            points.add(p);
        }
        return new ArbitraryRegion(r1.rank, points);
    }

    public region intersection(region r) {
        assert (r != null);
        return ArbitraryRegion.intersection(this, r);
    }

    protected static region intersection(region r1, region r2) {
        if (r1.rank != r2.rank) {
            throw new RankMismatchException(r2, r1.rank);
        }
        if (r1.size() > r2.size()) {
            region tmp = r2;
            r2 = r1;
            r1 = tmp;
        }
        TreeSet<point> points = new TreeSet<point>();
        Iterator it = r1.iterator();
        while (it.hasNext()) {
            point p = (point)it.next();
            if (!r2.contains(p)) continue;
            points.add(p);
        }
        return new ArbitraryRegion(r1.rank, points);
    }

    public region difference(region r) {
        assert (r != null);
        return ArbitraryRegion.difference(this, r);
    }

    protected static region difference(region r1, region r2) {
        if (r1.rank != r2.rank) {
            throw new RankMismatchException(r2, r1.rank);
        }
        TreeSet<point> points = new TreeSet<point>();
        Iterator it = r1.iterator();
        while (it.hasNext()) {
            point p = (point)it.next();
            if (r2.contains(p)) continue;
            points.add(p);
        }
        ArbitraryRegion ret = new ArbitraryRegion(r1.rank, points);
        return ret;
    }

    public region convexHull() {
        region ret;
        if (this.rank == 1) {
            ret = new ContiguousRange(this.low(), this.high());
        } else {
            int[] mins = new int[this.rank];
            int[] maxs = new int[this.rank];
            for (int i = 0; i < this.rank; ++i) {
                region r = this.rank(i);
                mins[i] = r.low();
                maxs[i] = r.high();
            }
            region[] dims = new region[this.rank];
            boolean zeroBased = true;
            for (int i = 0; i < this.rank; ++i) {
                dims[i] = new ContiguousRange(mins[i], maxs[i]);
                zeroBased &= mins[i] == 0;
            }
            ret = new MultiDimRegion(dims, zeroBased);
        }
        return ret;
    }

    public boolean contains(point p) {
        assert (p != null);
        if (p.rank != this.rank) {
            throw new RankMismatchException(p, this.rank);
        }
        return this.points_.contains(p);
    }

    public boolean contains(int[] p) {
        boolean ret;
        assert (p != null);
        if (p.length == this.rank) {
            point pp = point.factory.point(p);
            ret = this.contains(pp);
        } else {
            ret = false;
        }
        return ret;
    }

    public boolean disjoint(region r) {
        assert (r != null);
        return this.intersection(r).size() == 0;
    }

    public int ordinal(point p) throws ArrayIndexOutOfBoundsException, ArrayIndexOutOfBoundsException {
        point q;
        assert (p != null);
        if (p.rank != this.rank) {
            throw new RankMismatchException(p, this.rank);
        }
        int ret = 0;
        if (this.size() == 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (!this.contains(p)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Iterator it = this.iterator();
        while (it.hasNext() && !(q = (point)it.next()).equals(p)) {
            ++ret;
        }
        return ret;
    }

    public point coord(int ord) throws ArrayIndexOutOfBoundsException {
        assert (ord >= 0);
        if (ord >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int ctr = 0;
        Iterator it = this.iterator();
        while (ctr++ < ord) {
            it.next();
        }
        point ret = (point)it.next();
        return ret;
    }

    public Iterator iterator() {
        return this.points_.iterator();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        Iterator it = this.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }
}

