/*
 * Decompiled with CFR 0.152.
 */
package hj.array.sharedmemory;

import hj.array.ByteArray;
import hj.array.Distribution_c;
import hj.array.Operator;
import hj.array.lang.byteArray;
import hj.base.UnsafeContainer;
import hj.lang.Indexable;
import hj.lang.Runtime;
import hj.lang.dist;
import hj.runtime.common.Configuration;

public class ByteArray_c
extends ByteArray
implements UnsafeContainer,
Cloneable {
    public final byte[] arr_;
    public final int[] descriptor_;

    public ByteArray_c(dist d, byte c, boolean mutable) {
        this(d, new byteArray.Constant(c), mutable);
    }

    public ByteArray_c(dist d, Operator.Pointwise c, boolean mutable, boolean ignored) {
        this(d, c, mutable);
    }

    protected ByteArray_c(dist d, Operator.Pointwise c, boolean mutable) {
        this(d, mutable, null);
        if (c != null) {
            this.scan((ByteArray)this, c);
        }
    }

    protected ByteArray_c(dist d, boolean mutable, byte[] a) {
        super(d, mutable);
        assert (d instanceof Distribution_c);
        int count = d.region.size();
        int rank = d.region.rank;
        this.descriptor_ = new int[rank + 1];
        this.descriptor_[0] = rank;
        for (int i = 1; i <= rank; ++i) {
            this.descriptor_[i] = d.region.rank(i - 1).size();
        }
        this.arr_ = a != null ? a : new byte[count];
    }

    private ByteArray_c(dist d, byte[] a, boolean mutable) {
        this(d, mutable, a);
    }

    public static ByteArray_c ByteArray_c(byte[] a, boolean mutable) {
        dist d = Runtime.factory.getDistributionFactory().local(a.length);
        return new ByteArray_c(d, a, mutable);
    }

    public boolean valueEquals(Indexable other) {
        ByteArray_c o = (ByteArray_c)other;
        if (o.arr_.length != this.arr_.length) {
            return false;
        }
        for (int i = this.arr_.length - 1; i >= 0; --i) {
            if (this.arr_[i] == o.arr_[i]) continue;
            return false;
        }
        return true;
    }

    public byte[] getBackingArray() {
        return this.arr_;
    }

    public int[] getDescriptor() {
        return this.descriptor_;
    }

    public byte setOrdinal(byte v, int rawIndex) {
        this.arr_[rawIndex] = v;
        return this.arr_[rawIndex];
    }

    public byte getOrdinal(int rawIndex) {
        return this.arr_[rawIndex];
    }

    protected ByteArray newInstance(dist d) {
        return new ByteArray_c(d, (Operator.Pointwise)null, true);
    }

    protected ByteArray newInstance(dist d, byte c) {
        return new ByteArray_c(d, c, true);
    }

    protected void assign(ByteArray rhs) {
        assert (rhs.getClass() == this.getClass());
        ByteArray_c rhs_t = (ByteArray_c)rhs;
        if (!Configuration.BAD_PLACE_RUNTIME_CHECK && rhs.distribution.equals(this.distribution)) {
            int count = this.arr_.length;
            for (int i = 0; i < count; ++i) {
                this.arr_[i] = rhs_t.arr_[i];
            }
        } else {
            super.assign(rhs);
        }
    }

    public void reduction(Operator.Reduction op) {
        if (!Configuration.BAD_PLACE_RUNTIME_CHECK) {
            int count = this.arr_.length;
            for (int i = 0; i < count; ++i) {
                op.apply(this.arr_[i]);
            }
        } else {
            super.reduction(op);
        }
    }
}

