/*
 * Decompiled with CFR 0.152.
 */
package hj.array.sharedmemory;

import hj.array.Distribution_c;
import hj.array.IntArray;
import hj.array.Operator;
import hj.array.lang.intArray;
import hj.base.UnsafeContainer;
import hj.lang.Indexable;
import hj.lang.Runtime;
import hj.lang.dist;
import hj.runtime.common.Configuration;

public class IntArray_c
extends IntArray
implements UnsafeContainer {
    public final int[] arr_;
    public final int[] descriptor_;

    public IntArray_c(dist d, int c, boolean mutable) {
        this(d, new intArray.Constant(c), mutable);
    }

    public IntArray_c(dist d, Operator.Pointwise c, boolean mutable, boolean ignored) {
        this(d, c, mutable);
    }

    protected IntArray_c(dist d, Operator.Pointwise c, boolean mutable) {
        this(d, mutable, null);
        if (c != null) {
            this.scan((IntArray)this, c);
        }
    }

    protected IntArray_c(dist d, boolean mutable, int[] a) {
        super(d, mutable);
        assert (d instanceof Distribution_c);
        int count = d.region.size();
        int rank = d.region.rank;
        this.descriptor_ = new int[rank + 1];
        this.descriptor_[0] = rank;
        for (int i = 1; i <= rank; ++i) {
            this.descriptor_[i] = d.region.rank(i - 1).size();
        }
        this.arr_ = a != null ? a : new int[count];
    }

    protected IntArray_c(dist d, int[] a, boolean mutable) {
        this(d, mutable, a);
    }

    public static IntArray_c IntArray_c(int[] a, boolean mutable) {
        dist d = Runtime.factory.getDistributionFactory().local(a.length);
        return new IntArray_c(d, a, mutable);
    }

    public boolean valueEquals(Indexable other) {
        IntArray_c o = (IntArray_c)other;
        if (o.arr_.length != this.arr_.length) {
            return false;
        }
        for (int i = this.arr_.length - 1; i >= 0; --i) {
            if (this.arr_[i] == o.arr_[i]) continue;
            return false;
        }
        return true;
    }

    public int[] getBackingArray() {
        return this.arr_;
    }

    public int[] getDescriptor() {
        return this.descriptor_;
    }

    public int setOrdinal(int v, int rawIndex) {
        this.arr_[rawIndex] = v;
        return this.arr_[rawIndex];
    }

    public int getOrdinal(int rawIndex) {
        return this.arr_[rawIndex];
    }

    protected IntArray newInstance(dist d) {
        return new IntArray_c(d, (Operator.Pointwise)null, true);
    }

    protected IntArray newInstance(dist d, int c) {
        return new IntArray_c(d, c, true);
    }

    protected void assign(IntArray rhs) {
        assert (rhs.getClass() == this.getClass());
        IntArray_c rhs_t = (IntArray_c)rhs;
        if (!Configuration.BAD_PLACE_RUNTIME_CHECK && rhs.distribution.equals(this.distribution)) {
            int count = this.arr_.length;
            for (int i = 0; i < count; ++i) {
                this.arr_[i] = rhs_t.arr_[i];
            }
        } else {
            super.assign(rhs);
        }
    }

    public void reduction(Operator.Reduction op) {
        if (!Configuration.BAD_PLACE_RUNTIME_CHECK) {
            int count = this.arr_.length;
            for (int i = 0; i < count; ++i) {
                op.apply(this.arr_[i]);
            }
        } else {
            super.reduction(op);
        }
    }
}

