/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.common.util.binding;

import hj.runtime.common.Configuration;
import hj.runtime.common.util.binding.ThreadBindingConfiguration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ThreadBinding {
    public static final boolean BIND_THREADS_DIAGNOSTICS;
    private static final String thrdSuppLib = "HjThreadSupp";
    public static List<Integer>[][] THREAD_BINDING_MAPPING;

    private static final native int bind2CPU(int[] var0);

    private static final int getNumCPUs() {
        int nbCpu = Runtime.getRuntime().availableProcessors();
        if (BIND_THREADS_DIAGNOSTICS) {
            System.out.println("BIND_THREADS: Detected " + nbCpu + " processors");
        }
        return nbCpu;
    }

    public static final Runnable mapPoolThreadToCPU(final Runnable workerRunnable, final int[] affinity) {
        return new Runnable(){

            public void run() {
                ThreadBinding.bind2CPU(affinity);
                workerRunnable.run();
            }
        };
    }

    public static final Runnable mapPoolThreadToCPU(Runnable workerRunnable, int pid, int wid, String threadName) {
        if (Configuration.shallBindThreads()) {
            if (Configuration.isWorkSharingRuntime()) {
                wid = 0;
            }
            List<Integer> list = ThreadBindingConfiguration.THREAD_BINDING_MAPPING[pid][wid];
            int[] affinity = new int[list.size()];
            int i = 0;
            Iterator<Integer> i$ = list.iterator();
            while (i$.hasNext()) {
                int cpuid;
                affinity[i] = cpuid = i$.next().intValue();
                ++i;
            }
            if (BIND_THREADS_DIAGNOSTICS) {
                System.out.println("BIND_THREADS: Mapping place:worker " + pid + ":" + wid + " to cpuids " + Arrays.toString(affinity));
            }
            return ThreadBinding.mapPoolThreadToCPU(workerRunnable, affinity);
        }
        return workerRunnable;
    }

    static {
        block2: {
            BIND_THREADS_DIAGNOSTICS = Configuration.BIND_THREADS_DIAGNOSTICS;
            THREAD_BINDING_MAPPING = null;
            try {
                System.loadLibrary(thrdSuppLib);
            }
            catch (UnsatisfiedLinkError ule) {
                if (!BIND_THREADS_DIAGNOSTICS) break block2;
                System.out.println("BIND_THREADS: Library HjThreadSupp not found ?");
            }
        }
    }
}

