/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh;

import hj.lang.Future;
import hj.lang.Runtime;
import hj.runtime.common.Configuration;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.Future_c;
import hj.runtime.wsh.InvocationStrategy;
import hj.runtime.wsh.Place;
import hj.runtime.wsh.Report;
import hj.runtime.wsh.VMInterface;
import hj.runtime.wsh.WshConfiguration;
import hj.runtime.wsh.abstractmetrics.AbstractMetrics;
import hj.runtime.wsh.abstractmetrics.AbstractMetricsFactory;

public class LocalPlace_c
extends Place {
    boolean shutdown;
    private AbstractMetrics abstractMetricsManager = AbstractMetricsFactory.getAbstractMetricsManager();

    public void runAsync(Activity a) {
        this.runActivity(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAsyncInFinish(Activity activity2) {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            activity2.maxOverheads(WshConfiguration.ABSTRACT_EXECUTION_OVERHEAD);
        }
        activity2.setInvocationStrategy(InvocationStrategy.ASYNC_IN_FINISH);
        this.runAsync(activity2);
        try {
            activity2.join();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        finally {
            if (Configuration.ABSTRACT_EXECUTION_STATS) {
                this.maxCritPathOps(activity2.getCritPathOps());
                this.addLocalOps(activity2.getTotalOps());
                this.maxOverheads(activity2.getOverheads());
                if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                    this.updateIdealTime();
                    this.addUnblockedTime(activity2.getTotalUnblockedTime());
                    this.maxCritPathTime(activity2.getCritPathTime());
                }
            }
        }
    }

    private void prepareActivity(Activity childActivity) {
        childActivity.setPlace(this);
        Activity parent = (Activity)Runtime.getCurrentActivity();
        if (parent != null) {
            parent.finalizeActivitySpawn(childActivity);
        }
    }

    protected void scheduleActivity(Activity activity2) {
        this.threadPoolService.execute(activity2);
    }

    protected void runActivity(Activity activity2) {
        this.prepareActivity(activity2);
        if (activity2.isReady()) {
            this.scheduleActivity(activity2);
        }
    }

    public void resumeActivity(Activity a) {
        this.scheduleActivity(a);
    }

    public Future runAsyncWithReturn(Activity a) {
        Future_c result = a.future = new Future_c();
        this.runAsync(a);
        return result;
    }

    public String longName() {
        return this.toString() + "(shutdown=" + this.shutdown + ")";
    }

    public void customShutdown() {
        if (Report.should_report("activity", 5)) {
            Report.report(5, "shutting down " + this);
        }
        this.shutdown = true;
    }

    public void threadBlockedNotification() {
        this.getThreadPool().threadBlockedNotification();
    }

    public void threadUnblockedNotification() {
        this.getThreadPool().threadUnblockedNotification();
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public void addUnblockedTime(long t) {
        this.abstractMetricsManager.addUnblockedTime(t);
    }

    public long getTotalOps() {
        return this.abstractMetricsManager.getTotalOps();
    }

    public long getCritPathOps() {
        return this.abstractMetricsManager.getCritPathOps();
    }

    public void addLocalOps(long n) {
        this.abstractMetricsManager.addLocalOps(n);
    }

    public void addCritPathOps(long n) {
        this.abstractMetricsManager.addCritPathOps(n);
    }

    public void maxCritPathOps(long n) {
        this.abstractMetricsManager.maxCritPathOps(n);
    }

    public long getTotalUnblockedTime() {
        return this.abstractMetricsManager.getTotalUnblockedTime();
    }

    public long getCritPathTime() {
        return this.abstractMetricsManager.getCritPathTime();
    }

    public void maxCritPathTime(long t) {
        this.abstractMetricsManager.maxCritPathTime(t);
    }

    public long getResumeTime() {
        return this.abstractMetricsManager.getResumeTime();
    }

    public void setResumeTime() {
        this.abstractMetricsManager.setResumeTime();
    }

    public void updateIdealTime() {
        this.abstractMetricsManager.updateIdealTime();
    }

    public long getCurrentTime() {
        return this.abstractMetricsManager.getCurrentTime();
    }

    public long getOverheads() {
        return this.abstractMetricsManager.getOverheads();
    }

    public void maxOverheads(long n) {
        this.abstractMetricsManager.maxOverheads(n);
    }
}

