/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh;

import hj.array.ArrayFactory;
import hj.array.DistributionFactory;
import hj.array.point_c;
import hj.array.sharedmemory.DefaultArrayFactory;
import hj.array.sharedmemory.RegionFactory;
import hj.lang.Object;
import hj.lang.PhaserAbst;
import hj.lang.Runtime;
import hj.lang.accumulator;
import hj.lang.dist;
import hj.lang.phaser;
import hj.lang.place;
import hj.lang.point;
import hj.lang.region;
import hj.runtime.common.Configuration;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.ActivityRunner;
import hj.runtime.wsh.HjThreadPoolExecutor;
import hj.runtime.wsh.LocalPlace_c;
import hj.runtime.wsh.Place;
import hj.runtime.wsh.PoolRunner;
import hj.runtime.wsh.PreLoader;
import hj.runtime.wsh.Report;
import hj.runtime.wsh.TwoLevelLockPlace;
import hj.runtime.wsh.VMInterface;
import hj.runtime.wsh.WshConfiguration;
import hj.runtime.wsh.finishAccumulator.FinishAccumulator;
import hj.runtime.wsh.phaser.PhaserImpl;
import hj.runtime.wsh.phaser.accumulator.Accumulator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class WshRuntime_c
extends Runtime {
    private final Place[] places_;
    private static WshRuntime_c wshRuntime;
    private static final Class[] STRING_ARRAYS;

    public WshRuntime_c() {
        int pc = WshConfiguration.NUMBER_OF_LOCAL_PLACES;
        this.places_ = new Place[pc];
        wshRuntime = this;
    }

    public String getRuntimeType() {
        return "work-sharing" + (WshConfiguration.FJ ? " (FJ)" : "");
    }

    public static Activity getCurrentWshActivity() {
        return wshRuntime.currentActivity();
    }

    private void createPlaces() {
        int pc;
        place.MAX_PLACES = pc = WshConfiguration.NUMBER_OF_LOCAL_PLACES;
        for (int i = 0; i < pc; ++i) {
            this.places_[i] = new LocalPlace_c();
        }
        place.initialize();
        TwoLevelLockPlace.init(this.places_.length);
    }

    protected void initialize() {
        this.createPlaces();
    }

    protected void loadAndInitLibs() {
        if (null != WshConfiguration.LOAD) {
            String[] libs = WshConfiguration.LOAD.split(":");
            for (int i = libs.length - 1; i >= 0; --i) {
                System.loadLibrary(libs[i]);
            }
        }
    }

    public void prepareForBoot() {
        this.initialize();
        if (Report.should_report("activity", 5)) {
            Thread t = Thread.currentThread();
            int tCount = Thread.activeCount();
            Report.report(5, Thread.currentThread() + ":" + System.currentTimeMillis() + " starts in group " + t.getThreadGroup() + " with " + tCount + " threads active.");
            Thread[] a = new Thread[tCount];
            int count = Thread.enumerate(a);
            for (int i = 0; i < count; ++i) {
                Report.report(5, "Thread " + (a[i] == null ? "null" : a[i].getName()) + " is active.");
            }
        }
        this.loadAndInitLibs();
    }

    public void shutdown() {
        this.shutdownAllPlaces();
        if (Report.should_report("activity", 5)) {
            Report.report(5, "terminates.");
        }
        this.finalizeAndTermLibs();
        this.dumpStatistics();
    }

    private void shutdownAllPlaces() {
        for (int i = 0; i < this.places_.length; ++i) {
            this.places_[i].shutdown();
        }
    }

    protected void finalizeAndTermLibs() {
    }

    protected void run(String[] args) {
        this.prepareForBoot();
        try {
            Activity mainActivity = this.createMainActivity(args);
            this.run(mainActivity);
            if (!mainActivity.success) {
                WshRuntime_c.setExitCode(202);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            WshRuntime_c.setExitCode(201);
        }
        this.shutdown();
    }

    public void run(Activity mainActivity) {
        if (Report.should_report("activity", 5)) {
            Report.report(5, "starts running the Boot Activity.");
        }
        ((Place)Runtime.getDefaultPlace()).runAsyncInFinish(mainActivity);
        if (Report.should_report("activity", 5)) {
            Report.report(5, "finished running the Boot Activity.");
        }
    }

    private Activity createMainActivity(String[] args) throws Error {
        java.lang.Object[] tmp = new java.lang.Object[]{args};
        Activity atmp = null;
        try {
            if (Report.should_report("activity", 5)) {
                Report.report(5, Thread.currentThread() + ":" + System.currentTimeMillis() + " " + this + " starting user class |" + WshConfiguration.MAIN_CLASS_NAME + "|.");
            }
            Class<?> main = Class.forName(WshConfiguration.MAIN_CLASS_NAME + "$Main", true, HJ_CLASSLOADER);
            if (WshConfiguration.PRELOAD_CLASSES) {
                PreLoader.preLoad(main, WshConfiguration.PRELOAD_STRINGS);
            }
            atmp = (Activity)main.getDeclaredConstructor(STRING_ARRAYS).newInstance(tmp);
        }
        catch (Exception e) {
            System.err.println("Could not find default constructor of main class '" + WshConfiguration.MAIN_CLASS_NAME + "$Main" + "'!");
            throw new Error(e);
        }
        Activity appMain = atmp;
        return appMain;
    }

    public void setCurrentPlace(place p) {
        assert (p != null);
        Thread t = Thread.currentThread();
        if (t instanceof PoolRunner) {
            ((PoolRunner)((java.lang.Object)t)).setPlace((Place)p);
        }
    }

    public Place currentPlace() {
        if (this.getPlaces().length == 1) {
            return this.getPlaces()[0];
        }
        Thread t = Thread.currentThread();
        Place ret = null;
        if (t instanceof PoolRunner) {
            ret = ((PoolRunner)((java.lang.Object)t)).getPlace();
        }
        return ret;
    }

    public Activity currentActivity() {
        Thread t = Thread.currentThread();
        Activity result = null;
        if (t instanceof ActivityRunner) {
            result = ((ActivityRunner)((java.lang.Object)t)).getActivity();
        }
        return result;
    }

    protected Place[] getPlaces() {
        return this.places_;
    }

    protected Place getPlace0() {
        if (this.places_ == null) {
            throw new RuntimeException("There's no place in runtime");
        }
        return this.places_[0];
    }

    protected Place[] getLocalPlaces() {
        return this.getPlaces();
    }

    public Runtime.Factory getFactory() {
        Runtime.Factory f = new Runtime.Factory(){

            public region.factory getRegionFactory() {
                return new RegionFactory();
            }

            public dist.factory getDistributionFactory() {
                return new DistributionFactory();
            }

            public point.factory getPointFactory() {
                return new point_c.factory();
            }

            public PhaserAbst.factory getPhaserFactory() {
                return new PhaserAbst.factory(){

                    public PhaserAbst PhaserAbst() {
                        return new PhaserImpl();
                    }

                    public PhaserAbst PhaserAbst(PhaserImpl.Mode mode) {
                        return new PhaserImpl(mode);
                    }

                    public PhaserAbst PhaserAbst(PhaserImpl.Mode mode, int numTiers, int numDegree) {
                        return new PhaserImpl(mode, numTiers, numDegree);
                    }

                    public PhaserAbst PhaserAbst(PhaserImpl.Mode mode, int bound, PhaserImpl.Cycle cycle, int batchSize) {
                        return new PhaserImpl(mode, bound, cycle, batchSize);
                    }

                    public PhaserAbst PhaserAbst(String name, PhaserImpl.Mode mode, int busyWaitCount) {
                        return new PhaserImpl(name, mode, busyWaitCount);
                    }

                    public PhaserAbst PhaserAbst(String name, PhaserImpl.Mode mode, int busyWaitCount, int numTiers, int numDegree) {
                        return new PhaserImpl(name, mode, busyWaitCount, numTiers, numDegree);
                    }

                    public PhaserAbst PhaserAbst(String name, PhaserImpl.Mode mode, int busyWaitCount, int bound, PhaserImpl.Cycle cycle, int batchSize) {
                        return new PhaserImpl(name, mode, busyWaitCount, bound, cycle, batchSize);
                    }
                };
            }

            public accumulator.factory getAccumulatorFactory() {
                return new accumulator.factory(){

                    public accumulator accumulator(accumulator.Operator ope, Class type, phaser ph) {
                        return new Accumulator(ope, type, ph);
                    }

                    public accumulator accumulator(accumulator.Operator ope, Class type, phaser ph, boolean isLazy) {
                        return new Accumulator(ope, type, ph, isLazy);
                    }

                    public accumulator accumulator(accumulator.Operator ope, Class type, phaser ph, boolean isLazy, int arrsize) {
                        return new Accumulator(ope, type, ph, isLazy, arrsize);
                    }

                    public accumulator accumulator(accumulator.Operator ope, Class type, phaser ph, boolean isLazy, int arrsize, int func, double delay, double coef) {
                        return new Accumulator(ope, type, ph, isLazy, arrsize, func, delay, coef);
                    }

                    public accumulator accumulator(accumulator.Operator ope, Class type) {
                        return new FinishAccumulator(ope, type);
                    }

                    public accumulator accumulator(accumulator.Operator ope, Class type, boolean isLazy) {
                        return new FinishAccumulator(ope, type, isLazy);
                    }

                    public accumulator accumulator(accumulator.Operator ope, Class type, boolean isLazy, int func, double delay, double coef) {
                        return new FinishAccumulator(ope, type, isLazy, func, delay, coef);
                    }
                };
            }

            public ArrayFactory getArrayFactory() {
                return new DefaultArrayFactory();
            }

            public place.factory getPlaceFactory() {
                return new place.factory(){

                    public place place(int i) {
                        int index = i % place.MAX_PLACES;
                        return WshRuntime_c.this.places_[index];
                    }

                    public Set places(int last) {
                        TreeSet<Place> result = new TreeSet<Place>();
                        for (int i = 0; i <= last % place.MAX_PLACES; ++i) {
                            result.add(WshRuntime_c.this.places_[i]);
                        }
                        return result;
                    }

                    public place here() {
                        return WshRuntime_c.this.currentPlace();
                    }
                };
            }
        };
        return f;
    }

    private void dumpPlaceStatistics() {
        System.err.println("  Places Statistics");
        for (int i = 0; i < this.getPlaces().length; ++i) {
            HjThreadPoolExecutor executor = this.getPlaces()[i].getThreadPool();
            System.err.println(executor.getStats());
        }
        System.err.println("");
    }

    private void dumpStatistics() {
        if (Configuration.ABSTRACT_EXECUTION_STATS) {
            System.err.println("\n#### START OF ABSTRACT EXECUTION STATISTICS (EXCLUDING MAIN ACTIVITY) ####");
            long sum = 0L;
            System.err.println("    TOTAL NUMBER OF TASKS = " + sum);
            sum = 0L;
            for (int i = 0; i <= this.getPlaces().length - 1; ++i) {
                sum += this.getPlaces()[i].getTotalOps();
            }
            System.err.println("\n    WORK = TOTAL NUMBER OF OPS DEFINED BY CALLS TO hj.lang.perf.addLocalOps() = " + sum);
            long max = 0L;
            for (int i = 0; i <= this.getPlaces().length - 1; ++i) {
                max = Math.max(max, this.getPlaces()[i].getCritPathOps());
            }
            System.err.println("\n    CPL = CRITICAL PATH LENGTH OF OPS DEFINED BY CALLS TO hj.lang.perf.addLocalOps() = " + max);
            double speedup = (double)max > 0.0 ? (double)sum / (double)max : 0.0;
            System.err.println("\n    IDEAL PARALLELISM = WORK/CPL = " + speedup);
            if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                int i;
                int i2;
                sum = 0L;
                for (i2 = 0; i2 <= this.getPlaces().length - 1; ++i2) {
                    sum += this.getPlaces()[i2].getTotalUnblockedTime();
                }
                System.err.println("\n    TOTAL UNBLOCKED TIME FOR ALL ACTIVITIES (in milliseconds) = " + sum);
                System.err.print("    TOTAL UNBLOCKED TIME PER PLACE = [ ");
                for (i2 = 0; i2 <= this.getPlaces().length - 1; ++i2) {
                    System.err.print(this.getPlaces()[i2].getTotalUnblockedTime() + " ");
                }
                System.err.println("]");
                max = 0L;
                for (i = 0; i <= this.getPlaces().length - 1; ++i) {
                    max = Math.max(max, this.getPlaces()[i].getCritPathTime());
                }
                System.err.println("\n    CRITICAL PATH LENGTH OF ALL ACTIVITIES (in milliseconds) = " + max);
                System.err.print("    CRITICAL PATH LENGTH PER PLACE = [ ");
                for (i = 0; i <= this.getPlaces().length - 1; ++i) {
                    System.err.print(this.getPlaces()[i].getCritPathTime() + " ");
                }
                System.err.println("]");
                speedup = (double)max > 0.0 ? (double)sum / (double)max : 0.0;
                System.err.println("\n    IDEAL SPEEDUP IN EXECUTION TIME,(TOTAL TIME) / (CRIT PATH LENGTH) = " + speedup);
            }
            System.err.println("#### END OF ABSTRACT EXECUTION STATISTICS (EXCLUDING MAIN ACTIVITY) ####");
        }
    }

    public void startIsolation_() {
        TwoLevelLockPlace.atomicStarLock();
    }

    public int[] startIsolation_(List objs) {
        if (objs == null || objs.size() == 0) {
            TwoLevelLockPlace.atomicStarLock();
            return null;
        }
        int[] placeIDs = new int[objs.size()];
        for (int i = 0; i < objs.size(); ++i) {
            Object obj = (Object)objs.get(i);
            placeIDs[i] = obj instanceof place ? ((place)obj).id : obj.location.id;
        }
        TwoLevelLockPlace.atomicPLock(placeIDs);
        return placeIDs;
    }

    public int[] startIsolation_(Object[] objs) {
        if (objs == null) {
            TwoLevelLockPlace.atomicStarLock();
            return null;
        }
        int[] placeIDs = new int[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            Object obj = objs[i];
            placeIDs[i] = obj instanceof place ? ((place)obj).id : obj.location.id;
        }
        TwoLevelLockPlace.atomicPLock(placeIDs);
        return placeIDs;
    }

    public int startIsolation_(Object obj) {
        int placeID = obj instanceof place ? ((place)obj).id : obj.location.id;
        TwoLevelLockPlace.atomicPLock(placeID);
        return placeID;
    }

    public void stopIsolation_() {
        TwoLevelLockPlace.atomicStarUnlock();
    }

    public int[] startIsolation_(Object obj1, Object obj2) {
        int[] placeIDs = new int[]{obj1 instanceof place ? ((place)obj1).id : obj1.location.id, obj2 instanceof place ? ((place)obj2).id : obj2.location.id};
        TwoLevelLockPlace.atomicPLock(placeIDs[0], placeIDs[1]);
        return placeIDs;
    }

    public void stopIsolation_(int placeID) {
        TwoLevelLockPlace.atomicPUnlock(placeID);
    }

    public void stopIsolation_(int[] placeIDs) {
        if (placeIDs == null) {
            TwoLevelLockPlace.atomicStarUnlock();
        } else if (placeIDs.length == 2) {
            TwoLevelLockPlace.atomicPUnlock(placeIDs[0], placeIDs[1]);
        } else {
            TwoLevelLockPlace.atomicPUnlock(placeIDs);
        }
    }

    static {
        STRING_ARRAYS = new Class[]{String[].class};
    }
}

