/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.threadpool;

import hj.runtime.common.util.binding.ThreadBinding;
import hj.runtime.wsh.HjManagedBlocker;
import hj.runtime.wsh.HjTaskQueue;
import hj.runtime.wsh.HjThreadPoolExecutor;
import hj.runtime.wsh.Report;
import hj.runtime.wsh.threadpool.WshThread;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class WshThreadPool
extends ThreadPoolExecutor
implements HjThreadPoolExecutor {
    protected AtomicInteger nbThreadBlocked = new AtomicInteger(0);
    private final int nbThreadsMin;

    public WshThreadPool(int nThreads) {
        super(nThreads, nThreads, 1000L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new HjTaskQueue(), new HjThreadFactory());
        this.nbThreadsMin = nThreads;
        this.prestartAllCoreThreads();
        if (Report.should_report("thread", 3)) {
            Report.report(3, "Starting Wsh Thread pool with " + this.getPoolSize() + " threads");
        }
    }

    private synchronized void increasePoolSize() {
        this.setCorePoolSize(this.getCorePoolSize() + 1);
        this.setMaximumPoolSize(this.getMaximumPoolSize() + 1);
    }

    private synchronized void decreasePoolSize() {
    }

    public int queueSize() {
        return this.getQueue().size();
    }

    public String getStats() {
        long poolTaskCount = this.getTaskCount();
        String res = "    total nb of activities scheduled = " + poolTaskCount;
        int poolLargestSize = this.getLargestPoolSize();
        int poolSize = this.getPoolSize();
        int poolCoreSize = this.getCorePoolSize();
        int poolMaxSize = this.getMaximumPoolSize();
        res = res + "    pool currentSize = " + poolSize + " largest = " + poolLargestSize + " core = " + poolCoreSize + " max = " + poolMaxSize;
        return res;
    }

    public int getNbThreadBlocked() {
        return this.nbThreadBlocked.get();
    }

    public void threadBlockedNotification() {
        this.nbThreadBlocked.addAndGet(1);
        if (this.getNbThreadBlocked() >= this.getCorePoolSize()) {
            this.increasePoolSize();
        }
    }

    public void threadUnblockedNotification() {
        this.nbThreadBlocked.addAndGet(-1);
    }

    public void threadBlockedNotification(HjManagedBlocker blocker) {
        this.threadBlockedNotification();
        try {
            blocker.block();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.threadUnblockedNotification();
    }

    public static class HjThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(0);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(0);
        private final String namePrefix;

        public HjThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "pool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        public Thread newThread(Runnable workerRunnable) {
            int x = this.threadNumber.getAndIncrement();
            String threadName = this.namePrefix + x;
            Runnable r = ThreadBinding.mapPoolThreadToCPU(workerRunnable, poolNumber.get(), x, threadName);
            WshThread t = new WshThread(this.group, r, threadName);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

