/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.threadpool;

import hj.runtime.wsh.HjManagedBlocker;
import hj.runtime.wsh.HjThreadPoolExecutor;
import hj.runtime.wsh.Report;
import hj.runtime.wsh.threadpool.WstThread;
import java.util.concurrent.atomic.AtomicInteger;
import jsr166y.ForkJoinPool;
import jsr166y.ForkJoinTask;
import jsr166y.ForkJoinWorkerThread;

public class WstThreadPool
extends ForkJoinPool
implements HjThreadPoolExecutor {
    protected AtomicInteger nbActiveThreads = new AtomicInteger(0);
    protected AtomicInteger corePoolSize = new AtomicInteger(0);
    protected final int minCorePoolSize;
    public static final boolean DEBUG = false;
    private static final AtomicInteger poolNumber = new AtomicInteger(0);
    private final AtomicInteger nbThreadBlocked = new AtomicInteger(0);

    public WstThreadPool(int nbThreads) {
        super(nbThreads, (ForkJoinPool.ForkJoinWorkerThreadFactory)new HjThreadFactory());
        this.minCorePoolSize = nbThreads;
        this.nbActiveThreads.addAndGet(this.minCorePoolSize);
        this.corePoolSize.addAndGet(this.minCorePoolSize);
        if (Report.should_report("thread", 3)) {
            Report.report(3, "Starting ForkJoin thread pool with parallelism level equals to " + nbThreads);
        }
    }

    public void execute(Runnable task) {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            ForkJoinTask fjt = ForkJoinTask.adapt((Runnable)task);
            fjt.fork();
        } else {
            super.execute(task);
        }
    }

    public String getStats() {
        long nbSteals = this.getStealCount();
        int poolSize = this.getPoolSize();
        int poolMaxSize = this.getMaximumPoolSize();
        return "    pool Size = " + poolSize + " max = " + poolMaxSize + " nb steals = " + nbSteals;
    }

    public synchronized void threadBlockedNotification() {
        int value = this.nbActiveThreads.addAndGet(-1);
        if (value <= this.minCorePoolSize) {
            this.maintainParallelism();
        }
    }

    public void threadBlockedNotification(HjManagedBlocker blocker) {
        try {
            WstThreadPool.managedBlock((ForkJoinPool.ManagedBlocker)blocker, (boolean)true);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public synchronized void threadUnblockedNotification() {
        int value = this.nbActiveThreads.addAndGet(1);
        if (value > this.minCorePoolSize) {
            this.maintainParallelism();
        }
    }

    protected void maintainParallelism() {
        int updatedValue = this.nbActiveThreads.get();
        if (updatedValue != this.minCorePoolSize) {
            int corePoolSize = this.getParallelism();
            int delta = this.minCorePoolSize - updatedValue;
            this.setParallelism(corePoolSize + delta);
            this.nbActiveThreads.addAndGet(delta);
            if (updatedValue > this.minCorePoolSize) {
                // empty if block
            }
        }
    }

    public int getNbThreadBlocked() {
        return this.nbThreadBlocked.get();
    }

    static /* synthetic */ AtomicInteger access$000() {
        return poolNumber;
    }

    public static class HjThreadFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        private final String namePrefix = "pool-" + WstThreadPool.access$000().getAndIncrement() + "-thread-";

        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            return new WstThread(this.namePrefix, pool);
        }
    }
}

