/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.util;

import hj.lang.DataDrivenFuture;
import hj.runtime.wsh.Activity;
import java.util.Collection;
import java.util.Iterator;

public class DataDrivenFutureList {
    private Collection<DataDrivenFuture> ddfList = null;
    private Iterator<DataDrivenFuture> waitingOn = null;
    private boolean ready = false;
    private final Activity activity;
    private boolean delegatedActivity = false;

    public DataDrivenFutureList(Activity activity2) {
        this.activity = activity2;
    }

    public synchronized void advance() {
        boolean dataAreReady = true;
        while (dataAreReady && this.waitingOn.hasNext()) {
            DataDrivenFuture nextDDF = this.waitingOn.next();
            assert (nextDDF instanceof DataDrivenFuture);
            DataDrivenFuture ddf = nextDDF;
            dataAreReady = ddf.isReady(this);
        }
        this.ready = dataAreReady;
        if (this.ready && this.delegatedActivity) {
            this.activity.getPlace().resumeActivity(this.activity);
        }
    }

    public void setList(Collection l) {
        this.ddfList = l;
        this.waitingOn = this.ddfList.iterator();
        this.advance();
    }

    public synchronized boolean isReady() {
        this.delegatedActivity = this.ddfList != null && !this.ready;
        return !this.delegatedActivity;
    }

    public void clear() {
        if (this.ddfList != null) {
            this.ddfList.clear();
        }
        this.ddfList = null;
        this.waitingOn = null;
    }
}

