/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wst.racedet;

import hj.runtime.wst.racedet.AsyncObject;
import hj.runtime.wst.racedet.DisjointSet;
import hj.runtime.wst.racedet.FinishObject;
import hj.runtime.wst.racedet.RaceDetException;
import hj.runtime.wst.racedet.RaceDetObject;
import hj.runtime.wst.racedet.ShadowObject;
import hj.runtime.wst.racedet.TaskObject;
import java.util.WeakHashMap;

public class ESPbags {
    public static boolean debug;
    public static DisjointSet ds;
    public static WeakHashMap<Object, ShadowObject> objectMap;

    public static void init() {
        debug = false;
        ds = new DisjointSet();
        objectMap = new WeakHashMap();
        System.out.println("Data race detection enabled");
        if (debug) {
            System.out.println("\t using ESP-bags algorithm");
        }
    }

    public static FinishObject startFinish(TaskObject to) {
        return new FinishObject(to);
    }

    public static void endFinish(FinishObject fo) {
        fo.endFinish();
    }

    public static AsyncObject startAsync(TaskObject fo) {
        return new AsyncObject(fo);
    }

    public static void endAsync(AsyncObject ao) {
        ao.endAsync();
    }

    public static ShadowObject getShadow(Object o, int size) {
        ShadowObject so = objectMap.get(o);
        if (so != null) {
            if (so.reader == null || so.reader.length != size) {
                so.allocate(size);
            }
        } else {
            so = new ShadowObject();
            so.allocate(size);
            objectMap.put(o, so);
        }
        return so;
    }

    public static void markRead(TaskObject to, RaceDetObject o, int size, int num, String file, int startLine, int endLine, int startPos, int endPos) {
        TaskObject reader = o.reader[num].task;
        TaskObject atomicWriter = o.atomicWriter[num].task;
        TaskObject writer = o.writer[num].task;
        if (writer != null && ds.isInPbag(writer)) {
            throw new RaceDetException(o.writer[num].fileName, o.writer[num].startLine, o.writer[num].endLine, o.writer[num].startPos, o.writer[num].endPos, file, startLine, endLine, startPos, endPos);
        }
        if (atomicWriter != null && ds.isInPbag(atomicWriter)) {
            throw new RaceDetException(o.atomicWriter[num].fileName, o.atomicWriter[num].startLine, o.atomicWriter[num].endLine, o.atomicWriter[num].startPos, o.atomicWriter[num].endPos, file, startLine, endLine, startPos, endPos);
        }
        if (reader == null || ds.isInSbag(reader)) {
            o.reader[num].update(to, file, startLine, endLine, startPos, endPos);
        }
    }

    public static void markReadView(TaskObject to, RaceDetObject o, int num, String file, int startLine, int endLine, int startPos, int endPos) {
    }

    public static void markReadArray(TaskObject to, Object o, int size, int num, String file, int startLine, int endLine, int startPos, int endPos) {
        ShadowObject so = ESPbags.getShadow(o, size);
        TaskObject reader = so.reader[num].task;
        TaskObject atomicWriter = so.atomicWriter[num].task;
        TaskObject writer = so.writer[num].task;
        if (writer != null && ds.isInPbag(writer)) {
            throw new RaceDetException(so.writer[num].fileName, so.writer[num].startLine, so.writer[num].endLine, so.writer[num].startPos, so.writer[num].endPos, file, startLine, endLine, startPos, endPos);
        }
        if (atomicWriter != null && ds.isInPbag(atomicWriter)) {
            throw new RaceDetException(so.atomicWriter[num].fileName, so.atomicWriter[num].startLine, so.atomicWriter[num].endLine, so.atomicWriter[num].startPos, so.atomicWriter[num].endPos, file, startLine, endLine, startPos, endPos);
        }
        if (reader == null || ds.isInSbag(reader)) {
            so.reader[num].update(to, file, startLine, endLine, startPos, endPos);
        }
    }

    public static void markWrite(TaskObject to, RaceDetObject o, int size, int num, String file, int startLine, int endLine, int startPos, int endPos) {
        TaskObject reader = o.reader[num].task;
        TaskObject writer = o.writer[num].task;
        TaskObject atomicReader = o.atomicReader[num].task;
        TaskObject atomicWriter = o.atomicWriter[num].task;
        if (writer != null && ds.isInPbag(writer)) {
            throw new RaceDetException(o.writer[num].fileName, o.writer[num].startLine, o.writer[num].endLine, o.writer[num].startPos, o.writer[num].endPos, file, startLine, endLine, startPos, endPos);
        }
        if (reader != null && ds.isInPbag(reader)) {
            throw new RaceDetException(o.reader[num].fileName, o.reader[num].startLine, o.reader[num].endLine, o.reader[num].startPos, o.reader[num].endPos, file, startLine, endLine, startPos, endPos);
        }
        if (atomicWriter != null && ds.isInPbag(atomicWriter)) {
            throw new RaceDetException(o.atomicWriter[num].fileName, o.atomicWriter[num].startLine, o.atomicWriter[num].endLine, o.atomicWriter[num].startPos, o.atomicWriter[num].endPos, file, startLine, endLine, startPos, endPos);
        }
        if (atomicReader != null && ds.isInPbag(atomicReader)) {
            throw new RaceDetException(o.atomicReader[num].fileName, o.atomicReader[num].startLine, o.atomicReader[num].endLine, o.atomicReader[num].startPos, o.atomicReader[num].endPos, file, startLine, endLine, startPos, endPos);
        }
        o.writer[num].update(to, file, startLine, endLine, startPos, endPos);
    }

    public static void markWriteView(TaskObject to, RaceDetObject o, int num, String file, int startLine, int endLine, int startPos, int endPos) {
    }

    public static void markWriteView_(TaskObject to, RaceDetObject o, int num, String file, int startLine, int endLine, int startPos, int endPos) {
    }

    public static void markWriteArray(TaskObject to, Object o, int size, int num, String file, int startLine, int endLine, int startPos, int endPos) {
        ShadowObject so = ESPbags.getShadow(o, size);
        TaskObject reader = so.reader[num].task;
        TaskObject writer = so.writer[num].task;
        TaskObject atomicReader = so.atomicReader[num].task;
        TaskObject atomicWriter = so.atomicWriter[num].task;
        if (writer != null && ds.isInPbag(writer)) {
            throw new RaceDetException(so.writer[num].fileName, so.writer[num].startLine, so.writer[num].endLine, so.writer[num].startPos, so.writer[num].endPos, file, startLine, endLine, startPos, endPos);
        }
        if (reader != null && ds.isInPbag(reader)) {
            throw new RaceDetException(so.reader[num].fileName, so.reader[num].startLine, so.reader[num].endLine, so.reader[num].startPos, so.reader[num].endPos, file, startLine, endLine, startPos, endPos);
        }
        if (atomicWriter != null && ds.isInPbag(atomicWriter)) {
            throw new RaceDetException(so.atomicWriter[num].fileName, so.atomicWriter[num].startLine, so.atomicWriter[num].endLine, so.atomicWriter[num].startPos, so.atomicWriter[num].endPos, file, startLine, endLine, startPos, endPos);
        }
        if (atomicReader != null && ds.isInPbag(atomicReader)) {
            throw new RaceDetException(so.atomicReader[num].fileName, so.atomicReader[num].startLine, so.atomicReader[num].endLine, so.atomicReader[num].startPos, so.atomicReader[num].endPos, file, startLine, endLine, startPos, endPos);
        }
        so.writer[num].update(to, file, startLine, endLine, startPos, endPos);
    }

    public static void markAtomicRead(TaskObject to, RaceDetObject o, int size, int num, String file, int startLine, int endLine, int startPos, int endPos) {
        TaskObject writer = o.writer[num].task;
        TaskObject atomicReader = o.atomicReader[num].task;
        if (writer != null && ds.isInPbag(writer)) {
            throw new RaceDetException(o.writer[num].fileName, o.writer[num].startLine, o.writer[num].endLine, o.writer[num].startPos, o.writer[num].endPos, file, startLine, endLine, startPos, endPos);
        }
        if (atomicReader == null || ds.isInSbag(atomicReader)) {
            o.atomicReader[num].update(to, file, startLine, endLine, startPos, endPos);
        }
    }

    public static void markAtomicReadView(TaskObject to, RaceDetObject o, int num, String file, int startLine, int endLine, int startPos, int endPos) {
    }

    public static void markAtomicReadArray(TaskObject to, Object o, int size, int num, String file, int startLine, int endLine, int startPos, int endPos) {
        ShadowObject so = ESPbags.getShadow(o, size);
        TaskObject writer = so.writer[num].task;
        TaskObject atomicReader = so.atomicReader[num].task;
        if (writer != null && ds.isInPbag(writer)) {
            throw new RaceDetException(so.writer[num].fileName, so.writer[num].startLine, so.writer[num].endLine, so.writer[num].startPos, so.writer[num].endPos, file, startLine, endLine, startPos, endPos);
        }
        if (atomicReader == null || ds.isInSbag(atomicReader)) {
            so.atomicReader[num].update(to, file, startLine, endLine, startPos, endPos);
        }
    }

    public static void markAtomicWrite(TaskObject to, RaceDetObject o, int size, int num, String file, int startLine, int endLine, int startPos, int endPos) {
        TaskObject writer = o.writer[num].task;
        TaskObject reader = o.reader[num].task;
        TaskObject atomicWriter = o.atomicWriter[num].task;
        if (writer != null && ds.isInPbag(writer)) {
            throw new RaceDetException(o.writer[num].fileName, o.writer[num].startLine, o.writer[num].endLine, o.writer[num].startPos, o.writer[num].endPos, file, startLine, endLine, startPos, endPos);
        }
        if (reader != null && ds.isInPbag(reader)) {
            throw new RaceDetException(o.reader[num].fileName, o.reader[num].startLine, o.reader[num].endLine, o.reader[num].startPos, o.reader[num].endPos, file, startLine, endLine, startPos, endPos);
        }
        if (atomicWriter == null || ds.isInSbag(atomicWriter)) {
            o.atomicWriter[num].update(to, file, startLine, endLine, startPos, endPos);
        }
    }

    public static void markAtomicWriteView(TaskObject to, RaceDetObject o, int num, String file, int startLine, int endLine, int startPos, int endPos) {
    }

    public static void markAtomicWriteArray(TaskObject to, Object o, int size, int num, String file, int startLine, int endLine, int startPos, int endPos) {
        ShadowObject so = ESPbags.getShadow(o, size);
        TaskObject writer = so.writer[num].task;
        TaskObject reader = so.reader[num].task;
        TaskObject atomicWriter = so.atomicWriter[num].task;
        if (writer != null && ds.isInPbag(writer)) {
            throw new RaceDetException(so.writer[num].fileName, so.writer[num].startLine, so.writer[num].endLine, so.writer[num].startPos, so.writer[num].endPos, file, startLine, endLine, startPos, endPos);
        }
        if (reader != null && ds.isInPbag(reader)) {
            throw new RaceDetException(so.reader[num].fileName, so.reader[num].startLine, so.reader[num].endLine, so.reader[num].startPos, so.reader[num].endPos, file, startLine, endLine, startPos, endPos);
        }
        if (atomicWriter == null || ds.isInSbag(atomicWriter)) {
            so.atomicWriter[num].update(to, file, startLine, endLine, startPos, endPos);
        }
    }

    public static void printTag(int startLn, int endLn, int startPos, int endPos, String fileName) {
        System.out.println("   Tag : " + startLn + " - " + endLn + " , " + startPos + " - " + endPos + " : " + fileName);
    }
}

