/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import polyglot.ast.NodeFactory;
import polyglot.ext.jl5.ast.JL5NodeFactory_c;
import polyglot.ext.jl5.types.JL5TypeSystem_c;
import polyglot.ext.jl5.types.reflect.JL5ClassFile;
import polyglot.ext.jl5.visit.ApplicationChecker;
import polyglot.ext.jl5.visit.JL5AmbiguityRemover;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Goal;
import polyglot.frontend.JLExtensionInfo;
import polyglot.frontend.JLScheduler;
import polyglot.frontend.Job;
import polyglot.frontend.Scheduler;
import polyglot.frontend.VisitorGoal;
import polyglot.types.TypeSystem;
import polyglot.types.reflect.ClassFile;
import polyglot.visit.NodeVisitor;

public class JL5ExtensionInfo
extends JLExtensionInfo {
    public String defaultFileExtension() {
        return "jl5";
    }

    public String compilerName() {
        return "jl5c";
    }

    protected NodeFactory createNodeFactory() {
        return new JL5NodeFactory_c();
    }

    protected TypeSystem createTypeSystem() {
        return new JL5TypeSystem_c();
    }

    public ClassFile createClassFile(File classFileSource, byte[] code) {
        return new JL5ClassFile(classFileSource, code, (ExtensionInfo)this);
    }

    public Scheduler createScheduler() {
        return new JL5Scheduler(this);
    }

    static class JL5Scheduler
    extends JLScheduler {
        JL5Scheduler(JLExtensionInfo extInfo) {
            super((ExtensionInfo)extInfo);
        }

        public List<Goal> goals(Job job) {
            ArrayList<Goal> goals = new ArrayList<Goal>();
            goals.add(this.Parsed(job));
            goals.add(this.TypesInitialized(job));
            goals.add(this.ImportTableInitialized(job));
            goals.add(this.PreTypeCheck(job));
            goals.add(this.TypesInitializedForCommandLineBarrier());
            goals.add(this.TypeChecked(job));
            goals.add(this.GenericTypeHandled(job));
            goals.add(this.ReassembleAST(job));
            goals.add(this.ConformanceChecked(job));
            goals.add(this.ReachabilityChecked(job));
            goals.add(this.ExceptionsChecked(job));
            goals.add(this.ExitPathsChecked(job));
            goals.add(this.InitializationsChecked(job));
            goals.add(this.ConstructorCallsChecked(job));
            goals.add(this.ForwardReferencesChecked(job));
            goals.add(this.ApplicationChecked(job));
            goals.add(this.Serialized(job));
            goals.add(this.CodeGenerated(job));
            goals.add(this.End(job));
            return goals;
        }

        public Goal GenericTypeHandled(Job job) {
            TypeSystem ts = job.extensionInfo().typeSystem();
            NodeFactory nf = job.extensionInfo().nodeFactory();
            return new VisitorGoal("GenericTypeHandled", job, (NodeVisitor)new JL5AmbiguityRemover(job, ts, nf)).intern((Scheduler)this);
        }

        public Goal ApplicationChecked(Job job) {
            TypeSystem ts = job.extensionInfo().typeSystem();
            NodeFactory nf = job.extensionInfo().nodeFactory();
            return new VisitorGoal("ApplicationChecked", job, (NodeVisitor)new ApplicationChecker(job, ts, nf)).intern((Scheduler)this);
        }
    }
}

