/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.Expr;
import polyglot.ast.Local;
import polyglot.ast.LocalDecl;
import polyglot.ast.Loop_c;
import polyglot.ast.NewArray;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.ext.jl5.ast.ExtendedFor;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.ParameterizedType;
import polyglot.types.ArrayType;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.ObjectType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ContextVisitor;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public class ExtendedFor_c
extends Loop_c
implements ExtendedFor {
    protected List varDecls;
    protected Expr expr;
    protected Stmt body;

    public ExtendedFor_c(Position pos, List varDecls, Expr expr, Stmt body) {
        super(pos);
        this.varDecls = varDecls;
        this.expr = expr;
        this.body = body;
    }

    public Stmt body() {
        return this.body;
    }

    @Override
    public ExtendedFor body(Stmt body) {
        ExtendedFor_c n = (ExtendedFor_c)this.copy();
        n.body = body;
        return n;
    }

    protected ExtendedFor_c reconstruct(List varDecls, Expr expr, Stmt body) {
        if (!CollectionUtil.allEqual((Collection)varDecls, (Collection)this.varDecls) || expr != this.expr || body != this.body) {
            ExtendedFor_c n = (ExtendedFor_c)this.copy();
            n.varDecls = varDecls;
            n.expr = expr;
            n.body = body;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        List varDecls = this.visitList(this.varDecls, v);
        Expr expr = (Expr)this.visitChild((Node)this.expr, v);
        Stmt body = (Stmt)this.visitChild((Node)this.body, v);
        return this.reconstruct(varDecls, expr, body);
    }

    public Context enterScope(Context c) {
        return c.pushBlock();
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        Type t = this.expr.type();
        if (t.isArray()) {
            ArrayType aType = (ArrayType)t;
            t = aType.base();
        } else if (ts.isSubtype(t, ts.rawify((Type)ts.Iterable()), tc.context())) {
            t = ts.findGenericSupertype((ObjectType)ts.Iterable(), (ObjectType)((ClassType)t));
            t = t == null ? ts.Object() : ((ParameterizedType)t).typeArguments().get(0);
        } else {
            throw new SemanticException("Can only iterate over an array or an instance of java.util.Iterable", this.expr.position());
        }
        LocalDecl ld = (LocalDecl)this.varDecls.get(0);
        Type declType = ld.type().type();
        if (!ts.isImplicitCastValid(t, declType, tc.context())) {
            throw new SemanticException("Incompatible types in for loop. Declared type is " + declType + " but the actual type is " + t + ".", this.expr.position());
        }
        if (this.expr instanceof Local && ld.localDef().asInstance().equals(((Local)this.expr).localInstance())) {
            throw new SemanticException("Variable: " + this.expr + " may not have been initialized", this.expr.position());
        }
        if (this.expr instanceof NewArray && ((NewArray)this.expr).init() != null) {
            for (Expr next : ((NewArray)this.expr).init().elements()) {
                if (!(next instanceof Local) || !ld.localDef().asInstance().equals(((Local)next).localInstance())) continue;
                throw new SemanticException("Variable: " + next + " may not have been initialized", next.position());
            }
        }
        return this;
    }

    public Block updateBody(Expr la, Stmt origLd, NodeFactory nf) {
        Block b = null;
        b = this.body() instanceof Block ? ((Block)this.body()).prepend((Stmt)nf.Eval(this.position(), la)).prepend(origLd) : nf.Block(this.position()).prepend(this.body()).prepend((Stmt)nf.Eval(this.position(), la)).prepend(origLd);
        return b;
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        return child.type();
    }

    public void printVarDecl(Object decl, CodeWriter w, PrettyPrinter tr) {
        if (decl instanceof LocalDecl) {
            LocalDecl ld = (LocalDecl)decl;
            this.print((Node)ld.flags(), w, tr);
            this.print((Node)ld.type(), w, tr);
            w.write(" ");
            tr.print((Node)this, (Node)ld.name(), w);
        }
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("for (");
        Iterator it = this.varDecls.iterator();
        while (it.hasNext()) {
            this.printVarDecl(it.next(), w, tr);
        }
        w.write(" : ");
        this.print((Node)this.expr, w, tr);
        w.write(")");
        this.printSubStmt(this.body, w, tr);
    }

    public String toString() {
        return "for (...) ...";
    }

    public Term firstChild() {
        return this.expr;
    }

    public List acceptCFG(CFGBuilder v, List<Term> succs) {
        v.visitCFG((Term)this.expr, FlowGraph.EDGE_KEY_TRUE, this.body.firstChild(), 1, FlowGraph.EDGE_KEY_FALSE, (Term)this, 0);
        v.push((Stmt)this).visitCFG((Term)this.body, (Term)this.expr, 1);
        return succs;
    }

    public Term continueTarget() {
        return this.body.firstChild();
    }

    public boolean condIsConstant() {
        return false;
    }

    public Expr cond() {
        return null;
    }
}

