/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import polyglot.ast.AmbTypeNode_c;
import polyglot.ast.Ambiguous;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.Prefix;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.ast.JL5AmbTypeNode;
import polyglot.ext.jl5.types.GenericTypeRef;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.ParameterizedType;
import polyglot.frontend.Globals;
import polyglot.frontend.Goal;
import polyglot.types.LazyRef;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;

public class JL5AmbTypeNode_c
extends AmbTypeNode_c
implements JL5AmbTypeNode {
    protected List typeArguments;

    public JL5AmbTypeNode_c(Position pos, Prefix qual, Id name) {
        this(pos, qual, name, Collections.EMPTY_LIST);
    }

    public JL5AmbTypeNode_c(Position pos, Prefix qual, Id name, List typeArguments) {
        super(pos, qual, name);
        this.typeArguments = typeArguments;
    }

    @Override
    public List typeArguments() {
        return this.typeArguments;
    }

    @Override
    public JL5AmbTypeNode typeArguments(List args) {
        JL5AmbTypeNode_c n = (JL5AmbTypeNode_c)this.copy();
        n.typeArguments = args;
        return n;
    }

    protected JL5AmbTypeNode_c reconstruct(Prefix qual, Id name, List args) {
        JL5AmbTypeNode_c superCopy = (JL5AmbTypeNode_c)super.reconstruct(qual, name);
        if (!CollectionUtil.allEqual((Collection)args, (Collection)superCopy.typeArguments)) {
            JL5AmbTypeNode_c n = (JL5AmbTypeNode_c)superCopy.copy();
            n.typeArguments = args;
            return n;
        }
        return superCopy;
    }

    public Node visitChildren(NodeVisitor v) {
        JL5AmbTypeNode_c superVisit = (JL5AmbTypeNode_c)super.visitChildren(v);
        List args = superVisit.visitList(this.typeArguments, v);
        return superVisit.reconstruct(superVisit.prefix(), superVisit.name(), args);
    }

    public Node disambiguate(ContextVisitor ar) throws SemanticException {
        SemanticException ex;
        try {
            Node n = ar.nodeFactory().disamb().disambiguate((Ambiguous)this, ar, this.position(), (Node)this.prefix, this.name);
            if (n instanceof CanonicalTypeNode && ((CanonicalTypeNode)n).type() instanceof JL5ParsedClassType) {
                CanonicalTypeNode tn = (CanonicalTypeNode)n;
                JL5ParsedClassType ct = (JL5ParsedClassType)tn.type();
                JL5TypeSystem ts = (JL5TypeSystem)ar.typeSystem();
                if (ct.isGeneric()) {
                    GenericTypeRef t;
                    if (this.typeArguments.isEmpty()) {
                        t = ts.rawType(ct);
                    } else {
                        t = ts.parameterizedType(ct);
                        ParameterizedType pt = (ParameterizedType)t;
                        ArrayList<Type> typeArgs = new ArrayList<Type>();
                        for (int i = 0; i < this.typeArguments.size(); ++i) {
                            Type targ = ((TypeNode)this.typeArguments.get(i)).type();
                            typeArgs.add(targ);
                        }
                        pt.typeArguments(typeArgs);
                    }
                    tn.typeRef().update((Object)t);
                }
                return n;
            }
            if (n instanceof TypeNode) {
                TypeNode tn = (TypeNode)n;
                LazyRef sym2 = (LazyRef)this.type;
                sym2.update(tn.typeRef().get());
                Goal resolver = Globals.Scheduler().LookupGlobalType(sym2);
                resolver.update((Object)Goal.Status.SUCCESS);
                sym2.setResolver((Runnable)resolver);
                return n;
            }
            ex = new SemanticException("Could not find type \"" + (this.prefix == null ? this.name.id() : this.prefix.toString() + "." + this.name.id()) + "\".", this.position());
        }
        catch (SemanticException e) {
            ex = e;
        }
        LazyRef sym3 = (LazyRef)this.type;
        sym3.update((Object)ar.typeSystem().unknownType(this.position()));
        throw ex;
    }

    public String toString() {
        String res = super.toString();
        if (!this.typeArguments.isEmpty()) {
            String args = "<" + this.typeArguments.get(0).toString();
            for (int i = 1; i < this.typeArguments.size(); ++i) {
                args = args + ", " + this.typeArguments.get(i).toString();
            }
            args = args + ">";
            res = res + args;
        }
        return res;
    }
}

