/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.ast;

import polyglot.ast.Conditional_c;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ext.jl5.ast.JL5Conditional;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;

public class JL5Conditional_c
extends Conditional_c
implements JL5Conditional {
    public JL5Conditional_c(Position pos, Expr cond, Expr consequent, Expr alternative) {
        super(pos, cond, consequent, alternative);
    }

    public Node typeCheck(ContextVisitor tc) throws SemanticException {
        Type t2;
        JL5TypeSystem ts = (JL5TypeSystem)tc.typeSystem();
        Context ctx = tc.context();
        if (!ts.typeEquals(this.cond.type(), ts.Boolean(), ctx) && !ts.typeEquals(this.cond.type(), (Type)ts.BooleanWrapper(), ctx)) {
            throw new SemanticException("Condition of ternary expression must be of type boolean.", this.cond.position());
        }
        Expr e1 = this.consequent;
        Expr e2 = this.alternative;
        Type t1 = e1.type();
        if (ts.typeEquals(t1, t2 = e2.type(), ctx) || ts.equivalent(t1, t2)) {
            return this.type(t1);
        }
        if (t1.isNumeric() && t2.isNumeric()) {
            if (t1.isByte() && t2.isShort() || t1.isShort() && t2.isByte()) {
                return this.type(ts.Short());
            }
            if (t1.isIntOrLess() && t2.isInt() && ts.numericConversionValid(t1, e2.constantValue(), ctx)) {
                return this.type(t1);
            }
            if (t2.isIntOrLess() && t1.isInt() && ts.numericConversionValid(t2, e1.constantValue(), ctx)) {
                return this.type(t2);
            }
            return this.type(ts.promote(t1, t2));
        }
        if (t1.isNull() && t2.isReference()) {
            return this.type(t2);
        }
        if (t2.isNull() && t1.isReference()) {
            return this.type(t1);
        }
        if (t1.isNull() && t2.isPrimitive()) {
            return this.type((Type)ts.classOf(t2));
        }
        if (t2.isNull() && t1.isPrimitive()) {
            return this.type((Type)ts.classOf(t1));
        }
        if (t1.isReference() && t2.isReference()) {
            if (ts.isImplicitCastValid(t1, t2, ctx)) {
                return this.type(t2);
            }
            if (ts.isImplicitCastValid(t2, t1, ctx)) {
                return this.type(t1);
            }
        }
        throw new SemanticException("Could not find a type for ternary conditional expression.", this.position());
    }
}

