/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types;

import java.util.HashMap;
import java.util.Map;
import polyglot.ext.jl5.types.JL5Context;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.types.Context_c;
import polyglot.types.Name;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance;

public class JL5Context_c
extends Context_c
implements JL5Context {
    protected Map<Name, Ref<? extends Type>> typeVars;
    protected TypeVariable typeVariable;
    public static final Context_c.Kind TYPE_VAR = new Context_c.Kind("type-var");

    public JL5Context_c(TypeSystem ts) {
        super(ts);
    }

    @Override
    public JL5TypeSystem typeSystem() {
        return (JL5TypeSystem)this.ts;
    }

    @Override
    public VarInstance findVariableInThisScope(Name name) {
        VarInstance vi = super.findVariableInThisScope(name);
        if (vi == null && this.isClass()) {
            try {
                JL5TypeSystem jts = (JL5TypeSystem)this.ts;
                return jts.findEnumConstant((Type)this.currentClass(), jts.EnumMatcher((Type)this.currentClass(), name, this));
            }
            catch (SemanticException e) {
                return null;
            }
        }
        return vi;
    }

    @Override
    public VarInstance findVariableSilent(Name name) {
        VarInstance vi = this.findVariableInThisScope(name);
        if (vi != null) {
            return vi;
        }
        if (this.outer != null) {
            return this.outer.findVariableSilent(name);
        }
        return null;
    }

    protected Context_c push() {
        Context_c v = super.push();
        ((JL5Context_c)v).typeVars = null;
        return v;
    }

    @Override
    public JL5Context pushTypeVariable(TypeVariable iType) {
        JL5Context_c v = (JL5Context_c)this.push();
        v.typeVariable = iType;
        v.kind = TYPE_VAR;
        return v;
    }

    @Override
    public TypeVariable findTypeVariableInThisScope(Name name) {
        if (this.typeVariable != null && this.typeVariable.name().equals((Object)name)) {
            return this.typeVariable;
        }
        if (this.typeVars != null && this.typeVars.containsKey(name)) {
            return (TypeVariable)this.typeVars.get(name).get();
        }
        if (this.outer != null) {
            return ((JL5Context)this.outer).findTypeVariableInThisScope(name);
        }
        return null;
    }

    @Override
    public boolean inTypeVariable() {
        return this.kind == TYPE_VAR;
    }

    public String toString() {
        return super.toString() + "type var: " + this.typeVariable;
    }

    @Override
    public JL5Context addTypeVariable(Name name, Ref<? extends Type> type) {
        assert (type != null);
        if (this.typeVars == null) {
            this.typeVars = new HashMap<Name, Ref<? extends Type>>();
        }
        this.typeVars.put(name, type);
        return this;
    }
}

