/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.ArrayInit;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassLit;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Expr;
import polyglot.ast.FieldDecl;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.LocalDecl;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.ast.NullLit;
import polyglot.ext.jl5.ast.AnnotationElem;
import polyglot.ext.jl5.ast.ElementValuePair;
import polyglot.ext.jl5.ast.JL5Field;
import polyglot.ext.jl5.ast.JL5ProcedureMatcher;
import polyglot.ext.jl5.ast.NormalAnnotationElem;
import polyglot.ext.jl5.types.AnnotationElemInstance;
import polyglot.ext.jl5.types.AnnotationElemInstance_c;
import polyglot.ext.jl5.types.AnySubType;
import polyglot.ext.jl5.types.AnySubType_c;
import polyglot.ext.jl5.types.AnySuperType;
import polyglot.ext.jl5.types.AnySuperType_c;
import polyglot.ext.jl5.types.AnyType;
import polyglot.ext.jl5.types.AnyType_c;
import polyglot.ext.jl5.types.EnumInstance;
import polyglot.ext.jl5.types.EnumInstance_c;
import polyglot.ext.jl5.types.GenericTypeRef;
import polyglot.ext.jl5.types.IntersectionType;
import polyglot.ext.jl5.types.IntersectionType_c;
import polyglot.ext.jl5.types.JL5ArrayType;
import polyglot.ext.jl5.types.JL5ArrayType_c;
import polyglot.ext.jl5.types.JL5ClassDef;
import polyglot.ext.jl5.types.JL5ClassDef_c;
import polyglot.ext.jl5.types.JL5ConstructorDef_c;
import polyglot.ext.jl5.types.JL5ConstructorInstance_c;
import polyglot.ext.jl5.types.JL5Context_c;
import polyglot.ext.jl5.types.JL5FieldInstance_c;
import polyglot.ext.jl5.types.JL5Flags;
import polyglot.ext.jl5.types.JL5ImportTable;
import polyglot.ext.jl5.types.JL5MethodDef_c;
import polyglot.ext.jl5.types.JL5MethodInstance;
import polyglot.ext.jl5.types.JL5MethodInstance_c;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.ext.jl5.types.JL5ParsedClassType_c;
import polyglot.ext.jl5.types.JL5PrimitiveType_c;
import polyglot.ext.jl5.types.JL5ProcedureInstance;
import polyglot.ext.jl5.types.JL5TypeEnv_c;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.ParameterizedType;
import polyglot.ext.jl5.types.ParameterizedType_c;
import polyglot.ext.jl5.types.RawType;
import polyglot.ext.jl5.types.RawType_c;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.types.TypeVariable_c;
import polyglot.ext.jl5.types.Wildcard;
import polyglot.ext.jl5.types.inference.InferenceSolver;
import polyglot.ext.jl5.types.inference.InferenceSolver_c;
import polyglot.ext.jl5.types.inference.LubType;
import polyglot.ext.jl5.types.inference.LubType_c;
import polyglot.ext.jl5.types.reflect.JL5ClassFileLazyClassInitializer;
import polyglot.frontend.Source;
import polyglot.types.ArrayType;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.ConstructorDef;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.FieldDef;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.ImportTable;
import polyglot.types.Matcher;
import polyglot.types.MemberInstance;
import polyglot.types.MethodDef;
import polyglot.types.MethodInstance;
import polyglot.types.Name;
import polyglot.types.NoMemberException;
import polyglot.types.ObjectType;
import polyglot.types.Package;
import polyglot.types.ParsedClassType;
import polyglot.types.PrimitiveType;
import polyglot.types.QName;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.StructType;
import polyglot.types.Type;
import polyglot.types.TypeEnv;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.types.TypeSystem_c;
import polyglot.types.Types;
import polyglot.types.reflect.ClassFile;
import polyglot.types.reflect.ClassFileLazyClassInitializer;
import polyglot.util.Copy;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.Predicate2;
import polyglot.util.Transformation;
import polyglot.util.TransformingList;

public class JL5TypeSystem_c
extends TypeSystem_c
implements JL5TypeSystem {
    protected ClassType ENUM_;
    protected ClassType ANNOTATION_;
    protected ClassType ITERABLE_;
    protected ClassType ITERATOR_;
    protected ClassType INTEGER_WRAPPER;
    protected ClassType BYTE_WRAPPER;
    protected ClassType SHORT_WRAPPER;
    protected ClassType CHARACTER_WRAPPER;
    protected ClassType BOOLEAN_WRAPPER;
    protected ClassType LONG_WRAPPER;
    protected ClassType DOUBLE_WRAPPER;
    protected ClassType FLOAT_WRAPPER;
    protected ClassType VOID_WRAPPER;
    protected ClassType NUMBER_WRAPPER;
    protected final Flags TOP_LEVEL_CLASS_FLAGS;
    protected final Flags MEMBER_CLASS_FLAGS;
    Map<Ref<? extends Type>, Type> varargsArrayTypeCache;

    public JL5TypeSystem_c() {
        this.TOP_LEVEL_CLASS_FLAGS = JL5Flags.setAnnotationModifier(JL5Flags.setEnumModifier(((TypeSystem_c)this).TOP_LEVEL_CLASS_FLAGS));
        this.MEMBER_CLASS_FLAGS = JL5Flags.setAnnotationModifier(JL5Flags.setEnumModifier(((TypeSystem_c)this).MEMBER_CLASS_FLAGS));
        this.varargsArrayTypeCache = new HashMap<Ref<? extends Type>, Type>();
    }

    @Override
    public ClassType Class(Type t) {
        JL5ParsedClassType raw = (JL5ParsedClassType)this.Class();
        ParameterizedType pt = this.parameterizedType(raw);
        pt.typeArguments(Collections.singletonList(this.classOf(t)));
        return pt;
    }

    @Override
    public ClassType Enum() {
        if (this.ENUM_ != null) {
            return this.ENUM_;
        }
        this.ENUM_ = this.load("java.lang.Enum");
        return this.ENUM_;
    }

    @Override
    public ClassType Annotation() {
        if (this.ANNOTATION_ != null) {
            return this.ANNOTATION_;
        }
        this.ANNOTATION_ = this.load("java.lang.annotation.Annotation");
        return this.ANNOTATION_;
    }

    @Override
    public ClassType Iterable() {
        if (this.ITERABLE_ != null) {
            return this.ITERABLE_;
        }
        this.ITERABLE_ = this.load("java.lang.Iterable");
        return this.ITERABLE_;
    }

    @Override
    public ClassType Iterator() {
        if (this.ITERATOR_ != null) {
            return this.ITERATOR_;
        }
        this.ITERATOR_ = this.load("java.util.Iterator");
        return this.ITERATOR_;
    }

    @Override
    public ClassType IntegerWrapper() {
        if (this.INTEGER_WRAPPER != null) {
            return this.INTEGER_WRAPPER;
        }
        this.INTEGER_WRAPPER = this.load("java.lang.Integer");
        return this.INTEGER_WRAPPER;
    }

    @Override
    public ClassType ByteWrapper() {
        if (this.BYTE_WRAPPER != null) {
            return this.BYTE_WRAPPER;
        }
        this.BYTE_WRAPPER = this.load("java.lang.Byte");
        return this.BYTE_WRAPPER;
    }

    @Override
    public ClassType ShortWrapper() {
        if (this.SHORT_WRAPPER != null) {
            return this.SHORT_WRAPPER;
        }
        this.SHORT_WRAPPER = this.load("java.lang.Short");
        return this.SHORT_WRAPPER;
    }

    @Override
    public ClassType BooleanWrapper() {
        if (this.BOOLEAN_WRAPPER != null) {
            return this.BOOLEAN_WRAPPER;
        }
        this.BOOLEAN_WRAPPER = this.load("java.lang.Boolean");
        return this.BOOLEAN_WRAPPER;
    }

    @Override
    public ClassType CharacterWrapper() {
        if (this.CHARACTER_WRAPPER != null) {
            return this.CHARACTER_WRAPPER;
        }
        this.CHARACTER_WRAPPER = this.load("java.lang.Character");
        return this.CHARACTER_WRAPPER;
    }

    @Override
    public ClassType LongWrapper() {
        if (this.LONG_WRAPPER != null) {
            return this.LONG_WRAPPER;
        }
        this.LONG_WRAPPER = this.load("java.lang.Long");
        return this.LONG_WRAPPER;
    }

    @Override
    public ClassType DoubleWrapper() {
        if (this.DOUBLE_WRAPPER != null) {
            return this.DOUBLE_WRAPPER;
        }
        this.DOUBLE_WRAPPER = this.load("java.lang.Double");
        return this.DOUBLE_WRAPPER;
    }

    @Override
    public ClassType FloatWrapper() {
        if (this.FLOAT_WRAPPER != null) {
            return this.FLOAT_WRAPPER;
        }
        this.FLOAT_WRAPPER = this.load("java.lang.Float");
        return this.FLOAT_WRAPPER;
    }

    @Override
    public ClassType NumberWrapper() {
        if (this.NUMBER_WRAPPER != null) {
            return this.NUMBER_WRAPPER;
        }
        this.NUMBER_WRAPPER = this.load("java.lang.Number");
        return this.NUMBER_WRAPPER;
    }

    public ClassType VoidWrapper() {
        if (this.VOID_WRAPPER != null) {
            return this.VOID_WRAPPER;
        }
        this.VOID_WRAPPER = this.load("java.lang.Void");
        return this.VOID_WRAPPER;
    }

    @Override
    public MethodInstance wrapperGetter(PrimitiveType t) {
        MethodInstance mi;
        ClassType wrapperType = this.classOf((Type)t);
        Name mthName = Name.make((String)(t.toString() + "Value"));
        try {
            mi = this.findMethod((Type)wrapperType, this.MethodMatcher((Type)wrapperType, mthName, Collections.EMPTY_LIST, null));
        }
        catch (SemanticException e) {
            throw new InternalCompilerError((Throwable)e);
        }
        return mi;
    }

    public MethodInstance wrapperGetter(ClassType t) {
        MethodInstance mi;
        this.wrapperTypeString((Type)t);
        ClassType wrapperType = this.classOf((Type)t);
        Name mthName = Name.make((String)(t.toString() + "Value"));
        try {
            mi = this.findMethod((Type)wrapperType, this.MethodMatcher((Type)wrapperType, mthName, Collections.EMPTY_LIST, null));
        }
        catch (SemanticException e) {
            throw new InternalCompilerError((Throwable)e);
        }
        return mi;
    }

    @Override
    public ConstructorInstance wrapperConstructor(PrimitiveType t) {
        ClassType ct = this.classOf((Type)t);
        try {
            return this.findConstructor((Type)ct, this.ConstructorMatcher((Type)ct, Collections.singletonList(t), null));
        }
        catch (SemanticException e) {
            throw new InternalCompilerError(e.getMessage());
        }
    }

    @Override
    public ClassType classOf(Type t) {
        Context context = this.emptyContext();
        if (t.isClass()) {
            return (ClassType)t;
        }
        if (t.isArray()) {
            return this.load("java.lang.reflect.Array");
        }
        if (this.typeEquals(t, this.Float(), context)) {
            return this.FloatWrapper();
        }
        if (this.typeEquals(t, this.Double(), context)) {
            return this.DoubleWrapper();
        }
        if (this.typeEquals(t, this.Long(), context)) {
            return this.LongWrapper();
        }
        if (this.typeEquals(t, this.Int(), context)) {
            return this.IntegerWrapper();
        }
        if (this.typeEquals(t, this.Short(), context)) {
            return this.ShortWrapper();
        }
        if (this.typeEquals(t, this.Byte(), context)) {
            return this.ByteWrapper();
        }
        if (this.typeEquals(t, this.Char(), context)) {
            return this.CharacterWrapper();
        }
        if (this.typeEquals(t, this.Boolean(), context)) {
            return this.BooleanWrapper();
        }
        if (this.typeEquals(t, this.Void(), context)) {
            return this.VoidWrapper();
        }
        throw new InternalCompilerError("Unrecognized primitive type " + t);
    }

    public boolean isByte(Type t) {
        Context context = this.emptyContext();
        if (this.typeEquals(t, (Type)this.ByteWrapper(), context)) {
            return true;
        }
        return super.isByte(t);
    }

    public boolean isBoolean(Type t) {
        Context context = this.emptyContext();
        if (this.typeEquals(t, (Type)this.BooleanWrapper(), context)) {
            return true;
        }
        return super.isBoolean(t);
    }

    public boolean isChar(Type t) {
        Context context = this.emptyContext();
        if (this.typeEquals(t, (Type)this.CharacterWrapper(), context)) {
            return true;
        }
        return super.isChar(t);
    }

    public boolean isShort(Type t) {
        Context context = this.emptyContext();
        if (this.typeEquals(t, (Type)this.ShortWrapper(), context)) {
            return true;
        }
        return super.isShort(t);
    }

    public boolean isInt(Type t) {
        Context context = this.emptyContext();
        if (this.typeEquals(t, (Type)this.IntegerWrapper(), context)) {
            return true;
        }
        return super.isInt(t);
    }

    public boolean isLong(Type t) {
        Context context = this.emptyContext();
        if (this.typeEquals(t, (Type)this.LongWrapper(), context)) {
            return true;
        }
        return super.isLong(t);
    }

    public boolean isFloat(Type t) {
        Context context = this.emptyContext();
        if (this.typeEquals(t, (Type)this.FloatWrapper(), context)) {
            return true;
        }
        return super.isFloat(t);
    }

    public boolean isDouble(Type t) {
        Context context = this.emptyContext();
        if (this.typeEquals(t, (Type)this.DoubleWrapper(), context)) {
            return true;
        }
        return super.isDouble(t);
    }

    @Override
    public MethodDef methodDef(Position pos, Ref<? extends StructType> container, Flags flags, Ref<? extends Type> returnType, Name name, List<Ref<? extends Type>> argTypes, List<Ref<? extends Type>> excTypes) {
        return this.methodDef(pos, container, flags, returnType, name, argTypes, excTypes, new ArrayList<Ref<? extends Type>>(), false);
    }

    public ConstructorDef constructorDef(Position pos, Ref<? extends ClassType> container, Flags flags, List<Ref<? extends Type>> argTypes, List<Ref<? extends Type>> excTypes) {
        return this.constructorDef(pos, container, flags, argTypes, excTypes, new ArrayList<Ref<? extends Type>>());
    }

    @Override
    public MethodDef methodDef(Position pos, Ref<? extends StructType> container, Flags flags, Ref<? extends Type> returnType, Name name, List<Ref<? extends Type>> argTypes, List<Ref<? extends Type>> excTypes, List<Ref<? extends Type>> tvTypes, boolean compilerGenerated) {
        this.assert_(container);
        this.assert_(returnType);
        this.assert_(argTypes);
        this.assert_(excTypes);
        this.assert_(tvTypes);
        return new JL5MethodDef_c(this, pos, container, flags, returnType, name, argTypes, excTypes, tvTypes, compilerGenerated);
    }

    public ConstructorDef constructorDef(Position pos, Ref<? extends ClassType> container, Flags flags, List<Ref<? extends Type>> argTypes, List<Ref<? extends Type>> excTypes, List<Ref<? extends Type>> tvTypes) {
        this.assert_(container);
        this.assert_(argTypes);
        this.assert_(excTypes);
        return new JL5ConstructorDef_c((TypeSystem)this, pos, container, flags, argTypes, excTypes, tvTypes);
    }

    public ParsedClassType createClassType(Position pos, Ref<? extends ClassDef> def) {
        JL5ParsedClassType_c ct = new JL5ParsedClassType_c(this, pos, def);
        return ct;
    }

    public FieldInstance createFieldInstance(Position pos, Ref<? extends FieldDef> def) {
        return new JL5FieldInstance_c(this, pos, def);
    }

    @Override
    public MethodInstance createMethodInstance(Position position, Ref<? extends MethodDef> def) {
        return new JL5MethodInstance_c((TypeSystem)this, position, def);
    }

    public ConstructorInstance createConstructorInstance(Position pos, Ref<? extends ConstructorDef> def) {
        return new JL5ConstructorInstance_c((TypeSystem)this, pos, def);
    }

    public Context emptyContext() {
        return new JL5Context_c(this);
    }

    @Override
    public MethodInstance erasureMethodInstance(MethodInstance mi) {
        ArrayList<Type> miErasureFormals = new ArrayList<Type>(mi.formalTypes().size());
        Iterator it = mi.formalTypes().iterator();
        while (it.hasNext()) {
            miErasureFormals.add(this.erasure((Type)it.next()));
        }
        ArrayList<Type> miErasureExcTypes = new ArrayList<Type>(mi.throwTypes().size());
        Iterator it2 = mi.formalTypes().iterator();
        while (it2.hasNext()) {
            miErasureExcTypes.add(this.erasure((Type)it2.next()));
        }
        Type erasureRet = this.erasure(mi.returnType());
        mi = mi.formalTypes(miErasureFormals);
        mi = mi.throwTypes(miErasureExcTypes);
        mi = mi.returnType(erasureRet);
        return mi;
    }

    public ClassDef createClassDef(Source fromSource) {
        return new JL5ClassDef_c(this, fromSource);
    }

    public void checkTopLevelClassFlags(Flags f) throws SemanticException {
        if (!f.clear(this.TOP_LEVEL_CLASS_FLAGS).equals((Object)JL5Flags.NONE)) {
            throw new SemanticException("Cannot declare a top-level class with flag(s) " + f.clear(this.TOP_LEVEL_CLASS_FLAGS) + ".");
        }
        if (f.isFinal() && f.isInterface()) {
            throw new SemanticException("Cannot declare a final interface.");
        }
        this.checkAccessFlags(f);
    }

    public void checkMemberClassFlags(Flags f) throws SemanticException {
        if (!f.clear(this.MEMBER_CLASS_FLAGS).equals((Object)JL5Flags.NONE)) {
            throw new SemanticException("Cannot declare a member class with flag(s) " + f.clear(this.MEMBER_CLASS_FLAGS) + ".");
        }
        if (f.isStrictFP() && f.isInterface()) {
            throw new SemanticException("Cannot declare a strictfp interface.");
        }
        if (f.isFinal() && f.isInterface()) {
            throw new SemanticException("Cannot declare a final interface.");
        }
        this.checkAccessFlags(f);
    }

    public ConstructorDef defaultConstructor(Position pos, Ref<? extends ClassType> container) {
        this.assert_(container);
        Flags flags = ((ClassType)container.get()).flags();
        if (JL5Flags.isEnumModifier(flags)) {
            Flags access = Flags.NONE;
            access = access.Private();
            return this.constructorDef(pos, container, access, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        }
        return super.defaultConstructor(pos, container);
    }

    public boolean typeExtendsAnnotation(Type t) {
        if (t instanceof ClassType) {
            ClassType ct = (ClassType)t;
            return ((ClassType)ct.superClass()).fullName().equals((Object)QName.make((String)"java.lang.annotation.Annotation"));
        }
        return false;
    }

    public ClassFileLazyClassInitializer classFileLazyClassInitializer(ClassFile clazz) {
        return new JL5ClassFileLazyClassInitializer(clazz, this);
    }

    protected PrimitiveType createPrimitive(Name name) {
        return new JL5PrimitiveType_c(this, name);
    }

    public void checkClassConformance(ClassType ct, Context context) throws SemanticException {
        if (JL5Flags.isEnumModifier(ct.flags())) {
            JL5ParsedClassType pct = (JL5ParsedClassType)ct;
            List<EnumInstance> enumConsts = pct.enumConstants();
            boolean allAnonNull = true;
            for (EnumInstance ei : enumConsts) {
                if (ei.anonType() == null) continue;
                allAnonNull = false;
                break;
            }
            if (allAnonNull) {
                super.checkClassConformance(ct, context);
            } else {
                for (MethodInstance mi : ct.methods()) {
                    if (!mi.flags().isAbstract()) continue;
                    for (EnumInstance ei : enumConsts) {
                        if (ei.anonType() == null) {
                            throw new SemanticException("Enum constant decl: " + ei.name() + " must declare an anonymous subclass of: " + ct + " and implement the abstract method: " + mi, ei.position());
                        }
                        boolean implFound = false;
                        for (MethodInstance mj : ei.anonType().methods()) {
                            if (!this.canOverride(mj, mi, context)) continue;
                            implFound = true;
                        }
                        if (implFound) continue;
                        throw new SemanticException("Enum constant decl anonymous subclass must implement method: " + mi, ei.position());
                    }
                }
                List superInterfaces = this.abstractSuperInterfaces((Type)ct);
                Iterator it = superInterfaces.iterator();
                while (it.hasNext()) {
                    StructType rt;
                    Type t = (Type)it.next();
                    if (!(t instanceof StructType) || this.typeEquals((Type)(rt = (StructType)it), (Type)ct, context)) continue;
                    for (MethodInstance mi : rt.methods()) {
                        if (!mi.flags().isAbstract()) continue;
                        boolean implFound = false;
                        for (MethodInstance mj : ct.methods()) {
                            if (!this.canOverride(mj, mi, context)) continue;
                            implFound = true;
                            break;
                        }
                        Iterator kt = ct.superClass().toClass().methods().iterator();
                        while (!implFound && kt.hasNext()) {
                            MethodInstance mj;
                            mj = (MethodInstance)kt.next();
                            if (!this.canOverride(mj, mi, context)) continue;
                            implFound = true;
                            break;
                        }
                        if (implFound) continue;
                        throw new SemanticException(ct.fullName() + " should be declared abstract: it does not define: " + mi.signature() + ", which is declared in " + rt.toClass().fullName(), ct.position());
                    }
                }
            }
        } else {
            super.checkClassConformance(ct, context);
        }
    }

    @Override
    public EnumInstance enumInstance(Position pos, Ref<? extends FieldDef> def) {
        return new EnumInstance_c(this, pos, def);
    }

    @Override
    public AnnotationElemInstance findAnnotation(Type container, AnnotationMatcher matcher) throws SemanticException {
        Set<AnnotationElemInstance> annotations = this.findAnnotations(container, matcher);
        Name name = matcher.name();
        if (annotations.size() == 0) {
            throw new NoMemberException(5, "Annotation \"" + name + "\" not found in type \"" + container + "\".");
        }
        Iterator i = annotations.iterator();
        AnnotationElemInstance ai = (AnnotationElemInstance)i.next();
        if (i.hasNext()) {
            AnnotationElemInstance ai2 = (AnnotationElemInstance)i.next();
            throw new SemanticException("Annotation \"" + name + "\" is ambiguous; it is defined in both " + ai.container() + " and " + ai2.container() + ".");
        }
        Context context = matcher.context();
        if (context != null && !this.isAccessible(ai, context)) {
            throw new SemanticException("Cannot access " + ai + ".");
        }
        return ai;
    }

    protected Set<AnnotationElemInstance> findAnnotations(Type container, AnnotationMatcher matcher) {
        AnnotationElemInstance fi;
        Name name = matcher.name();
        Context context = matcher.context();
        this.assert_((TypeObject)container);
        if (container == null) {
            throw new InternalCompilerError("Cannot access annotation \"" + name + "\" within a null container type.");
        }
        if (container instanceof JL5ParsedClassType && (fi = ((JL5ParsedClassType)container).annotationElemNamed(name)) != null) {
            try {
                fi = matcher.instantiate(fi);
                if (fi != null) {
                    return Collections.singleton(fi);
                }
            }
            catch (SemanticException e) {
                // empty catch block
            }
            return Collections.EMPTY_SET;
        }
        HashSet<AnnotationElemInstance> annot = new HashSet<AnnotationElemInstance>();
        if (container instanceof ObjectType) {
            ObjectType ot = (ObjectType)container;
            if (ot.superClass() != null && ot.superClass() instanceof StructType) {
                Set<AnnotationElemInstance> superFields = this.findAnnotations((Type)((StructType)ot.superClass()), matcher);
                annot.addAll(superFields);
            }
            for (Type it : ot.interfaces()) {
                if (!(it instanceof StructType)) continue;
                Set<AnnotationElemInstance> superFields = this.findAnnotations((Type)((StructType)it), matcher);
                annot.addAll(superFields);
            }
        }
        return annot;
    }

    @Override
    public AnnotationElemInstance annotationElemInstance(Position pos, ClassType ct, Flags f, Type type, Id name, boolean hasDefault) {
        this.assert_((TypeObject)ct);
        this.assert_((TypeObject)type);
        return new AnnotationElemInstance_c(this, pos, ct, f, type, name.id(), hasDefault);
    }

    @Override
    public Context createContext() {
        return new JL5Context_c(this);
    }

    @Override
    public FieldInstance findFieldOrEnum(Type container, TypeSystem_c.FieldMatcher matcher) throws SemanticException {
        FieldInstance fi = null;
        try {
            fi = super.findField(container, matcher);
        }
        catch (NoMemberException e) {
            EnumMatcher enumMatcher = this.EnumMatcher(container, matcher.name(), matcher.context());
            fi = this.findEnumConstant(container, enumMatcher);
        }
        return fi;
    }

    @Override
    public EnumInstance findEnumConstant(Type container, EnumMatcher matcher) throws SemanticException {
        Context context = matcher.context();
        Set<EnumInstance> enumConstants = this.findEnumConstants(container, matcher);
        if (enumConstants.size() == 0) {
            throw new NoMemberException(4, "Enum Constant " + matcher.signature() + " not found in type \"" + container + "\".");
        }
        Iterator i = enumConstants.iterator();
        EnumInstance fi = (EnumInstance)i.next();
        if (i.hasNext()) {
            EnumInstance fi2 = (EnumInstance)i.next();
            throw new SemanticException("Enum Constant " + matcher.name() + " is ambiguous; it is defined in both " + fi.container() + " and " + fi2.container() + ".");
        }
        if (context != null && !this.isAccessible((MemberInstance)fi, context)) {
            throw new SemanticException("Cannot access " + fi + ".");
        }
        return fi;
    }

    protected Set<EnumInstance> findEnumConstants(Type container, EnumMatcher matcher) {
        EnumInstance fi;
        Name name = matcher.name();
        Context context = matcher.context();
        this.assert_((TypeObject)container);
        if (container == null) {
            throw new InternalCompilerError("Cannot access field \"" + name + "\" within a null container type.");
        }
        if (container instanceof JL5ParsedClassType && (fi = ((JL5ParsedClassType)container).enumConstantNamed(name)) != null) {
            try {
                fi = matcher.instantiate(fi);
                if (fi != null) {
                    return Collections.singleton(fi);
                }
            }
            catch (SemanticException e) {
                // empty catch block
            }
            return Collections.EMPTY_SET;
        }
        HashSet<EnumInstance> enums = new HashSet<EnumInstance>();
        if (container instanceof ObjectType) {
            ObjectType ot = (ObjectType)container;
            if (ot.superClass() != null && ot.superClass() instanceof StructType) {
                Set<EnumInstance> superFields = this.findEnumConstants((Type)((StructType)ot.superClass()), matcher);
                enums.addAll(superFields);
            }
            for (Type it : ot.interfaces()) {
                if (!(it instanceof StructType)) continue;
                Set<EnumInstance> superFields = this.findEnumConstants((Type)((StructType)it), matcher);
                enums.addAll(superFields);
            }
        }
        return enums;
    }

    @Override
    public TypeVariable typeVariable(Position pos, String name, List bounds) {
        return this.typeVariable(pos, Name.make((String)name), (Ref<? extends ClassDef>)Types.ref((Object)new JL5ClassDef_c(this)), bounds);
    }

    @Override
    public TypeVariable typeVariable(Position pos, Name name, Ref<? extends ClassDef> def, List bounds) {
        return new TypeVariable_c(this, pos, name, def, bounds);
    }

    @Override
    public IntersectionType intersectionType(List<Ref<? extends Type>> bounds) {
        return new IntersectionType_c(this, bounds);
    }

    @Override
    public ParameterizedType parameterizedType(JL5ParsedClassType ct) {
        return new ParameterizedType_c(ct);
    }

    public ClassType rawify(ClassDef def) {
        JL5ParsedClassType pt = (JL5ParsedClassType)def.asType();
        assert (!(pt instanceof ParameterizedType));
        if (pt.isGeneric()) {
            return this.rawType(pt);
        }
        return pt;
    }

    @Override
    public RawType rawType(JL5ParsedClassType ct) {
        if (ct instanceof RawType) {
            return (RawType)ct;
        }
        return new RawType_c(ct);
    }

    @Override
    public boolean isValidAnnotationValueType(Type t) {
        if (t.isPrimitive()) {
            return true;
        }
        if (t instanceof JL5ParsedClassType) {
            if (JL5Flags.isEnumModifier(((JL5ParsedClassType)t).flags())) {
                return true;
            }
            if (JL5Flags.isAnnotationModifier(((JL5ParsedClassType)t).flags())) {
                return true;
            }
            if (((JL5ParsedClassType)t).fullName().equals((Object)QName.make((String)"java.lang.String"))) {
                return true;
            }
            if (((JL5ParsedClassType)t).fullName().equals((Object)QName.make((String)"java.lang.Class"))) {
                return true;
            }
        }
        if (t.isArray()) {
            return this.isValidAnnotationValueType(((ArrayType)t).base());
        }
        return false;
    }

    @Override
    public boolean isBaseCastValid(Type fromType, Type toType, Context context) {
        this.assert_((TypeObject)fromType);
        this.assert_((TypeObject)toType);
        if (toType.isArray()) {
            Type base = ((ArrayType)toType).base();
            this.assert_((TypeObject)base);
            return this.env(context).isImplicitCastValid(fromType, base);
        }
        return false;
    }

    @Override
    public boolean numericConversionBaseValid(Type t, Object value, Context context) {
        this.assert_((TypeObject)t);
        if (t.isArray()) {
            return this.env(context).numericConversionValid(((ArrayType)t).base(), value);
        }
        return false;
    }

    @Override
    public void checkDuplicateAnnotations(List annotations) throws SemanticException {
        ArrayList l = new ArrayList(annotations);
        for (int i = 0; i < l.size(); ++i) {
            AnnotationElem ai = (AnnotationElem)l.get(i);
            for (int j = i + 1; j < l.size(); ++j) {
                AnnotationElem aj = (AnnotationElem)l.get(j);
                if (ai.typeName().type() != aj.typeName().type()) continue;
                throw new SemanticException("Duplicate annotation use: " + aj.typeName(), aj.position());
            }
        }
    }

    @Override
    public void checkValueConstant(Expr value) throws SemanticException {
        if (value instanceof ArrayInit) {
            for (Expr next : ((ArrayInit)value).elements()) {
                if (next.isConstant() && next != null && !(next instanceof NullLit) || next instanceof ClassLit) continue;
                throw new SemanticException("Annotation attribute value must be constant", value.position());
            }
        } else if (!(value.isConstant() && value != null && !(value instanceof NullLit) || value instanceof ClassLit)) {
            throw new SemanticException("Annotation attribute value must be constant", value.position());
        }
    }

    @Override
    public Flags flagsForBits(int bits) {
        Flags f = super.flagsForBits(bits);
        if ((bits & 0x2000) != 0) {
            f = JL5Flags.setAnnotationModifier(f);
        }
        if ((bits & 0x4000) != 0) {
            f = JL5Flags.setEnumModifier(f);
        }
        return f;
    }

    @Override
    public void checkAnnotationApplicability(AnnotationElem annotation, Node n) throws SemanticException {
        List applAnnots = ((JL5ParsedClassType)annotation.typeName().type()).annotations();
        if (applAnnots != null) {
            for (AnnotationElem next : applAnnots) {
                if (!((ClassType)next.typeName().type()).fullName().equals((Object)QName.make((String)"java.lang.annotation.Target")) || !(next instanceof NormalAnnotationElem)) continue;
                for (ElementValuePair elemVal : ((NormalAnnotationElem)next).elements()) {
                    if (elemVal.value() instanceof JL5Field) {
                        Name check = ((JL5Field)elemVal.value()).name().id();
                        this.appCheckValue(check, n);
                        continue;
                    }
                    if (!(elemVal.value() instanceof ArrayInit)) continue;
                    ArrayInit val = (ArrayInit)elemVal.value();
                    if (val.elements().isEmpty()) {
                        throw new SemanticException("Annotation type not applicable to this kind of declaration", n.position());
                    }
                    for (Object nextVal : val.elements()) {
                        if (!(nextVal instanceof JL5Field)) continue;
                        Name valCheck = ((JL5Field)nextVal).name().id();
                        this.appCheckValue(valCheck, n);
                    }
                }
            }
        }
        if (((ClassType)annotation.typeName().type()).fullName().equals((Object)QName.make((String)"java.lang.Override"))) {
            this.appCheckOverride(n);
        }
    }

    private void appCheckValue(Name val, Node n) throws SemanticException {
        if (val.equals((Object)Name.make((String)"ANNOTATION_TYPE")) ? !(n instanceof ClassDecl) || !JL5Flags.isAnnotationModifier(((ClassDecl)n).flags().flags()) : (val.equals((Object)Name.make((String)"CONSTRUCTOR")) ? !(n instanceof ConstructorDecl) : (val.equals((Object)Name.make((String)"FIELD")) ? !(n instanceof FieldDecl) : (val.equals((Object)Name.make((String)"LOCAL_VARIABLE")) ? !(n instanceof LocalDecl) : (val.equals((Object)Name.make((String)"METHOD")) ? !(n instanceof MethodDecl) : !val.equals((Object)Name.make((String)"PACKAGE")) && (val.equals((Object)Name.make((String)"PARAMETER")) ? !(n instanceof Formal) : val.equals((Object)Name.make((String)"TYPE")) && !(n instanceof ClassDecl))))))) {
            throw new SemanticException("Annotation type not applicable to this kind of declaration", n.position());
        }
    }

    private void appCheckOverride(Node n) throws SemanticException {
        MethodDecl md = (MethodDecl)n;
        MethodDef def = md.methodDef();
        MethodInstance mi = def.asInstance();
        ClassType container = (ClassType)mi.container();
        ClassType sc = (ClassType)container.superClass();
        try {
            this.findMethod((Type)sc, new JL5MethodMatcher((Type)sc, mi.name(), mi.formalTypes(), null, null));
        }
        catch (NoMemberException e) {
            throw new SemanticException("method does not override a method from its superclass", md.position());
        }
    }

    @Override
    public boolean equivalent(Type fromType, Type toType) {
        Context context = this.emptyContext();
        return ((JL5TypeEnv_c)this.env(context)).equivalent(fromType, toType);
    }

    @Override
    public AnyType anyType() {
        return new AnyType_c(this);
    }

    @Override
    public AnySuperType anySuperType(Ref<ClassType> t) {
        return new AnySuperType_c((TypeSystem)this, t);
    }

    @Override
    public AnySubType anySubType(Ref<ClassType> t) {
        return new AnySubType_c((TypeSystem)this, t);
    }

    public ImportTable importTable(Ref<? extends Package> pkg) {
        this.assert_(pkg);
        return new JL5ImportTable(this, pkg);
    }

    public ImportTable importTable(String sourceName, Ref<? extends Package> pkg) {
        this.assert_(pkg);
        return new JL5ImportTable(this, pkg, sourceName);
    }

    @Override
    public Type arrayOf(Position position, Ref<? extends Type> typeRef, boolean varargs) {
        return this.createArrayType(position, typeRef, varargs);
    }

    @Override
    public ArrayType createArrayType(Position pos, Ref<? extends Type> type, boolean varargs) {
        if (varargs) {
            ArrayType t = (ArrayType)this.varargsArrayTypeCache.get(type);
            if (t == null) {
                t = this.createArrayTypeImpl(pos, type, varargs);
                this.varargsArrayTypeCache.put(type, (Type)t);
            }
            return t;
        }
        return super.arrayType(pos, type);
    }

    protected ArrayType createArrayTypeImpl(Position pos, Ref<? extends Type> type, boolean varargs) {
        return new JL5ArrayType_c(this, pos, type, varargs);
    }

    protected ArrayType createArrayType(Position pos, Ref<? extends Type> type) {
        return this.createArrayTypeImpl(pos, type, false);
    }

    @Override
    public boolean isEquivalent(TypeObject arg1, TypeObject arg2) {
        if (arg1 instanceof ArrayType && arg2 instanceof ArrayType) {
            return this.isEquivalent((TypeObject)((ArrayType)arg1).base(), (TypeObject)((ArrayType)arg2).base());
        }
        if (arg1 instanceof TypeVariable) {
            return ((TypeVariable)arg1).isEquivalent(arg2);
        }
        if (arg2 instanceof TypeVariable) {
            return ((TypeVariable)arg2).isEquivalent(arg1);
        }
        return this.equals(arg1, arg2);
    }

    public MethodInstance findMethod(Type container, TypeSystem_c.MethodMatcher matcher) throws SemanticException {
        this.assert_((TypeObject)container);
        Name name = matcher.name();
        List<JL5MethodInstance> acceptable = new ArrayList<JL5MethodInstance>(this.findMethodsNamed(container, matcher));
        LinkedList unacceptables = new LinkedList();
        acceptable = this.filterPotentiallyApplicable(acceptable, unacceptables, (JL5ProcedureMatcher)matcher);
        acceptable = this.identifyApplicableProcedures(acceptable, (JL5ProcedureMatcher)matcher);
        for (MethodInstance mi : unacceptables) {
            acceptable.removeAll(mi.overrides(matcher.context()));
            if (acceptable.size() != 0) continue;
            throw new NoMemberException(1, "Method " + mi.signature() + " in " + container + " is inaccessible.");
        }
        if (acceptable.size() > 0) {
            MethodInstance mi;
            Collection maximal = this.findMostSpecificProcedures(acceptable, (Matcher)matcher, matcher.context());
            if (maximal.size() > 1) {
                StringBuffer sb = new StringBuffer();
                Iterator i = maximal.iterator();
                while (i.hasNext()) {
                    MethodInstance ma = (MethodInstance)i.next();
                    sb.append(ma.container());
                    sb.append(".");
                    sb.append(ma.signature());
                    if (!i.hasNext()) continue;
                    if (maximal.size() == 2) {
                        sb.append(" and ");
                        continue;
                    }
                    sb.append(", ");
                }
                throw new SemanticException("Reference to " + matcher.name() + " is ambiguous, multiple methods match: " + sb.toString());
            }
            mi = (JL5MethodInstance)maximal.iterator().next();
            return mi;
        }
        throw new SemanticException("No valid method call found for " + name + "(" + JL5TypeSystem_c.listToString(((JL5MethodMatcher)matcher).getArgTypes()) + ") in " + container + ".");
    }

    public TypeSystem_c.MethodMatcher MethodMatcher(Type container, Name name, List<Type> argTypes, Context context) {
        return new JL5MethodMatcher(container, name, argTypes, null, context);
    }

    private boolean checkBoxingNeeded(JL5ProcedureInstance pi, List<Type> paramTypes) {
        int numFormals = pi.formalTypes().size();
        for (int i = 0; i < numFormals - 1; ++i) {
            Type formal = pi.formalTypes().get(i);
            Type actual = paramTypes.get(i);
            if (!(formal.isPrimitive() ^ actual.isPrimitive())) continue;
            return true;
        }
        if (pi.isVariableArrity()) {
            Type lastParams = ((JL5ArrayType)pi.formalTypes().get(numFormals - 1)).base();
            for (int i = numFormals - 1; i < paramTypes.size() - 1; ++i) {
                if (!(lastParams.isPrimitive() ^ paramTypes.get(i).isPrimitive())) continue;
                return true;
            }
        } else if (numFormals > 0) {
            Type formal = pi.formalTypes().get(numFormals - 1);
            Type actual = paramTypes.get(numFormals - 1);
            if (formal.isPrimitive() ^ actual.isPrimitive()) {
                return true;
            }
        }
        return false;
    }

    protected <T extends JL5ProcedureInstance> List<T> filterPotentiallyApplicable(List<T> allProcedures, List<T> unacceptables, JL5ProcedureMatcher matcher) {
        ArrayList<JL5ProcedureInstance> potApplicable = new ArrayList<JL5ProcedureInstance>();
        int numActuals = matcher.getArgTypes().size();
        List<Type> explicitTypeArgs = matcher.getExplicitTypeArgs();
        for (JL5ProcedureInstance pi : allProcedures) {
            int numFormals = pi.formalTypes().size();
            if (pi.isVariableArrity() ? numActuals < numFormals - 1 : numFormals != numActuals) continue;
            if (explicitTypeArgs != null && pi.isGeneric() && pi.typeVariables().size() != explicitTypeArgs.size()) continue;
            if (!this.isAccessible((MemberInstance)pi, matcher.context())) {
                unacceptables.add(pi);
                continue;
            }
            potApplicable.add(pi);
        }
        return potApplicable;
    }

    protected <T extends JL5ProcedureInstance> List<T> identifyApplicableProcedures(List<T> potApplicable, JL5ProcedureMatcher matcher) {
        ArrayList phase1methods = new ArrayList();
        ArrayList phase2methods = new ArrayList();
        ArrayList phase3methods = new ArrayList();
        List<Type> argTypes = matcher.getArgTypes();
        List<Type> explicitTypeArgs = matcher.getExplicitTypeArgs();
        for (JL5ProcedureInstance pi : potApplicable) {
            JL5ProcedureInstance actualCalledProc;
            List<Type> formals = pi.formalTypes();
            List<Type> typeArgs = null;
            boolean boxingNeeded = this.checkBoxingNeeded(pi, argTypes);
            ArrayList<Type> capParamTypes = new ArrayList<Type>(argTypes);
            for (int i = 0; i < capParamTypes.size(); ++i) {
                if (!(capParamTypes.get(i) instanceof ParameterizedType_c)) continue;
                ParameterizedType_c pt = (ParameterizedType_c)capParamTypes.get(i);
                capParamTypes.set(i, pt.capture());
            }
            argTypes = capParamTypes;
            if (pi.isGeneric()) {
                typeArgs = explicitTypeArgs != null ? explicitTypeArgs : this.inferenceSolver(pi, argTypes).solve();
                boolean badTypeArgs = false;
                actualCalledProc = pi.typeArguments(typeArgs);
                for (int i = 0; i < actualCalledProc.typeVariables().size(); ++i) {
                    IntersectionType tvBound = ((MemberInstance)actualCalledProc).container() instanceof GenericTypeRef ? this.getSubstitution((GenericTypeRef)((MemberInstance)actualCalledProc).container(), actualCalledProc.typeVariables().get(i).upperBound()) : actualCalledProc.typeVariables().get(i).upperBound();
                    if (this.isSubtype(typeArgs.get(i), tvBound, matcher.context())) continue;
                    badTypeArgs = true;
                    break;
                }
                if (badTypeArgs) {
                    continue;
                }
            } else {
                actualCalledProc = pi;
            }
            if (!this.callValid(actualCalledProc, matcher.container(), argTypes, matcher.context())) continue;
            if (!actualCalledProc.isVariableArrity() && !boxingNeeded) {
                phase1methods.add(actualCalledProc);
                continue;
            }
            if (!actualCalledProc.isVariableArrity()) {
                phase2methods.add(actualCalledProc);
                continue;
            }
            phase3methods.add(actualCalledProc);
        }
        if (phase1methods.size() > 0) {
            return phase1methods;
        }
        if (phase2methods.size() > 0) {
            return phase2methods;
        }
        if (phase3methods.size() > 0) {
            return phase3methods;
        }
        return Collections.emptyList();
    }

    protected Set<JL5MethodInstance> findMethodsNamed(Type container, TypeSystem_c.MethodMatcher matcher) {
        this.assert_((TypeObject)container);
        HashSet<JL5MethodInstance> result = new HashSet<JL5MethodInstance>();
        HashSet<StructType> visitedTypes = new HashSet<StructType>();
        LinkedList<Type> typeQueue = new LinkedList<Type>();
        typeQueue.addLast(container);
        Name mthName = matcher.name();
        while (!typeQueue.isEmpty()) {
            Type t = (Type)typeQueue.removeFirst();
            if (t instanceof IntersectionType) {
                t = ((IntersectionType)t).getSyntheticClassType();
            }
            if (t instanceof StructType) {
                StructType type = (StructType)t;
                if (visitedTypes.contains(type)) continue;
                visitedTypes.add(type);
                for (JL5MethodInstance mi : type.methodsNamed(mthName)) {
                    if (!mi.name().equals((Object)mthName)) continue;
                    result.add(mi);
                }
            }
            if (!(t instanceof ObjectType)) continue;
            ObjectType ot = (ObjectType)t;
            if (ot.superClass() != null) {
                typeQueue.addLast(ot.superClass());
            }
            typeQueue.addAll(ot.interfaces());
        }
        return result;
    }

    public List<ObjectType> allAncestorsOf(Type t) {
        ObjectType rt = (ObjectType)t;
        HashSet<ObjectType> ancestors = new HashSet<ObjectType>();
        ancestors.add(rt);
        ObjectType superT = (ObjectType)rt.superClass();
        if (superT != null) {
            ancestors.add(superT);
            ancestors.addAll(this.allAncestorsOf((Type)superT));
        }
        for (ObjectType inter : rt.interfaces()) {
            ancestors.add(inter);
            ancestors.addAll(this.allAncestorsOf((Type)inter));
        }
        return new ArrayList<ObjectType>(ancestors);
    }

    @Override
    public ParameterizedType findGenericSupertype(ObjectType base, ObjectType actual_pt) {
        Collection supers = this.allAncestorsOf((Type)actual_pt);
        for (ObjectType t : supers) {
            ParameterizedType pt;
            if (!(t instanceof ParameterizedType) || !this.typeEquals((Type)(pt = (ParameterizedType)t).baseType(), (Type)base, this.emptyContext())) continue;
            return pt;
        }
        return null;
    }

    @Override
    public void sortAnnotations(List annotations, List runtimeAnnotations, List classAnnotations, List sourceAnnotations) {
        for (AnnotationElem annot : annotations) {
            boolean sorted = false;
            List appliedAnnots = ((JL5ParsedClassType)annot.typeName().type()).annotations();
            if (appliedAnnots != null) {
                for (AnnotationElem next : appliedAnnots) {
                    if (!((ClassType)next.typeName().type()).fullName().equals((Object)QName.make((String)"java.lang.annotation.Retention"))) continue;
                    for (ElementValuePair elem : ((NormalAnnotationElem)next).elements()) {
                        if (!elem.name().id().equals((Object)Name.make((String)"value")) || !(elem.value() instanceof JL5Field)) continue;
                        Name val = ((JL5Field)elem.value()).name().id();
                        if (val.equals((Object)Name.make((String)"RUNTIME"))) {
                            runtimeAnnotations.add(annot);
                            sorted = true;
                            continue;
                        }
                        if (val.equals((Object)Name.make((String)"SOURCE"))) {
                            sourceAnnotations.add(annot);
                            sorted = true;
                            continue;
                        }
                        classAnnotations.add(annot);
                        sorted = true;
                    }
                }
            }
            if (sorted) continue;
            classAnnotations.add(annot);
        }
    }

    @Override
    public boolean needsUnboxing(Type to, Type from) {
        return to.isPrimitive() && from.isClass();
    }

    @Override
    public boolean needsBoxing(Type to, Type from) {
        return to.isClass() && from.isPrimitive();
    }

    @Override
    public Type getSubstitution(GenericTypeRef orig, Type curr) {
        orig = orig.capture();
        if (curr == null || !orig.isGeneric()) {
            return curr;
        }
        if (orig instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)orig;
            return this.applySubstitution(curr, pt.typeVariables(), pt.typeArguments());
        }
        if (orig instanceof RawType) {
            RawType rt = (RawType)orig;
            LinkedList<Type> newTypeArgs = new LinkedList<Type>();
            List<TypeVariable> tyvars = rt.typeVariables();
            for (TypeVariable it : tyvars) {
                newTypeArgs.add(it.erasureType());
            }
            return this.applySubstitution(curr, tyvars, newTypeArgs);
        }
        return curr;
    }

    public static String listToString(List l) {
        StringBuffer sb = new StringBuffer();
        Iterator i = l.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            sb.append(o.toString());
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public <T extends Type> List<T> applySubstitution(List<T> listToSub, List<TypeVariable> orig, List<Type> typeArgs) {
        ArrayList<Type> result = new ArrayList<Type>();
        for (Type toBeSubed : listToSub) {
            result.add(this.applySubstitution(toBeSubed, orig, typeArgs));
        }
        return result;
    }

    @Override
    public Type applySubstitution(Type toBeSubed, List<TypeVariable> orig, List<Type> sub) {
        if (toBeSubed instanceof JL5ParsedClassType && ((JL5ParsedClassType)toBeSubed).isGeneric() && !(toBeSubed instanceof ParameterizedType)) {
            ParameterizedType paramType = this.parameterizedType((JL5ParsedClassType)toBeSubed);
            List<Ref<? extends Type>> typeRefArgs = ((JL5ClassDef)paramType.def()).typeVariables();
            ArrayList<Type> typeArgs = new ArrayList<Type>(typeRefArgs.size());
            for (Ref<? extends Type> refType : typeRefArgs) {
                typeArgs.add((Type)refType.get());
            }
            paramType.typeArguments(typeArgs);
            toBeSubed = paramType;
        }
        if (toBeSubed instanceof TypeVariable) {
            for (int i = 0; i < orig.size(); ++i) {
                if (!this.typeEquals(orig.get(i), toBeSubed, this.emptyContext())) continue;
                return sub.get(i);
            }
        } else {
            if (toBeSubed instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)toBeSubed;
                ArrayList<Type> newArgs = new ArrayList<Type>();
                for (Type t : pt.typeArguments()) {
                    newArgs.add(this.applySubstitution(t, orig, sub));
                }
                ParameterizedType newpt = this.parameterizedType(pt.baseType());
                newpt.typeArguments(newArgs);
                return newpt;
            }
            if (toBeSubed instanceof ArrayType) {
                ArrayType at = (ArrayType)toBeSubed;
                return this.arrayOf(at.position(), this.applySubstitution(at.base(), orig, sub));
            }
            if (toBeSubed instanceof Wildcard) {
                Wildcard wc = (Wildcard)toBeSubed;
                ClassType b = wc.bound();
                if (b != null) {
                    Wildcard newwc = (Wildcard)wc.copy();
                    newwc.bound((Ref<ClassType>)Types.ref((Object)((ClassType)this.applySubstitution((Type)b, orig, sub))));
                    return newwc;
                }
            } else {
                Object n;
                if (toBeSubed instanceof LubType) {
                    LubType lt = (LubType)toBeSubed;
                    n = this.lubType(this.applySubstitution(lt.lubElements(), orig, sub));
                    return n;
                }
                if (toBeSubed instanceof IntersectionType) {
                    IntersectionType it = (IntersectionType)toBeSubed;
                    n = this.intersectionType(this.toRefTypes(this.applySubstitution(it.boundsTypes(), orig, sub)));
                    return n;
                }
            }
        }
        return toBeSubed;
    }

    @Override
    public List<Ref<? extends Type>> toRefTypes(List<Type> types) {
        Transformation<Type, Ref<? extends Type>> trans = new Transformation<Type, Ref<? extends Type>>(){

            public Ref<? extends Type> transform(Type t) {
                return Types.ref((Object)t);
            }
        };
        return new TransformingList(types, (Transformation)trans);
    }

    public ClassType rawify(Type t) {
        if (t == null || t instanceof RawType) {
            return (RawType)t;
        }
        JL5ParsedClassType bt = (JL5ParsedClassType)t;
        if (t instanceof ParameterizedType) {
            bt = ((ParameterizedType)t).baseType();
        }
        if (bt.isNested()) {
            ClassDef outerRawDef = (ClassDef)this.rawify((Type)bt.outer()).def();
            ClassDef currentDefCopy = (ClassDef)bt.def().copy();
            currentDefCopy.outer(Types.ref((Object)outerRawDef));
            bt = (JL5ParsedClassType)currentDefCopy.asType();
        }
        return this.rawType(bt);
    }

    @Override
    @Deprecated
    public Type rawifyBareGenericType(Type t) {
        assert (t.isClass());
        JL5ParsedClassType pt = (JL5ParsedClassType)t;
        assert (!(pt instanceof ParameterizedType));
        if (t.isClass() && pt.isGeneric()) {
            return this.rawType(pt);
        }
        return t;
    }

    @Override
    @Deprecated
    public List rawifyBareGenericTypeList(List l) {
        ArrayList<Type> newL = new ArrayList<Type>();
        for (Object o : l) {
            newL.add(this.rawifyBareGenericType((Type)o));
        }
        return newL;
    }

    @Override
    public Type erasure(Type t) {
        if (t == null) {
            return null;
        }
        if (t instanceof JL5ParsedClassType) {
            JL5ParsedClassType pct = (JL5ParsedClassType)t;
            return this.rawify((Type)pct);
        }
        if (t instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)t;
            return this.erasure(tv.upperBound());
        }
        if (t instanceof IntersectionType) {
            IntersectionType it = (IntersectionType)t;
            return this.erasure(it.boundsTypes().get(0));
        }
        if (t instanceof ArrayType) {
            ArrayType at = (ArrayType)t;
            return this.arrayOf(null, this.erasure(at.base()));
        }
        return t;
    }

    @Override
    public Type capture(Type t) {
        if (t == null) {
            return null;
        }
        if (t instanceof GenericTypeRef) {
            GenericTypeRef gt = (GenericTypeRef)t;
            return gt.capture();
        }
        return t;
    }

    @Override
    public boolean checkContains(ParameterizedType child, ParameterizedType ancestor) {
        Context ctx = this.emptyContext();
        if (!this.typeEquals((Type)child.baseType(), (Type)ancestor.baseType(), ctx)) {
            return false;
        }
        Iterator<Type> itChild = child.typeArguments().iterator();
        Iterator<Type> itAnc = ancestor.typeArguments().iterator();
        while (itChild.hasNext()) {
            Type argChild = itChild.next();
            Type argAnc = itAnc.next();
            if (argAnc instanceof AnyType || !(argAnc instanceof AnySubType ? (argChild instanceof AnySubType ? !this.isSubtype((Type)((AnySubType)argChild).bound(), (Type)((AnySubType)argAnc).bound(), ctx) : !this.isSubtype(argChild, (Type)((AnySubType)argAnc).bound(), ctx)) : (argAnc instanceof AnySuperType ? (argChild instanceof AnySuperType ? !this.isSubtype((Type)((AnySuperType)argAnc).bound(), (Type)((AnySuperType)argChild).bound(), ctx) : !this.isSubtype((Type)((AnySuperType)argAnc).bound(), argChild, ctx)) : !this.typeEquals(argChild, argAnc, ctx)))) continue;
            return false;
        }
        return true;
    }

    public boolean descendsFrom(ClassDef child, ClassDef ancestor) {
        Context ctx = this.emptyContext();
        ClassType childT = child.asType();
        ClassType ancestorT = ancestor.asType();
        if (child instanceof RawType) {
            if (super.descendsFrom(child, ancestor)) {
                return true;
            }
            if (ancestor instanceof ParameterizedType || ancestor instanceof JL5ParsedClassType && !(ancestor instanceof RawType) && ((JL5ParsedClassType)ancestor).isGeneric()) {
                return this.isSubtype((Type)childT, (Type)this.rawify((Type)ancestorT), ctx);
            }
            return false;
        }
        if (child instanceof ParameterizedType) {
            if (super.descendsFrom(child, ancestor)) {
                return true;
            }
            if (ancestor instanceof RawType) {
                if (this.isSubtype((Type)this.rawify((Type)childT), (Type)ancestorT, ctx)) {
                    return true;
                }
            } else if (ancestor instanceof ParameterizedType && !this.typeEquals((Type)childT, (Type)ancestorT, ctx)) {
                return this.checkContains((ParameterizedType)((ParameterizedType)childT).capture(), (ParameterizedType)ancestorT);
            }
            return false;
        }
        if (ancestor instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)ancestorT;
            return super.descendsFrom(child, ancestor) || this.isSubtype((Type)childT, tv.lowerBound(), ctx);
        }
        return super.descendsFrom(child, ancestor);
    }

    @Override
    public ConstructorInstance findJL5Constructor(Type container, JL5ConstructorMatcher matcher) throws SemanticException {
        this.assert_((TypeObject)container);
        List acceptable = this.findAcceptableConstructors(container, matcher);
        LinkedList unacceptables = new LinkedList();
        acceptable = this.filterPotentiallyApplicable(acceptable, unacceptables, matcher);
        acceptable = this.identifyApplicableProcedures(acceptable, matcher);
        Collection maximal = this.findMostSpecificProcedures(acceptable, (Matcher)matcher, matcher.context());
        if (maximal.size() > 1) {
            throw new NoMemberException(2, "Reference to " + container + " is ambiguous, multiple " + "constructors match: " + maximal);
        }
        ConstructorInstance ci = (ConstructorInstance)maximal.iterator().next();
        return ci;
    }

    @Override
    public boolean checkIntersectionBounds(List<Type> bounds, boolean quiet) throws SemanticException {
        Context ctx = this.emptyContext();
        List<Type> concreteBounds = this.concreteBounds(bounds);
        if (concreteBounds.size() == 0) {
            if (!quiet) {
                throw new SemanticException("Invalid bounds in intersection type.");
            }
            return false;
        }
        for (int i = 0; i < concreteBounds.size(); ++i) {
            for (int j = i + 1; j < concreteBounds.size(); ++j) {
                Type t1 = concreteBounds.get(i);
                Type t2 = concreteBounds.get(j);
                if (!t1.isClass() || !t2.isClass()) {
                    return true;
                }
                if (!(t1.toClass().flags().isInterface() || t2.toClass().flags().isInterface() || this.isSubtype(t1, t2, ctx) || this.isSubtype(t2, t1, ctx))) {
                    if (!quiet) {
                        throw new SemanticException("Error in intersection type. Types " + t1 + " and " + t2 + " are not in subtype relation.");
                    }
                    return false;
                }
                if (!t1.toClass().flags().isInterface() || !t2.toClass().flags().isInterface() || !(t1 instanceof GenericTypeRef) || !(t2 instanceof GenericTypeRef)) continue;
                GenericTypeRef j5t1 = (GenericTypeRef)t1;
                GenericTypeRef j5t2 = (GenericTypeRef)t2;
                if (!j5t1.isGeneric() || !j5t2.isGeneric() || !this.typeEquals((Type)j5t1.baseType(), (Type)j5t2.baseType(), ctx) || this.typeEquals(j5t1, j5t2, ctx)) continue;
                if (!quiet) {
                    throw new SemanticException("Error in intersection type. Interfaces " + j5t1 + " and " + j5t2 + "are instantinations of the same generic interface but with different type arguments");
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public List<Type> concreteBounds(List<Type> bounds) {
        HashSet<Type> included = new HashSet<Type>();
        HashSet<Type> visited = new HashSet<Type>();
        ArrayList<Type> queue = new ArrayList<Type>(bounds);
        while (!queue.isEmpty()) {
            Type t = (Type)queue.remove(0);
            if (visited.contains(t)) continue;
            visited.add(t);
            if (t instanceof TypeVariable) {
                TypeVariable tv = (TypeVariable)t;
                queue.addAll(tv.upperBound().boundsTypes());
                continue;
            }
            if (t instanceof IntersectionType) {
                IntersectionType it = (IntersectionType)t;
                queue.addAll(it.boundsTypes());
                continue;
            }
            included.add(t);
        }
        return new ArrayList<Type>(included);
    }

    @Override
    public void checkTVForwardReference(List<TypeVariable> list) throws SemanticException {
        for (int i = 0; i < list.size(); ++i) {
            TypeVariable tv = list.get(i);
            for (Type b : tv.bounds()) {
                TypeVariable other_tv;
                if (!(b instanceof TypeVariable) || list.indexOf(other_tv = (TypeVariable)b) < i) continue;
                throw new SemanticException("Illegal forward reference.", tv.position());
            }
        }
    }

    @Override
    public InferenceSolver inferenceSolver(JL5ProcedureInstance pi, List<Type> actuals) {
        return new InferenceSolver_c(pi, actuals, this);
    }

    @Override
    public LubType lubType(List<Type> lst) {
        return new LubType_c(this, lst);
    }

    @Override
    public LubType lubType(Type ... a) {
        ArrayList<Type> l = new ArrayList<Type>();
        for (Type t : a) {
            l.add(t);
        }
        return this.lubType(l);
    }

    public TypeEnv env(Context context) {
        return new JL5TypeEnv_c(context);
    }

    @Override
    public boolean typeVariableEquals(TypeVariable type1, TypeVariable type2, Context context) {
        IntersectionType bound1 = type1.upperBound();
        IntersectionType bound2 = type2.upperBound();
        TypeSystem ts = context.typeSystem();
        return ts.equals((TypeObject)bound1, (TypeObject)bound2);
    }

    @Override
    public TypeSystem_c.ConstructorMatcher JL5ConstructorMatcher(Type container, List<Type> argTypes, List<Type> explicitTypeArgs, Context context) {
        return new JL5ConstructorMatcher(container, argTypes, explicitTypeArgs, context);
    }

    @Override
    public TypeSystem_c.MethodMatcher JL5MethodMatcher(Type container, Name name, List<Type> argTypes, List<Type> explicitTypeArgs, Context context) {
        return new JL5MethodMatcher(container, name, argTypes, explicitTypeArgs, context);
    }

    @Override
    public EnumMatcher EnumMatcher(Type container, Name name, Context ctx) {
        return new EnumMatcher(container, name, ctx);
    }

    @Override
    public AnnotationMatcher AnnotationMatcher(Type container, Name name, Context ctx) {
        return new AnnotationMatcher(container, name, ctx);
    }

    @Override
    public boolean isTypeExtendsAnnotation(Type t) {
        if (t instanceof ClassType) {
            ClassType ct = (ClassType)t;
            return ((ClassType)ct.superClass()).fullName().equals((Object)QName.make((String)"java.lang.annotation.Annotation"));
        }
        return false;
    }

    public static class AnnotationMatcher
    implements Copy,
    Matcher<AnnotationElemInstance> {
        protected Type container;
        protected Name name;
        protected Context context;

        protected AnnotationMatcher(Type container, Name name, Context context) {
            this.container = container;
            this.name = name;
            this.context = context;
        }

        public Context context() {
            return this.context;
        }

        public AnnotationMatcher container(Type container) {
            AnnotationMatcher n = this.copy();
            n.container = container;
            return n;
        }

        public AnnotationMatcher copy() {
            try {
                return (AnnotationMatcher)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalCompilerError((Throwable)e);
            }
        }

        public String signature() {
            return this.name.toString();
        }

        public Name name() {
            return this.name;
        }

        public AnnotationElemInstance instantiate(AnnotationElemInstance mi) throws SemanticException {
            if (!mi.name().equals((Object)this.name)) {
                return null;
            }
            return mi;
        }

        public String toString() {
            return this.signature();
        }

        public Object key() {
            return null;
        }
    }

    public static class EnumMatcher
    extends TypeSystem_c.FieldMatcher {
        protected EnumMatcher(Type container, Name name, Context context) {
            super(container, name, context);
        }

        public EnumInstance instantiate(EnumInstance mi) throws SemanticException {
            return (EnumInstance)super.instantiate((FieldInstance)mi);
        }
    }

    public static class JL5ConstructorMatcher
    extends TypeSystem_c.ConstructorMatcher
    implements JL5ProcedureMatcher {
        protected List<Type> explicitTypeArgs;

        protected JL5ConstructorMatcher(Type receiverType, List<Type> argTypes, List<Type> explicitTypeArgs, Context context) {
            super(receiverType, argTypes, context);
            this.explicitTypeArgs = explicitTypeArgs;
        }

        public String signature() {
            return super.signature();
        }

        public ConstructorInstance instantiate(ConstructorInstance ci) throws SemanticException {
            return super.instantiate(ci);
        }

        @Override
        public List<Type> getArgTypes() {
            return this.argTypes;
        }

        @Override
        public List<Type> getExplicitTypeArgs() {
            return this.explicitTypeArgs;
        }

        @Override
        public Type container() {
            return this.container;
        }
    }

    public static class JL5MethodMatcher
    extends TypeSystem_c.MethodMatcher
    implements JL5ProcedureMatcher {
        protected List<Type> explicitTypeArgs;

        protected JL5MethodMatcher(Type container, Name name, List<Type> argTypes, List<Type> explicitTypeArgs, Context context) {
            super(container, name, argTypes, context);
            this.explicitTypeArgs = explicitTypeArgs;
        }

        public String signature() {
            return super.signature();
        }

        public MethodInstance instantiate(MethodInstance mi) throws SemanticException {
            return super.instantiate(mi);
        }

        public String argumentString() {
            return super.argumentString();
        }

        @Override
        public List<Type> getArgTypes() {
            return this.argTypes;
        }

        @Override
        public List<Type> getExplicitTypeArgs() {
            return this.explicitTypeArgs;
        }

        @Override
        public Type container() {
            return this.container;
        }
    }

    public static class TypeVariableEquals
    implements Predicate2<TypeVariable> {
        Context context;

        public TypeVariableEquals(Context context) {
            this.context = context;
        }

        public boolean isTrue(TypeVariable o, TypeVariable p) {
            JL5TypeSystem ts = (JL5TypeSystem)this.context.typeSystem();
            return ts.typeVariableEquals(o, p, this.context);
        }
    }
}

