/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types.inference;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import polyglot.ext.jl5.types.JL5ArrayType;
import polyglot.ext.jl5.types.JL5ProcedureInstance;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.types.inference.Constraint;
import polyglot.ext.jl5.types.inference.EqualConstraint;
import polyglot.ext.jl5.types.inference.InferenceSolver;
import polyglot.ext.jl5.types.inference.SubConversionConstraint;
import polyglot.ext.jl5.types.inference.SubTypeConstraint;
import polyglot.ext.jl5.types.inference.SuperTypeConstraint;
import polyglot.types.ClassType;
import polyglot.types.Type;

public class InferenceSolver_c
implements InferenceSolver {
    private final JL5TypeSystem ts;
    private final JL5ProcedureInstance pi;
    private final List<Type> actuals;
    private final List<Type> formals;
    private final List<TypeVariable> typeVariables;

    public InferenceSolver_c(JL5ProcedureInstance pi, List<Type> actuals, JL5TypeSystem ts) {
        this.pi = pi;
        this.typeVariables = pi.typeVariables();
        this.actuals = actuals;
        this.formals = pi.formalTypes();
        this.ts = ts;
    }

    @Override
    public boolean isTargetTypeVariable(Type t) {
        if (t instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)t;
            return this.typeVariables().contains(tv);
        }
        return false;
    }

    @Override
    public List<TypeVariable> typeVariables() {
        return this.typeVariables;
    }

    @Override
    public List<Type> solve() {
        List<Constraint> constraints = this.getInitialConstraints();
        ArrayList<EqualConstraint> equals = new ArrayList<EqualConstraint>();
        ArrayList<SubTypeConstraint> subs = new ArrayList<SubTypeConstraint>();
        ArrayList<SuperTypeConstraint> supers = new ArrayList<SuperTypeConstraint>();
        while (!constraints.isEmpty()) {
            Constraint head = constraints.remove(0);
            if (head.canSimplify()) {
                constraints.addAll(0, head.simplify());
                continue;
            }
            if (head instanceof EqualConstraint) {
                EqualConstraint eq = (EqualConstraint)head;
                equals.add(eq);
                continue;
            }
            if (head instanceof SubTypeConstraint) {
                SubTypeConstraint sub = (SubTypeConstraint)head;
                subs.add(sub);
                continue;
            }
            if (!(head instanceof SuperTypeConstraint)) continue;
            SuperTypeConstraint sup = (SuperTypeConstraint)head;
            supers.add(sup);
        }
        Comparator<Constraint> comp = new Comparator<Constraint>(){

            @Override
            public int compare(Constraint o1, Constraint o2) {
                return InferenceSolver_c.this.typeVariables().indexOf(o1) - InferenceSolver_c.this.typeVariables().indexOf(o2);
            }
        };
        Collections.sort(equals, comp);
        Collections.sort(subs, comp);
        Type[] solution = new Type[this.typeVariables().size()];
        for (EqualConstraint eq : equals) {
            int i = this.typeVariables().indexOf(eq.formal);
            if (solution[i] != null && !this.ts.typeEquals(eq.actual, solution[i], null)) {
                solution[i] = this.ts.Object();
                continue;
            }
            solution[i] = eq.actual;
        }
        for (int i = 0; i < solution.length; ++i) {
            if (solution[i] != null) continue;
            TypeVariable toSolve = this.typeVariables().get(i);
            HashSet<ClassType> uset = new HashSet<ClassType>();
            for (SubTypeConstraint c : subs) {
                if (!c.formal.typeEquals((Type)toSolve, null)) continue;
                uset.add((ClassType)c.actual);
            }
            ArrayList<Type> u = new ArrayList<Type>(uset);
            solution[i] = u.size() == 1 ? (Type)u.get(0) : (u.size() > 1 ? this.ts.lubType(u) : this.ts.Object());
        }
        ArrayList<Type> r = new ArrayList<Type>();
        Collections.addAll(r, solution);
        return r;
    }

    private List<Constraint> getInitialConstraints() {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        int numFormals = this.formals.size();
        for (int i = 0; i < numFormals - 1; ++i) {
            constraints.add(new SubConversionConstraint(this.actuals.get(i), this.formals.get(i), this));
        }
        if (numFormals > 0) {
            if (this.pi != null && this.pi.isVariableArrity()) {
                JL5ArrayType lastFormal = (JL5ArrayType)this.pi.formalTypes().get(numFormals - 1);
                for (int i = numFormals - 1; i < this.actuals.size() - 1; ++i) {
                    constraints.add(new SubConversionConstraint(this.actuals.get(i), lastFormal.base(), this));
                }
            }
            constraints.add(new SubConversionConstraint(this.actuals.get(numFormals - 1), this.formals.get(numFormals - 1), this));
        }
        return constraints;
    }
}

