/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types.inference;

import java.util.ArrayList;
import java.util.List;
import polyglot.ext.jl5.types.AnySubType;
import polyglot.ext.jl5.types.AnySuperType;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.ParameterizedType;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.types.Wildcard;
import polyglot.ext.jl5.types.inference.Constraint;
import polyglot.ext.jl5.types.inference.EqualConstraint;
import polyglot.ext.jl5.types.inference.InferenceSolver;
import polyglot.ext.jl5.types.inference.SubConversionConstraint;
import polyglot.ext.jl5.types.inference.SuperTypeConstraint;
import polyglot.types.ObjectType;
import polyglot.types.Type;

public class SuperConversionConstraint
extends Constraint {
    public SuperConversionConstraint(Type actual, Type formal, InferenceSolver solver) {
        super(actual, formal, solver);
    }

    @Override
    public List<Constraint> simplify() {
        ArrayList<Constraint> r;
        block12: {
            block13: {
                block14: {
                    block11: {
                        r = new ArrayList<Constraint>();
                        if (!this.solver().isTargetTypeVariable(this.formal)) break block11;
                        r.add(new SuperTypeConstraint(this.actual, this.formal, this.solver));
                        break block12;
                    }
                    if (!this.formal.isArray()) break block13;
                    if (!this.formal.isArray()) break block12;
                    if (!this.actual.isArray() || !this.actual.toArray().base().isReference()) break block14;
                    r.add(new SuperConversionConstraint(this.actual.toArray().base(), this.formal.toArray().base(), this.solver));
                    break block12;
                }
                if (!(this.actual instanceof TypeVariable)) break block12;
                TypeVariable actual_tv = (TypeVariable)this.actual;
                for (Type b : actual_tv.bounds()) {
                    if (!b.isArray() || !b.toArray().base().isReference()) continue;
                    r.add(new SuperConversionConstraint(b.toArray().base(), this.formal.toArray().base(), this.solver));
                }
                break block12;
            }
            if (this.formal instanceof ParameterizedType && this.actual instanceof ParameterizedType) {
                ParameterizedType formal_pt = (ParameterizedType)this.formal;
                ParameterizedType actual_pt = (ParameterizedType)this.actual;
                ParameterizedType f = null;
                if (!actual_pt.baseType().typeEquals((Type)formal_pt.baseType(), null)) {
                    f = ((JL5TypeSystem)formal_pt.typeSystem()).findGenericSupertype((ObjectType)actual_pt.baseType(), (ObjectType)formal_pt.baseType());
                    if (f != null) {
                        ((JL5TypeSystem)formal_pt.typeSystem()).applySubstitution(f, formal_pt.baseType().typeVariables(), formal_pt.typeArguments());
                    }
                } else {
                    f = formal_pt;
                }
                if (f != null) {
                    int n = formal_pt.typeArguments().size();
                    for (int i = 0; i < n; ++i) {
                        Type formal_targ = f.typeArguments().get(i);
                        Type actual_targ = actual_pt.typeArguments().get(i);
                        if (!(formal_targ instanceof Wildcard)) {
                            if (!(actual_targ instanceof Wildcard)) {
                                r.add(new EqualConstraint(actual_targ, formal_targ, this.solver));
                                continue;
                            }
                            Wildcard actual_targ_wc = (Wildcard)actual_targ;
                            if (actual_targ_wc instanceof AnySubType) {
                                r.add(new SuperConversionConstraint((Type)actual_targ_wc.bound(), formal_targ, this.solver));
                                continue;
                            }
                            if (!(actual_targ_wc instanceof AnySuperType)) continue;
                            r.add(new SubConversionConstraint((Type)actual_targ_wc.bound(), formal_targ, this.solver));
                            continue;
                        }
                        if (!(actual_targ instanceof Wildcard)) continue;
                        Wildcard formal_targ_wc = (Wildcard)formal_targ;
                        Wildcard actual_targ_wc = (Wildcard)actual_targ;
                        if (formal_targ_wc instanceof AnySubType && actual_targ_wc instanceof AnySubType) {
                            r.add(new SuperConversionConstraint((Type)actual_targ_wc.bound(), (Type)formal_targ_wc.bound(), this.solver));
                            continue;
                        }
                        if (!(formal_targ_wc instanceof AnySuperType) || !(actual_targ_wc instanceof AnySuperType)) continue;
                        r.add(new SubConversionConstraint((Type)actual_targ_wc.bound(), (Type)formal_targ_wc.bound(), this.solver));
                    }
                }
            }
        }
        return r;
    }

    @Override
    public boolean canSimplify() {
        return true;
    }

    public String toString() {
        return this.actual + " >> " + this.formal;
    }
}

