/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types.reflect;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import polyglot.ext.jl5.types.reflect.JL5Field;
import polyglot.ext.jl5.types.reflect.JL5Method;
import polyglot.ext.jl5.types.reflect.Signature;
import polyglot.frontend.ExtensionInfo;
import polyglot.types.reflect.Attribute;
import polyglot.types.reflect.ClassFile;
import polyglot.types.reflect.Field;
import polyglot.types.reflect.InnerClasses;
import polyglot.types.reflect.Method;

public class JL5ClassFile
extends ClassFile {
    protected Signature signature;

    public JL5ClassFile(File classFileSource, byte[] code, ExtensionInfo ext) {
        super(classFileSource, code, ext);
    }

    public void readAttributes(DataInputStream in) throws IOException {
        int numAttributes = in.readUnsignedShort();
        this.attrs = new Attribute[numAttributes];
        for (int i = 0; i < numAttributes; ++i) {
            int nameIndex = in.readUnsignedShort();
            int length = in.readInt();
            if ("InnerClasses".equals(this.constants[nameIndex].value())) {
                this.innerClasses = new InnerClasses(in, nameIndex, length);
                this.attrs[i] = this.innerClasses;
                continue;
            }
            if ("Signature".equals(this.constants[nameIndex].value())) {
                this.signature = new Signature(in, nameIndex, length, this);
                this.attrs[i] = this.signature;
                continue;
            }
            long n = in.skip(length);
            if (n == (long)length) continue;
            throw new EOFException();
        }
    }

    public Signature getSignature() {
        return this.signature;
    }

    public Field createField(DataInputStream in) throws IOException {
        JL5Field f = new JL5Field(in, this);
        f.initialize();
        return f;
    }

    public Method createMethod(DataInputStream in) throws IOException {
        JL5Method m = new JL5Method(in, this);
        m.initialize();
        return m;
    }
}

