/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.types.reflect;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import polyglot.ext.jl5.types.JL5ClassDef;
import polyglot.ext.jl5.types.JL5TypeSystem;
import polyglot.ext.jl5.types.TypeVariable;
import polyglot.ext.jl5.types.reflect.JL5ClassFileLazyClassInitializer;
import polyglot.types.ClassDef;
import polyglot.types.Ref;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.types.reflect.Attribute;
import polyglot.types.reflect.ClassFile;
import polyglot.types.reflect.ClassFileLazyClassInitializer;
import polyglot.util.Position;

public class Signature
extends Attribute {
    protected DataInputStream in;
    protected final int index;
    protected ClassFile cls;
    protected JL5TypeSystem ts;
    protected Position position;
    protected ClassSig classSignature;
    protected MethodSig methodSignature;
    protected FieldSig fieldSignature;
    protected List<Ref<TypeVariable>> typeVars;
    protected JL5ClassDef curClass;
    protected ClassFileLazyClassInitializer cllz;
    private final char LEFT_ANGLE = (char)60;
    private final char RIGHT_ANGLE = (char)62;
    private final char COLON = (char)58;
    private final char L = (char)76;
    private final char SEMI_COLON = (char)59;
    private final char SLASH = (char)47;
    private final char DOT = (char)46;
    private final char T = (char)84;
    private final char STAR = (char)42;
    private final char PLUS = (char)43;
    private final char MINUS = (char)45;
    private final char LEFT_SQUARE = (char)91;
    private final char LEFT_BRACE = (char)40;
    private final char RIGHT_BRACE = (char)41;
    private final char V = (char)86;
    private final char HAT = (char)94;
    private final char B = (char)66;
    private final char C = (char)67;
    private final char D = (char)68;
    private final char F = (char)70;
    private final char I = (char)73;
    private final char J = (char)74;
    private final char S = (char)83;
    private final char Z = (char)90;
    private boolean createTypeVars;

    Signature(DataInputStream in, int nameIndex, int length, ClassFile clazz) throws IOException {
        super(nameIndex, length);
        this.index = in.readUnsignedShort();
        this.cls = clazz;
    }

    public Result classSig(String value, int pos) {
        List typeFormals = Collections.EMPTY_LIST;
        char token = value.charAt(pos);
        Result fres = null;
        if (token == '<') {
            fres = this.formalTypeParamList(value, ++pos);
            pos = fres.pos();
            if (fres != null) {
                typeFormals = (List)fres.result();
            }
            this.typeVars = (List)fres.result();
        }
        Result sres = this.classTypeSig(value, pos);
        Ref superType = (Ref)sres.result();
        ArrayList<Ref<? extends Type>> superInterfaces = new ArrayList<Ref<? extends Type>>();
        pos = sres.pos();
        while (pos < value.length()) {
            Result ires = this.classTypeSig(value, pos);
            pos = ires.pos();
            superInterfaces.add((Ref<? extends Type>)((Ref)ires.result()));
        }
        return new Result(new ClassSig(typeFormals, (Ref<? extends Type>)superType, superInterfaces), pos);
    }

    public Result formalTypeParamList(String value, int pos) {
        Result fres;
        this.typeVars = null;
        int oldpos = pos;
        this.createTypeVars = true;
        ArrayList<Object> list = new ArrayList<Ref<TypeVariable>>();
        char token = value.charAt(pos);
        while (token != '>') {
            fres = this.formalTypeParam(value, pos);
            list.add((Ref<TypeVariable>)fres.result());
            pos = fres.pos();
            token = value.charAt(pos);
        }
        this.typeVars = list;
        pos = oldpos;
        this.createTypeVars = false;
        list = new ArrayList();
        token = value.charAt(pos);
        while (token != '>') {
            fres = this.formalTypeParam(value, pos);
            list.add((Ref<TypeVariable>)fres.result());
            pos = fres.pos();
            token = value.charAt(pos);
        }
        return new Result(list, ++pos);
    }

    public Result formalTypeParam(String value, int pos) {
        String id = "";
        char token = value.charAt(pos);
        while (token != ':') {
            id = id + token;
            token = value.charAt(++pos);
        }
        Result cres = this.classBound(value, pos);
        pos = cres.pos();
        Result ires = null;
        ArrayList<Type> bounds = new ArrayList<Type>();
        token = value.charAt(pos);
        while (token != '>' && value.charAt(pos) == ':') {
            ires = this.classBound(value, pos);
            pos = ires.pos();
            bounds.add((Type)ires.result());
        }
        if (this.createTypeVars) {
            return new Result(Types.ref((Object)this.ts.typeVariable(this.position, id, bounds)), pos);
        }
        TypeVariable tv = (TypeVariable)this.findTypeVar(id).get();
        tv.bounds(bounds);
        return new Result(Types.ref((Object)tv), pos);
    }

    public Result classBound(String value, int pos) {
        return this.fieldTypeSig(value, ++pos);
    }

    public Result fieldTypeSig(String value, int pos) {
        Result res = null;
        char token = value.charAt(pos);
        switch (token) {
            case 'L': {
                res = this.classTypeSig(value, pos);
                break;
            }
            case '[': {
                res = this.arrayTypeSig(value, pos);
                break;
            }
            case 'T': {
                res = this.typeVarSig(value, pos);
                break;
            }
            case ':': {
                res = new Result(this.cllz.typeForName("java.lang.Object"), pos);
            }
        }
        return res;
    }

    public Result classTypeSig(String value, int pos) {
        char token = value.charAt(pos);
        String className = "";
        String id = "";
        HashMap<String, List> classArgsMap = new HashMap<String, List>();
        token = value.charAt(++pos);
        block5: while (token != ';') {
            switch (token) {
                case '/': {
                    className = className + id;
                    className = className + ".";
                    id = "";
                    token = value.charAt(++pos);
                    continue block5;
                }
                case '.': {
                    className = className + id;
                    className = className + "$";
                    id = "";
                    token = value.charAt(++pos);
                    continue block5;
                }
                case '<': {
                    Result tres = this.typeArgList(value, pos);
                    pos = tres.pos();
                    classArgsMap.put(id, (List)tres.result());
                    token = value.charAt(pos);
                    continue block5;
                }
            }
            id = id + token;
            token = value.charAt(++pos);
        }
        className = className + id;
        List tvList = classArgsMap.containsKey(id) ? (List)classArgsMap.get(id) : Collections.EMPTY_LIST;
        Ref<? extends Type> ct = ((JL5ClassFileLazyClassInitializer)this.cllz).typeForName(className, tvList);
        return new Result(ct, ++pos);
    }

    public Result typeVarSig(String value, int pos) {
        Result res = null;
        char token = value.charAt(pos);
        switch (token) {
            case 'T': {
                String id = "";
                token = value.charAt(++pos);
                while (token != ';') {
                    id = id + token;
                    token = value.charAt(++pos);
                }
                res = new Result(this.findTypeVar(id), ++pos);
            }
        }
        return res;
    }

    public Result typeArgList(String value, int pos) {
        ArrayList<Object> typeArgs = new ArrayList<Object>();
        char token = value.charAt(pos++);
        while (token != '>') {
            Result tres = this.typeArg(value, pos);
            pos = tres.pos();
            typeArgs.add(tres.result());
            token = value.charAt(pos);
        }
        return new Result(typeArgs, ++pos);
    }

    public Result typeArg(String value, int pos) {
        Result res = null;
        char token = value.charAt(pos);
        switch (token) {
            case '+': {
                Result fres = this.fieldTypeSig(value, ++pos);
                res = new Result(Types.ref((Object)this.ts.anySubType(fres.resultTypeRef())), fres.pos());
                break;
            }
            case '-': {
                Result fres = this.fieldTypeSig(value, ++pos);
                res = new Result(Types.ref((Object)this.ts.anySuperType(fres.resultTypeRef())), fres.pos());
                break;
            }
            case '*': {
                res = new Result(Types.ref((Object)this.ts.anyType()), ++pos);
                break;
            }
            case 'L': 
            case 'T': 
            case '[': {
                res = this.fieldTypeSig(value, pos);
            }
        }
        return res;
    }

    public Result arrayTypeSig(String value, int pos) {
        Result res = null;
        char token = value.charAt(pos);
        switch (token) {
            case '[': {
                Result tres = this.typeSig(value, ++pos);
                Ref type = (Ref)tres.result();
                res = new Result(this.cllz.arrayOf(type, 1), tres.pos());
                break;
            }
        }
        return res;
    }

    public Result typeSigList(String value, int pos) {
        ArrayList<Object> formals = new ArrayList<Object>();
        char token = value.charAt(pos);
        while (token != ')') {
            Result ares = this.typeSig(value, pos);
            pos = ares.pos();
            formals.add(ares.result());
            token = value.charAt(pos);
        }
        return new Result(formals, ++pos);
    }

    public Result typeSig(String value, int pos) {
        Result res = null;
        char token = value.charAt(pos);
        switch (token) {
            case 'L': 
            case 'T': 
            case '[': {
                res = this.fieldTypeSig(value, pos);
                break;
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                res = this.baseType(value, pos);
            }
        }
        return res;
    }

    public Result methodTypeSig(String value, int pos) {
        char token = value.charAt(pos);
        List<Object> list = new ArrayList<Ref<TypeVariable>>();
        this.typeVars = list;
        List typeFormals = Collections.EMPTY_LIST;
        Ref typeReturned = null;
        List typeThrown = Collections.EMPTY_LIST;
        if (token == '<') {
            Result fres = this.formalTypeParamList(value, ++pos);
            pos = fres.pos();
            if (fres != null) {
                list = (List)fres.result();
            }
            this.typeVars = list;
        }
        if ((token = value.charAt(pos)) == '(') {
            Result ares = this.typeSigList(value, ++pos);
            pos = ares.pos();
            if (ares != null) {
                typeFormals = (List)ares.result();
            }
        }
        Result rres = this.returnType(value, pos);
        typeReturned = (Ref)rres.result();
        pos = rres.pos();
        if (pos < value.length() && (token = value.charAt(pos)) == '^') {
            Result tres = this.throwsSigList(value, pos);
            pos = tres.pos();
            if (typeThrown != null) {
                typeThrown = (List)tres.result();
            }
        }
        ArrayList<Ref<? extends Type>> typeVarsList = new ArrayList<Ref<? extends Type>>(list);
        return new Result(new MethodSig(typeVarsList, typeFormals, (Ref<? extends Type>)typeReturned, typeThrown), pos);
    }

    public Result returnType(String value, int pos) {
        Result res = null;
        char token = value.charAt(pos);
        switch (token) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'L': 
            case 'S': 
            case 'T': 
            case 'Z': 
            case '[': {
                res = this.typeSig(value, pos);
                break;
            }
            case 'V': {
                res = new Result(Types.ref((Object)this.ts.Void()), ++pos);
            }
        }
        return res;
    }

    public Result throwsSigList(String value, int pos) {
        ArrayList<Object> throwsList = new ArrayList<Object>();
        while (pos < value.length()) {
            Result tres = this.throwsSig(value, pos);
            pos = tres.pos();
            throwsList.add(tres.result());
        }
        return new Result(throwsList, pos);
    }

    public Result throwsSig(String value, int pos) {
        Result res = null;
        char token = value.charAt(pos);
        switch (token) {
            case '^': {
                token = value.charAt(++pos);
                switch (token) {
                    case 'L': {
                        res = this.classTypeSig(value, pos);
                    }
                    case 'T': {
                        res = this.typeVarSig(value, pos);
                    }
                }
            }
        }
        return res;
    }

    public Result baseType(String value, int pos) {
        Result res = null;
        char token = value.charAt(pos);
        switch (token) {
            case 'B': {
                res = new Result(Types.ref((Object)this.ts.Byte()), ++pos);
                break;
            }
            case 'C': {
                res = new Result(Types.ref((Object)this.ts.Char()), ++pos);
                break;
            }
            case 'D': {
                res = new Result(Types.ref((Object)this.ts.Double()), ++pos);
                break;
            }
            case 'F': {
                res = new Result(Types.ref((Object)this.ts.Float()), ++pos);
                break;
            }
            case 'I': {
                res = new Result(Types.ref((Object)this.ts.Int()), ++pos);
                break;
            }
            case 'J': {
                res = new Result(Types.ref((Object)this.ts.Long()), ++pos);
                break;
            }
            case 'S': {
                res = new Result(Types.ref((Object)this.ts.Short()), ++pos);
                break;
            }
            case 'Z': {
                res = new Result(Types.ref((Object)this.ts.Boolean()), ++pos);
            }
        }
        return res;
    }

    public void parseClassSignature(ClassFileLazyClassInitializer cllz, TypeSystem ts, Position pos) throws IOException, SemanticException {
        this.ts = (JL5TypeSystem)ts;
        this.position = pos;
        this.cllz = cllz;
        String sigValue = (String)this.cls.getConstants()[this.index].value();
        this.classSignature = (ClassSig)this.classSig(sigValue, 0).result();
    }

    public void parseMethodSignature(ClassFileLazyClassInitializer cllz, TypeSystem ts, Position pos, ClassDef ct) throws IOException {
        this.ts = (JL5TypeSystem)ts;
        this.position = pos;
        this.curClass = (JL5ClassDef)ct;
        this.cllz = cllz;
        String sigValue = (String)this.cls.getConstants()[this.index].value();
        this.methodSignature = (MethodSig)this.methodTypeSig(sigValue, 0).result();
    }

    public void parseFieldSignature(ClassFileLazyClassInitializer cllz, TypeSystem ts, Position pos, ClassDef ct) throws IOException, SemanticException {
        this.ts = (JL5TypeSystem)ts;
        this.position = pos;
        this.curClass = (JL5ClassDef)ct;
        this.cllz = cllz;
        String sigValue = (String)this.cls.getConstants()[this.index].value();
        Result res = this.fieldTypeSig(sigValue, 0);
        if (res != null) {
            this.fieldSignature = new FieldSig((Ref<? extends Type>)((Ref)res.result()));
        }
    }

    private Ref<TypeVariable> findTypeVar(String next) {
        TypeVariable tv;
        if (this.typeVars != null) {
            for (Ref<TypeVariable> ref : this.typeVars) {
                tv = (TypeVariable)ref.get();
                if (!tv.name().toString().equals(next)) continue;
                return ref;
            }
        }
        if (this.curClass != null && this.curClass.typeVariables() != null) {
            for (Ref<TypeVariable> ref : this.curClass.typeVariables()) {
                tv = (TypeVariable)ref.get();
                if (!tv.name().toString().equals(next)) continue;
                return ref;
            }
        }
        return null;
    }

    public List<Ref<? extends Type>> typeVariables() {
        if (this.classSignature != null && this.classSignature.typeVars != null) {
            return this.classSignature.typeVars();
        }
        return Collections.EMPTY_LIST;
    }

    public String toString() {
        return (String)this.cls.getConstants()[this.index].value();
    }

    public List<Ref<? extends Type>> getSuperInterfacesType() {
        if (this.classSignature != null && this.classSignature.interfaces != null) {
            return this.classSignature.interfaces;
        }
        return Collections.EMPTY_LIST;
    }

    public Ref<? extends Type> getSuperclassType() {
        assert (this.classSignature != null && this.classSignature.superType != null);
        return this.classSignature.superType;
    }

    class Result {
        protected int pos;
        protected Object result;

        public Result(Object result, int pos) {
            this.result = result;
            this.pos = pos;
        }

        public int pos() {
            return this.pos;
        }

        public Object result() {
            return this.result;
        }

        public Ref<? extends Type> resultTypeRef() {
            return (Ref)this.result;
        }
    }

    class FieldSig {
        protected Ref<? extends Type> type;

        public FieldSig(Ref<? extends Type> result) {
            this.type = result;
        }
    }

    class MethodSig {
        protected List<Ref<? extends Type>> typeVars;
        protected List<Ref<? extends Type>> formalTypes;
        protected Ref<? extends Type> returnType;
        protected List<Ref<? extends Type>> throwTypes;

        public MethodSig(List<Ref<? extends Type>> typeVars, List<Ref<? extends Type>> formalTypes, Ref<? extends Type> returnType, List<Ref<? extends Type>> throwTypes) {
            this.typeVars = typeVars;
            this.formalTypes = formalTypes;
            this.returnType = returnType;
            this.throwTypes = throwTypes;
        }

        public List<Ref<? extends Type>> typeVars() {
            return this.typeVars;
        }

        public List<Ref<? extends Type>> formalTypes() {
            return this.formalTypes;
        }

        public Ref<? extends Type> returnType() {
            return this.returnType;
        }

        public List<Ref<? extends Type>> throwTypes() {
            return this.throwTypes;
        }
    }

    class ClassSig {
        protected List<Ref<? extends Type>> typeVars;
        protected Ref<? extends Type> superType;
        protected List<Ref<? extends Type>> interfaces;

        public ClassSig(List<Ref<? extends Type>> typeVars, Ref<? extends Type> superType, List<Ref<? extends Type>> interfaces) {
            this.typeVars = typeVars;
            this.superType = superType;
            this.interfaces = interfaces;
        }

        public List<Ref<? extends Type>> typeVars() {
            return this.typeVars;
        }

        public Ref<? extends Type> superType() {
            return this.superType;
        }

        public List<Ref<? extends Type>> interfaces() {
            return this.interfaces;
        }
    }
}

