/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5.visit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import polyglot.ast.FieldDecl;
import polyglot.ast.IntLit;
import polyglot.ast.NodeFactory;
import polyglot.ast.TypeNode;
import polyglot.ext.jl5.types.JL5ParsedClassType;
import polyglot.main.Report;
import polyglot.main.Version;
import polyglot.types.ClassDef;
import polyglot.types.ClassType;
import polyglot.types.FieldDef;
import polyglot.types.Flags;
import polyglot.types.InitializerDef;
import polyglot.types.Name;
import polyglot.types.ParsedClassType_c;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.types.Types;
import polyglot.util.ErrorQueue;
import polyglot.util.Position;
import polyglot.visit.ClassSerializer;

public class JL5ClassSerializer
extends ClassSerializer {
    private static final int MAX_ENCODED_TYPE_INFO_STRING_LENGTH = 8192;

    public JL5ClassSerializer(TypeSystem ts, NodeFactory nf, Date date, ErrorQueue eq, Version ver) {
        super(ts, nf, date, eq, ver);
    }

    public List createSerializationMembers(ClassDef cd) {
        try {
            ArrayList<FieldDecl> newMembers = new ArrayList<FieldDecl>(3);
            ClassType ct = cd.asType();
            ct.memberClasses();
            ct.constructors();
            ct.methods();
            ct.fields();
            ct.interfaces();
            ct.superClass();
            ((JL5ParsedClassType)ct).typeVariables();
            if (!ct.isTopLevel() && !ct.isMember()) {
                return Collections.EMPTY_LIST;
            }
            String suffix = this.ver.name();
            if (ct.fieldNamed(Name.make((String)("jlc$CompilerVersion$" + suffix))) != null || ct.fieldNamed(Name.make((String)("jlc$SourceLastModified$" + suffix))) != null || ct.fieldNamed(Name.make((String)("jlc$ClassType$" + suffix))) != null) {
                this.eq.enqueue(5, "Cannot serialize class information more than once.");
                return Collections.EMPTY_LIST;
            }
            Flags flags = Flags.PUBLIC.set(Flags.STATIC).set(Flags.FINAL);
            String version = this.ver.major() + "." + this.ver.minor() + "." + this.ver.patch_level();
            Position pos = Position.COMPILER_GENERATED;
            FieldDef fi = this.ts.fieldDef(pos, Types.ref((Object)new ParsedClassType_c(cd)), flags, Types.ref((Object)this.ts.String()), Name.make((String)("jlc$CompilerVersion$" + suffix)));
            fi.setConstantValue((Object)version);
            InitializerDef ii = this.ts.initializerDef(pos, Types.ref((Object)new ParsedClassType_c(cd)), Flags.STATIC);
            FieldDecl f = this.nf.FieldDecl(fi.position(), this.nf.FlagsNode(fi.position(), fi.flags()), (TypeNode)this.nf.CanonicalTypeNode(fi.position(), fi.type()), this.nf.Id(fi.position(), fi.name()), this.nf.StringLit(pos, version).type(this.ts.String()));
            f = f.fieldDef(fi);
            f = f.initializerDef(ii);
            newMembers.add(f);
            long time = this.date.getTime();
            fi = this.ts.fieldDef(pos, Types.ref((Object)new ParsedClassType_c(cd)), flags, Types.ref((Object)this.ts.Long()), Name.make((String)("jlc$SourceLastModified$" + suffix)));
            fi.setConstantValue((Object)new Long(time));
            ii = this.ts.initializerDef(pos, Types.ref((Object)new ParsedClassType_c(cd)), Flags.STATIC);
            f = this.nf.FieldDecl(fi.position(), this.nf.FlagsNode(fi.position(), fi.flags()), (TypeNode)this.nf.CanonicalTypeNode(fi.position(), fi.type()), this.nf.Id(fi.position(), fi.name()), this.nf.IntLit(pos, IntLit.LONG, time).type(this.ts.Long()));
            f = f.fieldDef(fi);
            f = f.initializerDef(ii);
            newMembers.add(f);
            String encodedTypeInfo = this.te.encode((TypeObject)ct);
            int etiStart = 0;
            int etiEnd = 0;
            int numberETIFields = 0;
            do {
                if ((etiEnd = encodedTypeInfo.length()) - etiStart > 8192) {
                    etiEnd = etiStart + 8192;
                }
                String additionalFieldSuffix = numberETIFields == 0 ? "" : "$" + numberETIFields;
                String encoded = encodedTypeInfo.substring(etiStart, etiEnd);
                fi = this.ts.fieldDef(pos, Types.ref((Object)new ParsedClassType_c(cd)), flags, Types.ref((Object)this.ts.String()), Name.make((String)("jlc$ClassType$" + suffix + additionalFieldSuffix)));
                fi.setConstantValue((Object)encoded);
                ii = this.ts.initializerDef(pos, Types.ref((Object)new ParsedClassType_c(cd)), Flags.STATIC);
                f = this.nf.FieldDecl(fi.position(), this.nf.FlagsNode(fi.position(), fi.flags()), (TypeNode)this.nf.CanonicalTypeNode(fi.position(), fi.type()), this.nf.Id(fi.position(), fi.name()), this.nf.StringLit(pos, encoded).type(this.ts.String()));
                f = f.fieldDef(fi);
                f = f.initializerDef(ii);
                newMembers.add(f);
                ++numberETIFields;
                etiStart = etiEnd;
            } while (etiEnd != encodedTypeInfo.length());
            return newMembers;
        }
        catch (IOException e) {
            if (Report.should_report((String)"serialize", (int)1)) {
                e.printStackTrace();
            }
            this.eq.enqueue(2, "Unable to serialize class information.");
            return Collections.EMPTY_LIST;
        }
    }
}

