/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import lpg.runtime.Differ;
import lpg.runtime.ILexStream;
import lpg.runtime.IPrsStream;
import lpg.runtime.LexStream;
import lpg.runtime.UnknownStreamType;
import lpg.runtime.Utf8LexStream;

public class DifferTokens
extends Differ {
    protected DifferTokens() {
    }

    public DifferTokens(IPrsStream iPrsStream, IPrsStream iPrsStream2) {
        super(iPrsStream, iPrsStream2);
    }

    public Differ.ILine[] getBuffer(IPrsStream iPrsStream) {
        Differ.ILine[] iLineArray = new Token[iPrsStream.getStreamLength()];
        for (int i = 1; i < iPrsStream.getStreamLength(); ++i) {
            iLineArray[i] = new Token(iPrsStream, i);
        }
        return iLineArray;
    }

    void printLines(IPrsStream iPrsStream, int n, int n2) {
        int n3 = iPrsStream.getLine(n);
        int n4 = iPrsStream.getLine(n2);
        ILexStream iLexStream = iPrsStream.getLexStream();
        char[] cArray = null;
        byte[] byArray = null;
        if (iLexStream instanceof LexStream) {
            cArray = ((LexStream)iLexStream).getInputChars();
        } else if (iLexStream instanceof Utf8LexStream) {
            byArray = ((Utf8LexStream)iLexStream).getInputBytes();
        } else {
            throw new UnknownStreamType("Unknown stream type " + iLexStream.getClass().toString());
        }
        int n5 = iLexStream.getLineOffset(n3 - 1) + 1;
        int n6 = iLexStream.getLineOffset(n3);
        if (n3 == n4) {
            int n7;
            String string = "" + n3;
            for (int i = 0; i < 6 - string.length(); ++i) {
                System.out.print(' ');
            }
            String string2 = cArray != null ? new String(cArray, n5, n6 - n5) : new String(byArray, n5, n6 - n5);
            System.out.println(n3 + " " + string2);
            System.out.print("       ");
            for (n7 = 0; n7 < iPrsStream.getColumn(n) - 1; ++n7) {
                System.out.print(' ');
            }
            n7 = iPrsStream.getEndColumn(n2) - iPrsStream.getColumn(n);
            if (n7 < 2) {
                System.out.println('^');
            } else {
                System.out.print('<');
                for (int i = 1; i < n7; ++i) {
                    System.out.print('-');
                }
                System.out.println('>');
            }
        } else {
            int n8;
            int n9;
            System.out.print("       ");
            for (n9 = 0; n9 < iPrsStream.getColumn(n) - 1; ++n9) {
                System.out.print(' ');
            }
            n9 = iLexStream.getColumn(iLexStream.getPrevious(n6));
            System.out.print('<');
            for (n8 = iPrsStream.getColumn(n) + 1; n8 < n9; ++n8) {
                System.out.print('-');
            }
            System.out.println();
            for (n8 = n3; n8 <= n4; ++n8) {
                n5 = iLexStream.getLineOffset(n8 - 1) + 1;
                n6 = iLexStream.getLineOffset(n8);
                String string = "" + n8;
                for (int i = 0; i < 6 - string.length(); ++i) {
                    System.out.print(' ');
                }
                String string3 = cArray != null ? new String(cArray, n5, n6 - n5) : new String(byArray, n5, n6 - n5);
                System.out.println(n8 + " " + string3);
            }
            System.out.print("       ");
            for (n8 = 0; n8 < iPrsStream.getEndColumn(n2) - 1; ++n8) {
                System.out.print('-');
            }
            System.out.println('>');
        }
    }

    void outputInsert(Differ.Change change) {
        this.insertCount += change.getNewe() - change.getNews() + 1;
        System.out.println("Insert after " + this.oldStream.getFileName() + "," + this.oldStream.getLine(change.getOlde()) + ":" + this.oldStream.getEndColumn(change.getOlde()) + " " + this.newStream.getFileName() + "," + this.newStream.getLine(change.getNews()) + ":" + this.newStream.getColumn(change.getNews()) + ".." + this.newStream.getLine(change.getNewe()) + ":" + this.newStream.getEndColumn(change.getNewe()) + ":");
        this.printLines(this.newStream, change.getNews(), change.getNewe());
    }

    void outputDelete(Differ.Change change) {
        this.deleteCount += change.getOlde() - change.getOlds() + 1;
        System.out.println("Delete after " + this.newStream.getFileName() + "," + this.newStream.getLine(change.getNewe()) + ":" + this.newStream.getEndColumn(change.getNewe()) + " " + this.oldStream.getFileName() + "," + this.oldStream.getLine(change.getOlds()) + ":" + this.oldStream.getColumn(change.getOlds()) + ".." + this.oldStream.getLine(change.getOlde()) + ":" + this.oldStream.getEndColumn(change.getOlde()) + ":");
        this.printLines(this.oldStream, change.getOlds(), change.getOlde());
    }

    void outputReplace(Differ.Change change) {
        this.replaceDeleteCount += change.getOlde() - change.getOlds() + 1;
        this.replaceInsertCount += change.getNewe() - change.getNews() + 1;
        System.out.println("Replace " + this.oldStream.getFileName() + "," + this.oldStream.getLine(change.getOlds()) + ":" + this.oldStream.getColumn(change.getOlds()) + ".." + this.oldStream.getLine(change.getOlde()) + ":" + this.oldStream.getEndColumn(change.getOlde()) + ":");
        this.printLines(this.oldStream, change.getOlds(), change.getOlde());
        System.out.println("With " + this.newStream.getFileName() + "," + this.newStream.getLine(change.getNews()) + ":" + this.newStream.getColumn(change.getNews()) + ".." + this.newStream.getLine(change.getNewe()) + ":" + this.newStream.getEndColumn(change.getNewe()) + ":");
        this.printLines(this.newStream, change.getNews(), change.getNewe());
    }

    void outputMove(Differ.Change change) {
        this.moveCount += change.getNewe() - change.getNews() + 1;
        System.out.println("Move " + this.oldStream.getFileName() + "," + this.oldStream.getLine(change.getOlds()) + ":" + this.oldStream.getColumn(change.getOlds()) + ".." + this.oldStream.getLine(change.getOlde()) + ":" + this.oldStream.getEndColumn(change.getOlde()) + " to " + this.newStream.getFileName() + "," + this.newStream.getLine(change.getNews()) + ":" + this.newStream.getColumn(change.getNews()) + ".." + this.newStream.getLine(change.getNewe()) + ":" + this.newStream.getEndColumn(change.getNewe()) + ":");
        this.printLines(this.newStream, change.getNews(), change.getNewe());
    }

    void outputMoveDelete(Differ.Change change) {
        int n = change.getNewe() - change.getNews();
        this.moveCount += n + 1;
        System.out.println("Move " + this.oldStream.getFileName() + "," + this.oldStream.getLine(change.getOlds()) + ":" + this.oldStream.getColumn(change.getOlds()) + ".." + this.oldStream.getLine(change.getOlds() + n) + ":" + this.oldStream.getEndColumn(change.getOlds() + n) + " to " + this.newStream.getFileName() + "," + this.newStream.getLine(change.getNews()) + ":" + this.newStream.getColumn(change.getNews()) + ".." + this.newStream.getLine(change.getNewe()) + ":" + this.newStream.getEndColumn(change.getNewe()) + ":");
        this.printLines(this.newStream, change.getNews(), change.getNewe());
        int n2 = change.getOlds() + n + 1;
        this.deleteCount += change.getOlde() - n2 + 1;
        System.out.println("... And delete " + this.oldStream.getFileName() + "," + this.oldStream.getLine(n2) + ":" + this.oldStream.getColumn(n2) + ".." + this.oldStream.getLine(change.getOlde()) + ":" + this.oldStream.getEndColumn(change.getOlde()));
        this.printLines(this.oldStream, n2, change.getOlde());
    }

    void outputMoveInsert(Differ.Change change) {
        int n = change.getOlde() - change.getOlds();
        this.moveCount += change.getOlde() - change.getOlds() + 1;
        System.out.println("Move " + this.oldStream.getFileName() + "," + this.oldStream.getLine(change.getOlds()) + ":" + this.oldStream.getColumn(change.getOlds()) + ".." + this.oldStream.getLine(change.getOlde()) + ":" + this.oldStream.getEndColumn(change.getOlde()) + " to " + this.newStream.getFileName() + "," + this.newStream.getLine(change.getNews()) + ":" + this.newStream.getColumn(change.getNews()) + ".." + this.newStream.getLine(change.getNews() + n) + ":" + this.newStream.getEndColumn(change.getNews() + n) + ":");
        this.printLines(this.newStream, change.getNews(), change.getNews() + n);
        int n2 = change.getNews() + n + 1;
        this.insertCount += change.getNewe() - n2 + 1;
        System.out.println("... And insert " + this.newStream.getFileName() + "," + this.newStream.getLine(n2) + ":" + this.newStream.getColumn(n2) + ".." + this.newStream.getLine(change.getNewe()) + ":" + this.newStream.getEndColumn(change.getNewe()) + ":");
        this.printLines(this.newStream, n2, change.getNewe());
    }

    public class Token
    implements Differ.ILine {
        private int kind;
        private int start_line;
        private int start_column;
        private int end_line;
        private int end_column;
        private String name;
        private int hash_code;

        public Token(IPrsStream iPrsStream, int n) {
            this.kind = iPrsStream.getKind(n);
            this.name = iPrsStream.getName(n);
            this.start_line = iPrsStream.getLine(n);
            this.start_column = iPrsStream.getColumn(n);
            this.end_line = iPrsStream.getEndLine(n);
            this.end_column = iPrsStream.getEndColumn(n);
            this.hash_code = this.name.hashCode();
        }

        public final int size() {
            return this.name.length();
        }

        public final int hashCode() {
            return this.hash_code;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Token) {
                Token token = (Token)object;
                return this.kind == token.kind && this.name.equals(token.name);
            }
            return false;
        }

        public final int getStartLine() {
            return this.start_line;
        }

        public final int getStartColumn() {
            return this.start_column;
        }

        public final int getEndLine() {
            return this.end_line;
        }

        public final int getEndColumn() {
            return this.end_column;
        }

        public final String toString() {
            return this.name;
        }
    }
}

