/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.List;
import soot.ArrayType;
import soot.HjToJimple.LocalGenerator;
import soot.HjToJimple.jimple.factory.HjMethodFactory;
import soot.HjToJimple.jimple.utils.ArrayViewUtils;
import soot.HjToJimple.util.HjValueBox;
import soot.HjToJimple.util.Point;
import soot.Local;
import soot.NullType;
import soot.Type;
import soot.Unit;
import soot.UnitPrinter;
import soot.UnknownType;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.JimpleToBafContext;
import soot.jimple.Stmt;
import soot.jimple.internal.JArrayRef;
import soot.util.Switch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjArrayRef
extends JArrayRef {
    protected Point point;

    public HjArrayRef(Value base, Point point) {
        this.baseBox = new HjValueBox(base);
        this.point = point;
    }

    @Override
    public Object clone() {
        return new HjArrayRef(Jimple.cloneIfNecessary(this.getBase()), (Point)this.point.clone());
    }

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof ArrayRef) {
            ArrayRef other = (ArrayRef)o;
            return this.getBase().equivTo(other.getBase()) && this.getIndex().equivTo(other.getIndex());
        }
        return false;
    }

    @Override
    public int equivHashCode() {
        return this.getBase().equivHashCode() * 101 + this.getIndex().equivHashCode() + 18;
    }

    @Override
    public String toString() {
        if (this.indexBox != null) {
            return "HjArrayRef: " + this.baseBox.getValue().toString() + "[" + this.indexBox.getValue().toString() + "]";
        }
        return "HjArrayRef: " + this.baseBox.getValue().toString() + "[" + this.point.toString() + "]";
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal(this.toString());
    }

    @Override
    public Value getBase() {
        return this.baseBox.getValue();
    }

    @Override
    public void setBase(Local base) {
        this.baseBox.setValue(base);
    }

    @Override
    public ValueBox getBaseBox() {
        return this.baseBox;
    }

    @Override
    public Value getIndex() {
        return this.point.getIndexList().get(0);
    }

    @Override
    public void setIndex(Value index) {
        this.point.getIndexBoxes().get(0).setValue(index);
    }

    @Override
    public ValueBox getIndexBox() {
        return this.point.getIndexBoxes().get(0);
    }

    @Override
    public List getUseBoxes() {
        ArrayList<ValueBox> useBoxes = new ArrayList<ValueBox>();
        useBoxes.addAll(this.baseBox.getValue().getUseBoxes());
        useBoxes.add(this.baseBox);
        useBoxes.addAll(this.point.getIndexBoxes());
        return useBoxes;
    }

    public List<Stmt> genLeftOpStmts(Value leftOp, LocalGenerator lg) {
        Local arrayLocal;
        ArrayList<Stmt> stmts = new ArrayList<Stmt>();
        Value leftValue = leftOp;
        Value arrayValue = this.baseBox.getValue();
        if (arrayValue instanceof Local) {
            arrayLocal = (Local)arrayValue;
        } else {
            arrayLocal = lg.generateLocal(arrayValue.getType());
            stmts.add(Jimple.v().newAssignStmt(arrayLocal, arrayValue));
        }
        InvokeExpr invokeExpr = HjMethodFactory.getArrayValueMth(arrayLocal, this.point);
        AssignStmt assignStmt = Jimple.v().newAssignStmt(leftValue, invokeExpr);
        stmts.add(assignStmt);
        return stmts;
    }

    public List<Stmt> genRightOpStmts(Value rightOp, LocalGenerator lg) {
        Local arrayLocal;
        Local rightLocal;
        ArrayList<Stmt> stmts = new ArrayList<Stmt>();
        if (rightOp instanceof Local) {
            rightLocal = (Local)rightOp;
        } else {
            rightLocal = lg.generateLocal(rightOp.getType());
            stmts.add(Jimple.v().newAssignStmt(rightLocal, rightOp));
        }
        Value arrayValue = this.baseBox.getValue();
        if (arrayValue instanceof Local) {
            arrayLocal = (Local)arrayValue;
        } else {
            arrayLocal = lg.generateLocal(arrayValue.getType());
            stmts.add(Jimple.v().newAssignStmt(arrayLocal, arrayValue));
        }
        InvokeExpr invokeExpr = HjMethodFactory.setArrayValueMth(arrayLocal, rightLocal, this.point, rightLocal.getType());
        stmts.add(Jimple.v().newInvokeStmt(invokeExpr));
        return stmts;
    }

    @Override
    public Type getType() {
        Type type = this.getNormalType();
        type = ArrayViewUtils.getHjArrayViewPrimitiveType(type);
        return type;
    }

    protected Type getNormalType() {
        Value base = this.baseBox.getValue();
        Type type = base.getType();
        if (type.equals(UnknownType.v())) {
            return UnknownType.v();
        }
        if (type.equals(NullType.v())) {
            return NullType.v();
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            if (arrayType.numDimensions == 1) {
                return arrayType.baseType;
            }
            return ArrayType.v(arrayType.baseType, arrayType.numDimensions - 1);
        }
        return type;
    }

    @Override
    public void apply(Switch sw) {
        throw new RuntimeException("This should not happen " + this);
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        throw new RuntimeException("This should not happen");
    }
}

