/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import soot.Body;
import soot.G;
import soot.HjToJimple.LocalGenerator;
import soot.IntType;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.VoidType;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;

public class HjOVDTranslator
extends SceneTransformer {
    public static String CHECKREAD_METHODNAME = "checkRead";
    public static String CHECKWRITE_METHODNAME = "checkWrite";
    protected SootClass hjRuntimeOVDClass;
    protected SootClass activityRunnerClass;
    protected SootClass javaLangObjectClass;
    protected SootClass hjLangObjectClass;
    protected SootClass activityClass;
    protected SootClass linkListClass;
    protected SootMethod checkReadObjMethod;
    protected SootMethod checkWriteObjMethod;
    protected SootMethod checkReadARObjMethod;
    protected SootMethod checkWriteARObjMethod;
    protected SootMethod checkReadObjIdMethod;
    protected SootMethod checkWriteObjIdMethod;
    protected SootMethod checkReadARObjIdMethod;
    protected SootMethod checkWriteARObjIdMethod;
    protected HashMap<String, Value> staticFieldMap = new HashMap();
    protected int staticFieldCount = 0;
    protected HashMap<SootMethod, SootMethod> annotatedMethods = new HashMap();

    public HjOVDTranslator(Singletons.Global g) {
    }

    public static HjOVDTranslator v() {
        return G.v().soot_HjToJimple_jimple_HjOVDTranslator();
    }

    protected void internalTransform(String phaseName, Map opts) {
        ListIterator<SootMethod> methodIter;
        this.initReferences();
        for (SootClass appClass : Scene.v().getApplicationClasses()) {
            methodIter = appClass.getMethods().listIterator();
            while (methodIter.hasNext()) {
                this.prescan((SootMethod)methodIter.next());
            }
        }
        for (SootClass appClass : Scene.v().getApplicationClasses()) {
            methodIter = appClass.getMethods().listIterator();
            while (methodIter.hasNext()) {
                this.hjOVDTransform((SootMethod)methodIter.next(), null, phaseName, opts);
            }
        }
    }

    protected void initReferences() {
        if (this.hjRuntimeOVDClass != null) {
            return;
        }
        this.hjRuntimeOVDClass = Scene.v().getSootClass("hj.runtime.wsh.ovd.WshOVDManager");
        this.activityRunnerClass = Scene.v().getSootClass("hj.runtime.wsh.ActivityRunner");
        this.javaLangObjectClass = Scene.v().getSootClass("java.lang.Object");
        this.hjLangObjectClass = Scene.v().getSootClass("hj.lang.Object");
        this.activityClass = Scene.v().getSootClass("hj.runtime.wsh.Activity");
        this.linkListClass = Scene.v().getSootClass("java.util.LinkedList");
        ArrayList<Type> typeList = new ArrayList<Type>();
        typeList.add(this.javaLangObjectClass.getType());
        this.checkReadObjMethod = this.hjRuntimeOVDClass.getMethod(CHECKREAD_METHODNAME, typeList, VoidType.v());
        this.checkWriteObjMethod = this.hjRuntimeOVDClass.getMethod(CHECKWRITE_METHODNAME, typeList, VoidType.v());
        typeList = new ArrayList();
        typeList.add(this.activityRunnerClass.getType());
        typeList.add(this.javaLangObjectClass.getType());
        this.checkReadARObjMethod = this.hjRuntimeOVDClass.getMethod(CHECKREAD_METHODNAME, typeList, VoidType.v());
        typeList = new ArrayList();
        typeList.add(this.activityRunnerClass.getType());
        typeList.add(this.javaLangObjectClass.getType());
        this.checkWriteARObjMethod = this.hjRuntimeOVDClass.getMethod(CHECKWRITE_METHODNAME, typeList, VoidType.v());
        typeList = new ArrayList();
        typeList.add(this.javaLangObjectClass.getType());
        typeList.add(IntType.v());
        this.checkReadObjIdMethod = this.hjRuntimeOVDClass.getMethod(CHECKREAD_METHODNAME, typeList, VoidType.v());
        this.checkWriteObjIdMethod = this.hjRuntimeOVDClass.getMethod(CHECKWRITE_METHODNAME, typeList, VoidType.v());
        typeList = new ArrayList();
        typeList.add(this.activityRunnerClass.getType());
        typeList.add(this.javaLangObjectClass.getType());
        typeList.add(IntType.v());
        this.checkReadARObjIdMethod = this.hjRuntimeOVDClass.getMethod(CHECKREAD_METHODNAME, typeList, VoidType.v());
        this.checkWriteARObjIdMethod = this.hjRuntimeOVDClass.getMethod(CHECKWRITE_METHODNAME, typeList, VoidType.v());
    }

    protected void prescan(SootMethod method) {
        Body body;
        if (this.annotatedMethods.containsKey(method)) {
            return;
        }
        boolean isActivityClass = false;
        SootClass superClass = method.getDeclaringClass().getSuperclass();
        if (superClass.getType().equals(this.activityClass.getType()) || superClass.getType().equals(this.linkListClass.getType())) {
            isActivityClass = true;
        }
        if (method.toString().indexOf("<init>") >= 0 || method.toString().indexOf("<cinit>") >= 0) {
            return;
        }
        try {
            body = method.getActiveBody();
        }
        catch (Exception e) {
            return;
        }
        Iterator<Unit> unitIter = body.getUnits().snapshotIterator();
        while (unitIter.hasNext()) {
            Stmt stmt = (Stmt)unitIter.next();
            Object invokeStmt = null;
            if (!(stmt instanceof AssignStmt)) continue;
            AssignStmt assignStmt = (AssignStmt)stmt;
            Value leftOp = assignStmt.getLeftOp();
            Value rightOp = assignStmt.getRightOp();
            if (leftOp instanceof FieldRef) {
                if (leftOp instanceof InstanceFieldRef) {
                    this.annotatedMethods.put(method, null);
                    return;
                }
                if (!(leftOp instanceof StaticFieldRef)) continue;
                this.annotatedMethods.put(method, null);
                return;
            }
            if (leftOp instanceof ArrayRef) {
                this.annotatedMethods.put(method, null);
                return;
            }
            if (rightOp instanceof FieldRef) {
                if (((FieldRef)rightOp).getField().isFinal()) continue;
                if (rightOp instanceof InstanceFieldRef) {
                    this.annotatedMethods.put(method, null);
                    return;
                }
                if (!(rightOp instanceof StaticFieldRef)) continue;
                this.annotatedMethods.put(method, null);
                return;
            }
            if (!(rightOp instanceof ArrayRef)) continue;
            this.annotatedMethods.put(method, null);
            return;
        }
    }

    protected void hjOVDTransform(SootMethod method, Local workerLocal, String phaseName, Map opts) {
        if (this.annotatedMethods.containsKey(method)) {
            if (this.annotatedMethods.get(method) != null) {
                return;
            }
        } else {
            return;
        }
        JimpleBody body = (JimpleBody)method.getActiveBody();
        LocalGenerator lg = new LocalGenerator(body);
        workerLocal = lg.generateLocal("ovdWorker", this.activityRunnerClass.getType());
        SootMethod currentWorkerMethod = Scene.v().getSootClass("hj.lang.Runtime").getMethodByName("getCurrentWorker");
        AssignStmt localWorkerStmt = Jimple.v().newAssignStmt(workerLocal, Jimple.v().newStaticInvokeExpr(currentWorkerMethod.makeRef(), Collections.EMPTY_LIST));
        body.getUnits().insertBefore(localWorkerStmt, (Unit)body.getFirstNonIdentityStmt());
        this.annotatedMethods.put(method, null);
        Iterator<Unit> unitIter = body.getUnits().snapshotIterator();
        while (unitIter.hasNext()) {
            Stmt stmt = (Stmt)unitIter.next();
            Stmt invokeStmt = null;
            if (stmt instanceof AssignStmt) {
                AssignStmt assignStmt = (AssignStmt)stmt;
                Value leftOp = assignStmt.getLeftOp();
                Value rightOp = assignStmt.getRightOp();
                if (leftOp instanceof FieldRef) {
                    if (leftOp instanceof InstanceFieldRef) {
                        invokeStmt = this.getCheckStmt(workerLocal, (InstanceFieldRef)leftOp, false);
                    } else if (leftOp instanceof StaticFieldRef) {
                        continue;
                    }
                } else if (leftOp instanceof ArrayRef) {
                    invokeStmt = this.getCheckStmt(workerLocal, (ArrayRef)leftOp, false);
                } else if (rightOp instanceof FieldRef) {
                    if (!((FieldRef)rightOp).getField().isFinal()) {
                        if (rightOp instanceof InstanceFieldRef) {
                            invokeStmt = this.getCheckStmt(workerLocal, (InstanceFieldRef)rightOp, true);
                        } else if (rightOp instanceof StaticFieldRef) {
                            continue;
                        }
                    }
                } else {
                    if (!(rightOp instanceof ArrayRef)) continue;
                    invokeStmt = this.getCheckStmt(workerLocal, (ArrayRef)rightOp, true);
                }
            }
            if (invokeStmt == null) continue;
            body.getUnits().insertBefore(invokeStmt, (Unit)stmt);
        }
    }

    protected InvokeExpr recreateInvokeExpr(InvokeExpr invokeExpr, Local workerLocal) {
        SootMethod method = null;
        try {
            method = invokeExpr.getMethod();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (method == null || !this.annotatedMethods.containsKey(method)) {
            return invokeExpr;
        }
        SootMethod aliasMethod = this.annotatedMethods.get(method);
        if (aliasMethod == null) {
            this.hjOVDTransform(method, null, "alias method generateion", null);
            aliasMethod = this.annotatedMethods.get(method);
        }
        if (aliasMethod == null) {
            return null;
        }
        ArrayList<Local> argList = new ArrayList<Local>();
        argList.addAll(invokeExpr.getArgs());
        argList.add(workerLocal);
        if (invokeExpr instanceof VirtualInvokeExpr) {
            return Jimple.v().newVirtualInvokeExpr((Local)((InstanceInvokeExpr)invokeExpr).getBase(), aliasMethod.makeRef(), argList);
        }
        if (invokeExpr instanceof StaticInvokeExpr) {
            return Jimple.v().newStaticInvokeExpr(aliasMethod.makeRef(), argList);
        }
        if (invokeExpr instanceof SpecialInvokeExpr) {
            return Jimple.v().newSpecialInvokeExpr((Local)((InstanceInvokeExpr)invokeExpr).getBase(), aliasMethod.makeRef(), argList);
        }
        if (invokeExpr instanceof InterfaceInvokeExpr) {
            return Jimple.v().newInterfaceInvokeExpr((Local)((InstanceInvokeExpr)invokeExpr).getBase(), aliasMethod.makeRef(), argList);
        }
        throw new RuntimeException("Unsupported Invoke Expr");
    }

    protected Stmt getCheckStmt(InstanceFieldRef fieldRef, boolean isRead) {
        Value baseVal = fieldRef.getBase();
        Type baseType = baseVal.getType();
        if (baseType instanceof RefType) {
            return this.createCheckStmt(fieldRef.getBase(), isRead);
        }
        throw new RuntimeException("The instance field should have class reference");
    }

    protected Stmt getCheckStmt(Local workerLocal, InstanceFieldRef fieldRef, boolean isRead) {
        Value baseVal = fieldRef.getBase();
        Type baseType = baseVal.getType();
        if (baseType instanceof RefType) {
            return this.createCheckStmt(workerLocal, fieldRef.getBase(), isRead);
        }
        throw new RuntimeException("The instance field should have class reference");
    }

    protected Stmt getCheckStmt(ArrayRef arrayRef, boolean isRead) {
        return this.createCheckStmt(arrayRef.getBase(), arrayRef.getIndex(), isRead);
    }

    protected Stmt getCheckStmt(Local workerLocal, ArrayRef arrayRef, boolean isRead) {
        return this.createCheckStmt(workerLocal, arrayRef.getBase(), arrayRef.getIndex(), isRead);
    }

    protected Stmt getCheckStmt(StaticFieldRef staticFieldRef, boolean isRead) {
        throw new Error("No support now: " + staticFieldRef);
    }

    protected Stmt getCheckStmt(Local workerLocal, StaticFieldRef staticFieldRef, boolean isRead) {
        throw new Error("No support now: " + staticFieldRef);
    }

    protected Stmt createCheckStmt(Value checkValue, boolean isRead) {
        ArrayList<Value> params = new ArrayList<Value>();
        params.add(checkValue);
        if (isRead) {
            return Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(this.checkReadObjMethod.makeRef(), params));
        }
        return Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(this.checkWriteObjMethod.makeRef(), params));
    }

    protected Stmt createCheckStmt(Local workerLocal, Value checkValue, boolean isRead) {
        ArrayList<Value> params = new ArrayList<Value>();
        params.add(workerLocal);
        params.add(checkValue);
        if (isRead) {
            return Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(this.checkReadARObjMethod.makeRef(), params));
        }
        return Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(this.checkWriteARObjMethod.makeRef(), params));
    }

    protected Stmt createCheckStmt(Value checkValue, Value checkId, boolean isRead) {
        ArrayList<Value> params = new ArrayList<Value>();
        params.add(checkValue);
        params.add(checkId);
        if (isRead) {
            return Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(this.checkReadObjIdMethod.makeRef(), params));
        }
        return Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(this.checkWriteObjIdMethod.makeRef(), params));
    }

    protected Stmt createCheckStmt(Local workerLocal, Value checkValue, Value checkId, boolean isRead) {
        ArrayList<Value> params = new ArrayList<Value>();
        params.add(workerLocal);
        params.add(checkValue);
        params.add(checkId);
        if (isRead) {
            return Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(this.checkReadARObjIdMethod.makeRef(), params));
        }
        return Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(this.checkWriteARObjIdMethod.makeRef(), params));
    }
}

