/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple;

import java.util.Iterator;
import java.util.List;
import soot.Body;
import soot.HjToJimple.jimple.NopRegionExpr;
import soot.HjToJimple.jimple.RegionStmt;
import soot.Local;
import soot.Unit;
import soot.UnitBox;
import soot.Value;
import soot.ValueBox;
import soot.jimple.GotoStmt;
import soot.jimple.IfStmt;
import soot.jimple.JimpleBody;
import soot.jimple.NopStmt;
import soot.jimple.Stmt;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.CompleteUnitGraph;
import soot.toolkits.graph.MHGDominatorsFinder;
import soot.toolkits.graph.MHGPostDominatorsFinder;
import soot.toolkits.graph.SimpleDominatorsFinder;
import soot.toolkits.scalar.SimpleLocalDefs;

public class HjWSTool {
    protected JimpleBody body;
    protected SimpleLocalDefs localDefs;
    protected MHGDominatorsFinder mhgDominator;
    protected MHGPostDominatorsFinder mhgPostDominator;
    protected SimpleDominatorsFinder sDominator;

    public HjWSTool(Body body) {
        this.body = (JimpleBody)body;
        this.eliminateNops(body);
        this.localDefs = new SimpleLocalDefs(new CompleteUnitGraph(body));
        this.mhgDominator = new MHGDominatorsFinder(new BriefUnitGraph(body));
        this.mhgPostDominator = new MHGPostDominatorsFinder(new BriefUnitGraph(body));
    }

    protected void eliminateNops(Body body) {
        Iterator<Unit> unitIter = body.getUnits().snapshotIterator();
        while (unitIter.hasNext()) {
            RegionStmt regionStmt;
            Unit unit = unitIter.next();
            if (!(unit instanceof RegionStmt) || !((regionStmt = (RegionStmt)unit).getRegionExpr() instanceof NopRegionExpr)) continue;
            body.getUnits().remove(unit);
        }
    }

    public Body getBody() {
        return this.body;
    }

    protected Stmt seekDom(Stmt stmt) {
        if (stmt instanceof IfStmt || stmt instanceof NopStmt) {
            return (Stmt)this.body.getUnits().getPredOf(stmt);
        }
        List<UnitBox> ptt = stmt.getBoxesPointingToThis();
        if (ptt.size() > 1) {
            for (Unit unit : this.body.getUnits()) {
                if (!(unit instanceof IfStmt ? ((IfStmt)unit).getTarget() == stmt : unit instanceof GotoStmt && ((GotoStmt)unit).getTarget() == stmt)) continue;
                return (Stmt)unit;
            }
        }
        return null;
    }

    public boolean shouldSave(Stmt labelStmt, Local local) {
        List dominators = this.mhgDominator.getOldDominators(labelStmt);
        while (dominators == null || dominators.size() == 0) {
            try {
                labelStmt = (Stmt)this.body.getUnits().getPredOf(labelStmt);
                dominators = this.mhgDominator.getOldDominators(labelStmt);
            }
            catch (Exception e) {
                return false;
            }
        }
        Stmt immDom = (Stmt)this.mhgDominator.getImmediateDominator(labelStmt);
        if (immDom == null) {
            immDom = this.seekDom(labelStmt);
        }
        while (immDom != null) {
            Stmt nextDom;
            if (immDom != labelStmt) {
                Iterator<ValueBox> defBoxes = immDom.getDefBoxes().iterator();
                while (defBoxes.hasNext()) {
                    Value defValue = defBoxes.next().getValue();
                    if (defValue != local) continue;
                    return true;
                }
            }
            if ((nextDom = (Stmt)this.mhgDominator.getImmediateDominator(immDom)) == null) {
                immDom = this.seekDom(immDom);
                continue;
            }
            immDom = nextDom;
        }
        return false;
    }

    public RegionStmt getRegionEntry(RegionStmt regionExit) {
        Stmt predStmt = regionExit;
        RegionStmt regionEntry = (RegionStmt)regionExit.getConnect();
        while (predStmt != null) {
            try {
                predStmt = (Stmt)this.body.getUnits().getPredOf(predStmt);
                if (!(predStmt instanceof RegionStmt)) continue;
                if (predStmt != null) {
                    throw new Error("region: " + predStmt);
                }
                Stmt regionStmt = predStmt;
                if (!regionStmt.isRegionEntry() || !regionStmt.getRegionExpr().getType().equals(regionEntry.getRegionExpr().getType())) continue;
                return regionStmt;
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public boolean shouldSave_(Stmt labelStmt, Local local) {
        List dominators = this.mhgDominator.getOldDominators(labelStmt);
        while (dominators == null || dominators.size() == 1) {
            try {
                labelStmt = (Stmt)this.body.getUnits().getPredOf(labelStmt);
                if (labelStmt instanceof GotoStmt) {
                    return false;
                }
                dominators = this.mhgDominator.getOldDominators(labelStmt);
            }
            catch (Exception e) {
                return false;
            }
        }
        Iterator domIter = this.mhgDominator.getOldDominators(labelStmt).iterator();
        Stmt stmt = null;
        while (domIter.hasNext()) {
            stmt = (Stmt)domIter.next();
            Iterator<ValueBox> defBoxes = stmt.getDefBoxes().iterator();
            while (defBoxes.hasNext()) {
                Value defValue = defBoxes.next().getValue();
                if (defValue != local) continue;
                return true;
            }
        }
        if (this.body.getFirstNonIdentityStmt() == null) {
            return false;
        }
        List postDoms = this.mhgPostDominator.getOldDominators(this.body.getFirstNonIdentityStmt());
        postDoms.add(this.body.getFirstNonIdentityStmt());
        while (stmt != null) {
            try {
                stmt = (Stmt)this.body.getUnits().getPredOf(stmt);
                if (stmt == labelStmt || !postDoms.contains(stmt)) continue;
                Iterator<ValueBox> defBoxes = stmt.getDefBoxes().iterator();
                while (defBoxes.hasNext()) {
                    Value defValue = defBoxes.next().getValue();
                    if (defValue != local) continue;
                    return true;
                }
            }
            catch (Exception e) {
                stmt = null;
            }
        }
        return false;
    }
}

