/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple.utils;

import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.IntegerType;
import soot.LongType;
import soot.PrimType;
import soot.Scene;
import soot.ShortType;
import soot.SootClass;
import soot.SootFieldRef;
import soot.SootMethodRef;
import soot.Type;

public class PrimitiveTypeUtils {
    public static Type getJavaLangType(Type type) {
        return PrimitiveTypeUtils.getJavaLangSootClass(type).getType();
    }

    public static SootMethodRef getJavaLangTypeValueRef(Type type) {
        String xxxValueMthName = PrimitiveTypeUtils.getJavaLangTypeValueRefName(type);
        return PrimitiveTypeUtils.getJavaLangSootClass(type).getMethodByName(xxxValueMthName).makeRef();
    }

    public static SootMethodRef getJavaLangTypeValueOfRef(Type type) {
        String xxxValueMthName = PrimitiveTypeUtils.getJavaLangTypeValueOfRefName(type);
        return PrimitiveTypeUtils.getJavaLangSootClass(type).getMethod(xxxValueMthName).makeRef();
    }

    public static SootClass getCharBoxClass() {
        return Scene.v().getSootClass("java.lang.Character");
    }

    public static SootClass getBooleanBoxClass() {
        return Scene.v().getSootClass("java.lang.Boolean");
    }

    public static SootClass getByteBoxClass() {
        return Scene.v().getSootClass("java.lang.Byte");
    }

    public static SootClass getShortBoxClass() {
        return Scene.v().getSootClass("java.lang.Short");
    }

    public static SootClass getIntegerBoxClass() {
        return Scene.v().getSootClass("java.lang.Integer");
    }

    public static SootClass getLongBoxClass() {
        return Scene.v().getSootClass("java.lang.Long");
    }

    public static SootClass getFloatBoxClass() {
        return Scene.v().getSootClass("java.lang.Float");
    }

    public static SootClass getDoubleBoxClass() {
        return Scene.v().getSootClass("java.lang.Double");
    }

    public static Type getCharBoxType() {
        return PrimitiveTypeUtils.getCharBoxClass().getType();
    }

    public static Type getBooleanBoxType() {
        return PrimitiveTypeUtils.getBooleanBoxClass().getType();
    }

    public static Type getByteBoxType() {
        return PrimitiveTypeUtils.getByteBoxClass().getType();
    }

    public static Type getShortBoxType() {
        return PrimitiveTypeUtils.getShortBoxClass().getType();
    }

    public static Type getIntegerBoxType() {
        return PrimitiveTypeUtils.getIntegerBoxClass().getType();
    }

    public static Type getLongBoxType() {
        return PrimitiveTypeUtils.getLongBoxClass().getType();
    }

    public static Type getFloatBoxType() {
        return PrimitiveTypeUtils.getFloatBoxClass().getType();
    }

    public static Type getDoubleBoxType() {
        return PrimitiveTypeUtils.getDoubleBoxClass().getType();
    }

    public static boolean isBoxType(Type t) {
        return PrimitiveTypeUtils.isCharBoxType(t) || PrimitiveTypeUtils.isBooleanBoxType(t) || PrimitiveTypeUtils.isByteBoxType(t) || PrimitiveTypeUtils.isShortBoxType(t) || PrimitiveTypeUtils.isIntegerBoxType(t) || PrimitiveTypeUtils.isLongBoxType(t) || PrimitiveTypeUtils.isFloatBoxType(t) || PrimitiveTypeUtils.isDoubleBoxType(t);
    }

    public static boolean isCharBoxType(Type t) {
        return PrimitiveTypeUtils.isSameType(t, PrimitiveTypeUtils.getCharBoxType());
    }

    public static boolean isBooleanBoxType(Type t) {
        return PrimitiveTypeUtils.isSameType(t, PrimitiveTypeUtils.getBooleanBoxType());
    }

    public static boolean isByteBoxType(Type t) {
        return PrimitiveTypeUtils.isSameType(t, PrimitiveTypeUtils.getByteBoxType());
    }

    public static boolean isShortBoxType(Type t) {
        return PrimitiveTypeUtils.isSameType(t, PrimitiveTypeUtils.getShortBoxType());
    }

    public static boolean isIntegerBoxType(Type t) {
        return PrimitiveTypeUtils.isSameType(t, PrimitiveTypeUtils.getIntegerBoxType());
    }

    public static boolean isLongBoxType(Type t) {
        return PrimitiveTypeUtils.isSameType(t, PrimitiveTypeUtils.getLongBoxType());
    }

    public static boolean isFloatBoxType(Type t) {
        return PrimitiveTypeUtils.isSameType(t, PrimitiveTypeUtils.getFloatBoxType());
    }

    public static boolean isDoubleBoxType(Type t) {
        return PrimitiveTypeUtils.isSameType(t, PrimitiveTypeUtils.getDoubleBoxType());
    }

    private static boolean isSameType(Type target, Type ref) {
        return target == ref;
    }

    public static String getJavaLangTypeValueRefName(Type type) {
        if (PrimitiveTypeUtils.isCharBoxType(type)) {
            return "charValue";
        }
        if (PrimitiveTypeUtils.isBooleanBoxType(type)) {
            return "booleanValue";
        }
        if (PrimitiveTypeUtils.isByteBoxType(type)) {
            return "byteValue";
        }
        if (PrimitiveTypeUtils.isShortBoxType(type)) {
            return "shortValue";
        }
        if (PrimitiveTypeUtils.isIntegerBoxType(type)) {
            return "intValue";
        }
        if (PrimitiveTypeUtils.isLongBoxType(type)) {
            return "longValue";
        }
        if (PrimitiveTypeUtils.isFloatBoxType(type)) {
            return "floatValue";
        }
        if (PrimitiveTypeUtils.isDoubleBoxType(type)) {
            return "doubleValue";
        }
        throw new RuntimeException("Can't find xxxValue for type: " + type);
    }

    public static String getJavaLangTypeValueOfRefName(Type type) {
        if (PrimitiveTypeUtils.isCharBoxType(type)) {
            return "java.lang.Character valueOf(char)";
        }
        if (PrimitiveTypeUtils.isBooleanBoxType(type)) {
            return "java.lang.Boolean valueOf(boolean)";
        }
        if (PrimitiveTypeUtils.isByteBoxType(type)) {
            return "java.lang.Byte valueOf(byte)";
        }
        if (PrimitiveTypeUtils.isShortBoxType(type)) {
            return "java.lang.Short valueOf(short)";
        }
        if (PrimitiveTypeUtils.isIntegerBoxType(type)) {
            return "java.lang.Integer valueOf(int)";
        }
        if (PrimitiveTypeUtils.isLongBoxType(type)) {
            return "java.lang.Long valueOf(long)";
        }
        if (PrimitiveTypeUtils.isFloatBoxType(type)) {
            return "java.lang.Float valueOf(float)";
        }
        if (PrimitiveTypeUtils.isDoubleBoxType(type)) {
            return "java.lang.Double valueOf(double)";
        }
        throw new RuntimeException("Can't find xxxValue for type: " + type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SootClass getJavaLangSootClass(Type type) {
        String boxClassName = null;
        if (type instanceof PrimType) {
            if (type instanceof CharType) {
                boxClassName = "java.lang.Character";
            } else if (type instanceof BooleanType) {
                boxClassName = "java.lang.Boolean";
            } else if (type instanceof ByteType) {
                boxClassName = "java.lang.Byte";
            } else if (type instanceof ShortType) {
                boxClassName = "java.lang.Short";
            } else if (type instanceof IntType || type instanceof IntegerType) {
                boxClassName = "java.lang.Integer";
            } else if (type instanceof LongType) {
                boxClassName = "java.lang.Long";
            } else if (type instanceof FloatType) {
                boxClassName = "java.lang.Float";
            } else {
                if (!(type instanceof DoubleType)) throw new RuntimeException("Can't find a box for primitive type : " + type);
                boxClassName = "java.lang.Double";
            }
        } else if (PrimitiveTypeUtils.isBoxType(type)) {
            boxClassName = type.toString();
        }
        if (boxClassName != null) return Scene.v().getSootClass(boxClassName);
        throw new RuntimeException("Can't find a box for non-primitive type : " + type);
    }

    public static SootFieldRef getTrueBoolean() {
        return PrimitiveTypeUtils.getBooleanBoxClass().getFieldByName("TRUE").makeRef();
    }

    public static SootFieldRef getFalseBoolean() {
        return PrimitiveTypeUtils.getBooleanBoxClass().getFieldByName("FALSE").makeRef();
    }
}

