/*
 * Decompiled with CFR 0.152.
 */
package soot.javaToJimple;

import java.util.ArrayList;
import java.util.List;
import polyglot.types.MethodInstance;
import soot.Body;
import soot.HjToJimple.Util;
import soot.Local;
import soot.MethodSource;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.VoidType;
import soot.javaToJimple.LocalGenerator;
import soot.jimple.IdentityStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.ParameterRef;
import soot.jimple.Stmt;

public class PrivateMethodAccMethodSource
implements MethodSource {
    private boolean isTargetStatic;
    private String targetMthName;
    private SootClass containerClass;

    public PrivateMethodAccMethodSource(MethodInstance mi) {
        this(((RefType)Util.getSootType((polyglot.types.Type)mi.container())).getSootClass(), mi.name().toString(), mi.flags().isStatic());
    }

    public PrivateMethodAccMethodSource(SootClass containerClass, String targetMthName, boolean isStatic) {
        this.targetMthName = targetMthName;
        this.isTargetStatic = isStatic;
        this.containerClass = containerClass;
    }

    public Body getBody(SootMethod sootMethod, String phaseName) {
        JimpleBody body = Jimple.v().newBody(sootMethod);
        LocalGenerator lg = new LocalGenerator(body);
        Local base = null;
        ArrayList<Local> methParams = new ArrayList<Local>();
        ArrayList<Type> methParamsTypes = new ArrayList<Type>();
        int paramCounter = 0;
        for (Type sootType : sootMethod.getParameterTypes()) {
            Local paramLocal = lg.generateLocal(sootType);
            ParameterRef paramRef = Jimple.v().newParameterRef(sootType, paramCounter);
            IdentityStmt stmt = Jimple.v().newIdentityStmt(paramLocal, paramRef);
            body.getUnits().add(stmt);
            if (!this.isTargetStatic && paramCounter == 0) {
                base = paramLocal;
            } else {
                methParams.add(paramLocal);
                methParamsTypes.add(paramLocal.getType());
            }
            ++paramCounter;
        }
        Local returnLocal = null;
        Type retType = sootMethod.getReturnType();
        if (!(retType instanceof VoidType)) {
            returnLocal = lg.generateLocal(retType);
        }
        List targetMthFormals = this.removeContainerType(sootMethod.getParameterTypes());
        Type targetMthRetType = sootMethod.getReturnType();
        SootMethodRef meth = Scene.v().makeMethodRef(this.containerClass, this.targetMthName, targetMthFormals, targetMthRetType, this.isTargetStatic);
        InvokeExpr invoke = null;
        invoke = this.isTargetStatic ? Jimple.v().newStaticInvokeExpr(meth, methParams) : Jimple.v().newSpecialInvokeExpr(base, meth, methParams);
        Stmt stmt = null;
        stmt = !(retType instanceof VoidType) ? Jimple.v().newAssignStmt(returnLocal, invoke) : Jimple.v().newInvokeStmt(invoke);
        body.getUnits().add(stmt);
        Stmt retStmt = null;
        retStmt = !(retType instanceof VoidType) ? Jimple.v().newReturnStmt(returnLocal) : Jimple.v().newReturnVoidStmt();
        body.getUnits().add(retStmt);
        return body;
    }

    private List removeContainerType(List parameterTypes) {
        if (!this.isTargetStatic) {
            ArrayList l = new ArrayList(parameterTypes);
            l.remove(0);
            return l;
        }
        return parameterTypes;
    }
}

