/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import soot.util.IterableNumberer;
import soot.util.Numberable;

public class ArrayNumberer
implements IterableNumberer {
    Numberable[] numberToObj = new Numberable[1024];
    int lastNumber = 0;

    public void add(Object oo) {
        Numberable o = (Numberable)oo;
        if (o.getNumber() != 0) {
            return;
        }
        ++this.lastNumber;
        if (this.lastNumber >= this.numberToObj.length) {
            Numberable[] newnto = new Numberable[this.numberToObj.length * 2];
            System.arraycopy(this.numberToObj, 0, newnto, 0, this.numberToObj.length);
            this.numberToObj = newnto;
        }
        this.numberToObj[this.lastNumber] = o;
        o.setNumber(this.lastNumber);
    }

    public long get(Object oo) {
        if (oo == null) {
            return 0L;
        }
        Numberable o = (Numberable)oo;
        int ret = o.getNumber();
        if (ret == 0) {
            throw new RuntimeException("unnumbered: " + o);
        }
        return ret;
    }

    public Object get(long number) {
        if (number == 0L) {
            return null;
        }
        Numberable ret = this.numberToObj[(int)number];
        if (ret == null) {
            throw new RuntimeException("no object with number " + number);
        }
        return ret;
    }

    public int size() {
        return this.lastNumber;
    }

    public Iterator iterator() {
        return new NumbererIterator();
    }

    final class NumbererIterator
    implements Iterator {
        int cur = 1;

        NumbererIterator() {
        }

        public final boolean hasNext() {
            return this.cur < ArrayNumberer.this.numberToObj.length && ArrayNumberer.this.numberToObj[this.cur] != null;
        }

        public final Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return ArrayNumberer.this.numberToObj[this.cur++];
        }

        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

